/*
 * Decompiled with CFR 0.152.
 */
package de.upb.javaast.methodast.visitors;

import de.uni_paderborn.fujaba.asg.ASGVisitor;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.upb.javaast.methodast.AllocationNode;
import de.upb.javaast.methodast.AssignmentNode;
import de.upb.javaast.methodast.BinaryExpressionNode;
import de.upb.javaast.methodast.BlockNode;
import de.upb.javaast.methodast.CaseNode;
import de.upb.javaast.methodast.CatchBlockNode;
import de.upb.javaast.methodast.DoNode;
import de.upb.javaast.methodast.ExpressionNode;
import de.upb.javaast.methodast.ForNode;
import de.upb.javaast.methodast.IdentifierNode;
import de.upb.javaast.methodast.IfNode;
import de.upb.javaast.methodast.InstanceOfExpressionNode;
import de.upb.javaast.methodast.JavaASTNode;
import de.upb.javaast.methodast.LoopNode;
import de.upb.javaast.methodast.MethodCallNode;
import de.upb.javaast.methodast.PrimaryExpressionNode;
import de.upb.javaast.methodast.ReturnNode;
import de.upb.javaast.methodast.RootBlockNode;
import de.upb.javaast.methodast.StatementExpressionNode;
import de.upb.javaast.methodast.StatementNode;
import de.upb.javaast.methodast.SwitchNode;
import de.upb.javaast.methodast.TryNode;
import de.upb.javaast.methodast.TypeCastNode;
import de.upb.javaast.methodast.TypeNode;
import de.upb.javaast.methodast.VariableDeclarationNode;
import de.upb.javaast.methodast.VariableIdentifierDeclarationNode;
import de.upb.javaast.methodast.WhileNode;
import java.util.Iterator;

public abstract class MethodASTVisitor
extends ASGVisitor {
    public void visitUMLMethod(UMLMethod umlMethod) {
        if (umlMethod.getASTRootNode() != null) {
            this.visit((FElement)umlMethod.getASTRootNode());
        }
    }

    public void visitJavaASTNode(JavaASTNode javaAstNode) {
    }

    public void visitRootBlockNode(RootBlockNode rootBlockNode) {
        this.visit((FElement)rootBlockNode.getBlock());
    }

    public void visitStatementNode(StatementNode statementNode) {
    }

    public void visitBlockNode(BlockNode blockNode) {
        Iterator iter = blockNode.iteratorOfStatements();
        while (iter.hasNext()) {
            this.visit(iter.next());
        }
    }

    public void visitLoopNode(LoopNode loopNode) {
        this.visit((FElement)loopNode.getLoopExpression());
        this.visit((FElement)loopNode.getLoopBlock());
    }

    public void visitForNode(ForNode forNode) {
        Iterator iter = forNode.iteratorOfInitStatements();
        while (iter.hasNext()) {
            this.visit(iter.next());
        }
        if (forNode.getLoopExpression() != null) {
            this.visit((FElement)forNode.getLoopExpression());
        }
        iter = forNode.iteratorOfUpdateExpressions();
        while (iter.hasNext()) {
            this.visit(iter.next());
        }
        this.visit((FElement)forNode.getLoopBlock());
    }

    public void visitDoNode(DoNode doNode) {
        this.visit((FElement)doNode.getLoopBlock());
        this.visit((FElement)doNode.getLoopExpression());
    }

    public void visitWhileNode(WhileNode whileNode) {
        this.visit((FElement)whileNode.getLoopExpression());
        this.visit((FElement)whileNode.getLoopBlock());
    }

    public void visitTryNode(TryNode tryNode) {
        this.visit((FElement)tryNode.getTryBlock());
        Iterator iter = tryNode.iteratorOfCatchBlocks();
        while (iter.hasNext()) {
            this.visit(iter.next());
        }
        if (tryNode.getFinallyBlock() != null) {
            this.visit((FElement)tryNode.getFinallyBlock());
        }
    }

    public void visitCatchBlockNode(CatchBlockNode catchBlockNode) {
        this.visit((FElement)catchBlockNode.getExceptionDeclaration());
        Iterator iter = catchBlockNode.iteratorOfStatements();
        while (iter.hasNext()) {
            this.visit(iter.next());
        }
    }

    public void visitSwitchNode(SwitchNode switchNode) {
        this.visit((FElement)switchNode.getSwitchExpression());
        Iterator iter = switchNode.iteratorOfCaseStatements();
        while (iter.hasNext()) {
            this.visit(iter.next());
        }
    }

    public void visitCaseNode(CaseNode caseNode) {
        if (caseNode.getCaseBlock() != null) {
            this.visit((FElement)caseNode.getCaseBlock());
        }
    }

    public void visitIfNode(IfNode ifNode) {
        this.visit((FElement)ifNode.getExpression());
        this.visit((FElement)ifNode.getIfBlock());
        if (ifNode.getElseBlock() != null) {
            this.visit((FElement)ifNode.getElseBlock());
        }
    }

    public void visitVariableDeclarationNode(VariableDeclarationNode variableDeclarationNode) {
        this.visit((FElement)variableDeclarationNode.getType());
        Iterator iter = variableDeclarationNode.iteratorOfIdDeclarations();
        while (iter.hasNext()) {
            this.visit(iter.next());
        }
    }

    public void visitTypeNode(TypeNode typeNode) {
        Iterator iter = typeNode.iteratorOfIdentifiers();
        while (iter.hasNext()) {
            this.visit(iter.next());
        }
    }

    public void visitVariableIdentifierDeclarationNode(VariableIdentifierDeclarationNode varIdDeclNode) {
        this.visit((FElement)varIdDeclNode.getIdentifier());
        if (varIdDeclNode.getInitialValue() != null) {
            this.visit((FElement)varIdDeclNode.getInitialValue());
        }
    }

    public void visitIdentifierNode(IdentifierNode identifierNode) {
    }

    public void visitReturnNode(ReturnNode returnNode) {
        if (returnNode.getReturnExpression() != null) {
            this.visit((FElement)returnNode.getReturnExpression());
        }
    }

    public void visitStatementExpressionNode(StatementExpressionNode statementExpressionNode) {
        if (statementExpressionNode.getExpression() != null) {
            this.visit((FElement)statementExpressionNode.getExpression());
        }
    }

    public void visitExpressionNode(ExpressionNode expressionNode) {
    }

    public void visitBinaryExpressionNode(BinaryExpressionNode binaryExpressionNode) {
        if (binaryExpressionNode.getLeftExpression() != null) {
            this.visit((FElement)binaryExpressionNode.getLeftExpression());
        }
        if (binaryExpressionNode.getRightExpression() != null) {
            this.visit((FElement)binaryExpressionNode.getRightExpression());
        }
    }

    public void visitAssignmentNode(AssignmentNode assignmentNode) {
        this.visit((FElement)assignmentNode.getLeftExpression());
        this.visit((FElement)assignmentNode.getRightExpression());
    }

    public void visitPrimaryExpressionNode(PrimaryExpressionNode primaryExpressionNode) {
        if (primaryExpressionNode.getIdentifier() != null) {
            this.visit((FElement)primaryExpressionNode.getIdentifier());
        }
        if (primaryExpressionNode.getExpression() != null) {
            this.visit((FElement)primaryExpressionNode.getExpression());
        }
        if (primaryExpressionNode.getNextPrimaryExpression() != null) {
            this.visit((FElement)primaryExpressionNode.getNextPrimaryExpression());
        }
    }

    public void visitInstanceOfExpressionNode(InstanceOfExpressionNode instanceOfExpressionNode) {
        if (instanceOfExpressionNode.getExpression() != null) {
            this.visit((FElement)instanceOfExpressionNode.getExpression());
        }
        if (instanceOfExpressionNode.getType() != null) {
            this.visit((FElement)instanceOfExpressionNode.getType());
        }
    }

    public void visitMethodCallNode(MethodCallNode methodCallNode) {
        this.visit((FElement)methodCallNode.getIdentifier());
        Iterator iter = methodCallNode.iteratorOfArguments();
        while (iter.hasNext()) {
            this.visit(iter.next());
        }
        if (methodCallNode.getNextPrimaryExpression() != null) {
            this.visit((FElement)methodCallNode.getNextPrimaryExpression());
        }
    }

    public void visitTypeCastNode(TypeCastNode typeCastNode) {
        this.visit((FElement)typeCastNode.getType());
        if (typeCastNode.getExpression() != null) {
            this.visit((FElement)typeCastNode.getExpression());
        }
    }

    public void visitAllocationNode(AllocationNode allocationNode) {
        if (allocationNode.getExpression() != null) {
            this.visit((FElement)allocationNode.getExpression());
        }
        Iterator iter = allocationNode.iteratorOfArguments();
        while (iter.hasNext()) {
            this.visit(iter.next());
        }
        if (allocationNode.getNextPrimaryExpression() != null) {
            this.visit((FElement)allocationNode.getNextPrimaryExpression());
        }
    }
}

