/*
 * Decompiled with CFR 0.152.
 */
package de.upb.javaast.methodast.tests;

import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.metamodel.FStereotype;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStereotype;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class MethodASTCompareTest {
    public static boolean checkUMLProject() {
        boolean testPassed = true;
        Iterator iter = UMLProject.get().iteratorOfDiags();
        while (iter.hasNext()) {
            ASGDiagram asgDiagram = (ASGDiagram)iter.next();
            if (!(asgDiagram instanceof UMLClassDiagram)) continue;
            boolean bl = testPassed = MethodASTCompareTest.checkUMLClassDiagram((UMLClassDiagram)asgDiagram) && testPassed;
        }
        return testPassed;
    }

    public static boolean checkUMLClassDiagram(UMLClassDiagram umlClassDiagram) {
        boolean testPassed = true;
        Iterator iter = umlClassDiagram.iteratorOfElements();
        while (iter.hasNext()) {
            UMLDiagramItem umlDiagramItem = (UMLDiagramItem)iter.next();
            if (!(umlDiagramItem instanceof UMLClass)) continue;
            UMLClass umlClass = (UMLClass)umlDiagramItem;
            boolean bl = testPassed = MethodASTCompareTest.checkUMLClass(umlClass) && testPassed;
        }
        return testPassed;
    }

    public static boolean checkUMLClass(UMLClass umlClass) {
        boolean testPassed = true;
        UMLStereotype stereotypeInterface = UMLProject.get().getStereotypeManager().getFromStereotypes("interface");
        if (!umlClass.hasInStereotypes((FStereotype)stereotypeInterface)) {
            Iterator iter = umlClass.iteratorOfMethods();
            while (iter.hasNext()) {
                UMLMethod umlMethod = (UMLMethod)iter.next();
                boolean bl = testPassed = MethodASTCompareTest.checkUMLMethod(umlMethod) && testPassed;
            }
        }
        return testPassed;
    }

    public static boolean checkUMLMethod(UMLMethod umlMethod) {
        boolean testPassed = true;
        if (!umlMethod.isAbstract() && umlMethod.getMethodBody() != null && umlMethod.getASTRootNode() != null) {
            String originalSourceCode = umlMethod.getMethodBody();
            String astSourceCode = umlMethod.getASTRootNode().toString();
            testPassed = originalSourceCode.equals(astSourceCode);
        } else if (umlMethod.getMethodBody() != null && umlMethod.getASTRootNode() == null || umlMethod.getMethodBody() == null && umlMethod.getASTRootNode() != null) {
            testPassed = false;
        }
        if (!testPassed) {
            System.out.println("Method AST of '" + umlMethod.getParent() + "." + umlMethod.getName() + "' is corrupt!");
            JOptionPane.showMessageDialog(null, "Method AST of '" + umlMethod.getParent() + "." + umlMethod.getName() + "' is corrupt!\nMethod ASTs will be exported to the export folder.", "Test failed!", 0);
            String exportFolder = GeneralPreferences.get().getExportFolder();
            try {
                File file = new File(String.valueOf(exportFolder) + File.separator + umlMethod.getParent().getName() + "_" + umlMethod.getName() + ".original.txt");
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(umlMethod.getMethodBody());
                fileWriter.close();
                file = new File(String.valueOf(exportFolder) + File.separator + umlMethod.getParent().getName() + "_" + umlMethod.getName() + ".ASTDump.txt");
                fileWriter = new FileWriter(file);
                if (umlMethod.getASTRootNode() != null) {
                    fileWriter.write(umlMethod.getASTRootNode().toString());
                } else {
                    fileWriter.write("Method AST is null!");
                }
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return testPassed;
    }
}

