/*
 * Decompiled with CFR 0.152.
 */
package de.upb.javaast.methodast;

import de.upb.javaast.methodast.BlockNode;
import de.upb.javaast.methodast.CatchBlockNode;
import de.upb.javaast.methodast.StatementNode;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FLinkedList;
import java.util.Iterator;

public class TryNode
extends StatementNode {
    private String tryText;
    private String finallyText;
    private FLinkedList catchBlocks;
    private BlockNode tryBlock;
    private BlockNode finallyBlock;

    public String getTryText() {
        return this.tryText;
    }

    public void setTryText(String value) {
        this.tryText = value;
    }

    public String getFinallyText() {
        return this.finallyText;
    }

    public void setFinallyText(String value) {
        this.finallyText = value;
    }

    public boolean addToCatchBlocks(CatchBlockNode value) {
        boolean changed = false;
        if (value != null && !this.hasInCatchBlocks(value)) {
            if (this.catchBlocks == null) {
                this.catchBlocks = new FLinkedList();
            }
            if (changed = this.catchBlocks.add((Object)value)) {
                value.setTryStatement(this);
            }
        }
        return changed;
    }

    public boolean hasInCatchBlocks(CatchBlockNode value) {
        return this.catchBlocks != null && value != null && this.catchBlocks.contains((Object)value);
    }

    public Iterator iteratorOfCatchBlocks() {
        return this.catchBlocks == null ? FEmptyIterator.get() : this.catchBlocks.iterator();
    }

    public void removeAllFromCatchBlocks() {
        Iterator iter = this.iteratorOfCatchBlocks();
        while (iter.hasNext()) {
            CatchBlockNode tmpValue = (CatchBlockNode)((Object)iter.next());
            this.removeFromCatchBlocks(tmpValue);
        }
    }

    public boolean removeFromCatchBlocks(CatchBlockNode value) {
        boolean changed = false;
        if (this.catchBlocks != null && value != null && (changed = this.catchBlocks.remove((Object)value))) {
            value.setTryStatement(null);
        }
        return changed;
    }

    public int sizeOfCatchBlocks() {
        return this.catchBlocks == null ? 0 : this.catchBlocks.size();
    }

    public BlockNode getTryBlock() {
        return this.tryBlock;
    }

    public boolean setTryBlock(BlockNode value) {
        boolean changed = false;
        if (this.tryBlock != value) {
            if (this.tryBlock != null) {
                BlockNode oldValue = this.tryBlock;
                this.tryBlock = null;
                oldValue.setTryStatement(null);
            }
            this.tryBlock = value;
            if (value != null) {
                value.setTryStatement(this);
            }
            changed = true;
        }
        return changed;
    }

    public BlockNode getFinallyBlock() {
        return this.finallyBlock;
    }

    public boolean setFinallyBlock(BlockNode value) {
        boolean changed = false;
        if (this.finallyBlock != value) {
            if (this.finallyBlock != null) {
                BlockNode oldValue = this.finallyBlock;
                this.finallyBlock = null;
                oldValue.setFinallyStatement(null);
            }
            this.finallyBlock = value;
            if (value != null) {
                value.setFinallyStatement(this);
            }
            changed = true;
        }
        return changed;
    }

    public StringBuffer getSourceCode() {
        StringBuffer buffer = new StringBuffer(this.getTryText());
        buffer.append(this.getTryBlock().getSourceCode());
        Iterator iter = this.iteratorOfCatchBlocks();
        while (iter.hasNext()) {
            CatchBlockNode catchBlockNode = (CatchBlockNode)((Object)iter.next());
            buffer.append(catchBlockNode.getSourceCode());
        }
        if (this.getFinallyBlock() != null) {
            buffer.append(this.getFinallyText());
            buffer.append(this.getFinallyBlock().getSourceCode());
        }
        return buffer;
    }

    public void removeYou() {
        BlockNode tmpFinallyBlock;
        this.removeAllFromCatchBlocks();
        BlockNode tmpTryBlock = this.getTryBlock();
        if (tmpTryBlock != null) {
            this.setTryBlock(null);
        }
        if ((tmpFinallyBlock = this.getFinallyBlock()) != null) {
            this.setFinallyBlock(null);
        }
        super.removeYou();
    }
}

