/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.sdm;

import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.sdm.EventDebugInterface;
import de.upb.tools.sdm.FEvent;
import de.upb.tools.sdm.FReactive;
import de.upb.tools.sdm.FState;
import de.upb.tools.sdm.FTimer;
import de.upb.tools.sdm.ProtocolQueueEntry;
import java.util.HashMap;
import java.util.Iterator;

public class Protocolizer {
    private FReactive freactive;
    private FHashSet debugger;
    private boolean protocolize = false;
    private boolean protocolIsReady = false;
    private boolean protocolInit = false;
    private boolean protocolTimer = false;
    private HashMap events = new HashMap();

    public Protocolizer() {
    }

    public Protocolizer(FReactive freactive) {
        this.setFreactive(freactive);
    }

    public FReactive getFreactive() {
        return this.freactive;
    }

    public boolean setFreactive(FReactive value) {
        boolean changed = false;
        if (this.freactive != value) {
            if (this.freactive != null) {
                FReactive oldValue = this.freactive;
                this.freactive = null;
                oldValue.setProtocolizer(null);
            }
            this.freactive = value;
            if (value != null) {
                value.setProtocolizer(this);
            }
            changed = true;
        }
        return changed;
    }

    public boolean addToDebugger(EventDebugInterface value) {
        boolean changed = false;
        if (value != null) {
            if (this.debugger == null) {
                this.debugger = new FHashSet();
            }
            changed = this.debugger.add(value);
        }
        return changed;
    }

    public boolean hasInDebugger(EventDebugInterface value) {
        return this.debugger != null && value != null && this.debugger.contains(value);
    }

    public Iterator iteratorOfDebugger() {
        return this.debugger == null ? FEmptyIterator.get() : this.debugger.iterator();
    }

    public boolean protocolWindowIsRunning() {
        boolean i = false;
        Iterator itod = this.iteratorOfDebugger();
        while (itod.hasNext()) {
            itod.next();
        }
        return i;
    }

    public void removeAllFromDebugger() {
        Iterator iter = this.iteratorOfDebugger();
        while (iter.hasNext()) {
            EventDebugInterface tmpValue = (EventDebugInterface)iter.next();
            this.removeFromDebugger(tmpValue);
        }
    }

    public boolean removeFromDebugger(EventDebugInterface value) {
        boolean changed = false;
        if (this.debugger != null && value != null) {
            changed = this.debugger.remove(value);
        }
        return changed;
    }

    public int sizeOfDebugger() {
        return this.debugger == null ? 0 : this.debugger.size();
    }

    public void removeYou() {
        FReactive tmpFreactive = this.getFreactive();
        if (tmpFreactive != null) {
            this.setFreactive(null);
        }
        this.removeAllFromDebugger();
    }

    public boolean isProtocolize() {
        return this.protocolize;
    }

    public void setProtocolize(boolean newProtocolize) {
        if (this.protocolize != newProtocolize) {
            this.protocolize = newProtocolize;
        }
    }

    public boolean isProtocolIsReady() {
        return this.protocolIsReady;
    }

    public void setProtocolIsReady(boolean newProtocolIsReady) {
        if (this.protocolIsReady != newProtocolIsReady) {
            this.protocolIsReady = newProtocolIsReady;
        }
    }

    public boolean isProtocolInit() {
        return this.protocolInit;
    }

    public void setProtocolInit(boolean newProtocolInit) {
        if (this.protocolInit != newProtocolInit) {
            this.protocolInit = newProtocolInit;
        }
    }

    public void setProtocolTimer(boolean newProtocolTimer) {
        this.protocolTimer = newProtocolTimer;
    }

    public boolean isProtocolTimer() {
        return this.protocolTimer;
    }

    private boolean protocolEvent(FEvent event) {
        boolean ok = true;
        if (!this.isProtocolIsReady() && event.getName().endsWith("IsReady")) {
            ok = false;
        }
        if (!this.isProtocolInit() && event.getName().startsWith("INIT_")) {
            ok = false;
        }
        if (!this.isProtocolTimer() && event.getName().startsWith("after")) {
            ok = false;
        }
        return ok;
    }

    public void incomingEvent(FEvent event, int priority, boolean front) {
        Iterator iter;
        FReactive fr;
        if (!this.isProtocolize()) {
            return;
        }
        if (!this.protocolEvent(event)) {
            return;
        }
        ProtocolQueueEntry pqe = new ProtocolQueueEntry();
        pqe.setId(event.hashCode());
        pqe.setEventName(event.getName());
        pqe.setPriority(priority);
        pqe.setStateName("unknown");
        pqe.setFront(front);
        Thread curThread = Thread.currentThread();
        if (curThread instanceof FTimer) {
            FTimer ft = (FTimer)curThread;
            fr = ft.getFReactive();
            pqe.setEventName("timer");
        } else {
            fr = curThread instanceof FReactive.FReactiveThread ? ((FReactive.FReactiveThread)curThread).getFReactive() : null;
        }
        if (fr != null) {
            iter = this.getFreactive().iteratorOfCurrent();
            String temp = "";
            while (iter.hasNext()) {
                FState state = (FState)iter.next();
                temp = temp + state.getName() + " ";
            }
            pqe.setStateName(temp);
            Object handler = fr.getHandler();
            if (fr == this.getFreactive()) {
                pqe.setSenderName("myself");
            } else {
                pqe.setSenderName(handler.getClass().getName() + ":" + handler.hashCode());
            }
        } else {
            pqe.setSenderName(Thread.currentThread().toString());
        }
        this.events.put(event, pqe);
        iter = this.iteratorOfDebugger();
        while (iter.hasNext()) {
            EventDebugInterface debugger = (EventDebugInterface)iter.next();
            debugger.incomingEvent(pqe);
        }
    }

    public void outgoingEvent(FEvent event, FReactive receiver, int priority, boolean front) {
        if (!this.isProtocolize()) {
            return;
        }
        if (!this.protocolEvent(event)) {
            return;
        }
        ProtocolQueueEntry pqe = new ProtocolQueueEntry();
        Iterator iter = this.getFreactive().iteratorOfCurrent();
        String temp = "";
        while (iter.hasNext()) {
            FState state = (FState)iter.next();
            temp = temp + state.getName() + " ";
        }
        pqe.setStateName(temp);
        if (receiver == this.getFreactive()) {
            pqe.setSenderName("myself");
        } else {
            pqe.setSenderName(receiver.getHandler().getClass().getName() + ":" + receiver.getHandler().hashCode());
        }
        pqe.setEventName(event.getName());
        pqe.setId(event.hashCode());
        pqe.setPriority(priority);
        pqe.setFront(front);
        iter = this.iteratorOfDebugger();
        while (iter.hasNext()) {
            EventDebugInterface debugger = (EventDebugInterface)iter.next();
            debugger.outgoingEvent(pqe);
        }
    }

    public void processEvent(FEvent event, int priority) {
        if (!this.isProtocolize()) {
            return;
        }
        if (!this.protocolEvent(event)) {
            return;
        }
        Object cur = this.events.get(event);
        if (cur != null) {
            ProtocolQueueEntry pqe = (ProtocolQueueEntry)cur;
            Iterator iter = this.iteratorOfDebugger();
            while (iter.hasNext()) {
                EventDebugInterface debugger = (EventDebugInterface)iter.next();
                debugger.processEvent(pqe);
            }
        } else {
            System.out.println("no such event while process " + event);
        }
    }

    public void rejectEvent(FEvent event) {
        if (!this.isProtocolize()) {
            return;
        }
        if (!this.protocolEvent(event)) {
            return;
        }
        Object cur = this.events.remove(event);
        if (cur != null) {
            ProtocolQueueEntry pqe = (ProtocolQueueEntry)cur;
            Iterator iter = this.iteratorOfDebugger();
            while (iter.hasNext()) {
                EventDebugInterface debugger = (EventDebugInterface)iter.next();
                debugger.rejectEvent(pqe);
            }
        } else {
            System.out.println("no such event while reject " + event);
        }
    }

    public void acknowledgeEvent(FEvent event) {
        if (!this.isProtocolize()) {
            return;
        }
        if (!this.protocolEvent(event)) {
            return;
        }
        Object cur = this.events.remove(event);
        if (cur != null) {
            ProtocolQueueEntry pqe = (ProtocolQueueEntry)cur;
            Iterator iter = this.iteratorOfDebugger();
            while (iter.hasNext()) {
                EventDebugInterface debugger = (EventDebugInterface)iter.next();
                debugger.acknowledgeEvent(pqe);
            }
        } else {
            System.out.println("no such event while acknowledge " + event);
        }
    }
}

