/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.sdm;

import de.upb.tools.fca.EnumerationForAnIterator;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.sdm.EnumUnion;
import de.upb.tools.sdm.IterUnion;
import de.upb.tools.sdm.OneElementEnum;
import de.upb.tools.sdm.OrPath;
import de.upb.tools.sdm.StarPath;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Path
implements Enumeration,
Iterator {
    private String expr = null;
    private StringTokenizer tokens;
    private String word;
    private Path subPath;
    protected Enumeration myEnum = null;
    protected Object sourceItem = null;
    protected Enumeration sourceEnum = null;
    private Method getMethod = null;
    private Method getEnum = null;
    private Method getIter = null;
    protected FHashSet results = null;
    protected Enumeration resultsEnumeration = null;

    public Path() {
    }

    public Path(Enumeration myEnum) {
        this();
        this.myEnum = myEnum;
    }

    public Path(String expr) {
        this(null, expr);
    }

    public Path(Object start, String expr) {
        this();
        this.parseComplexExpr(expr);
        this.setSourceItem(start);
    }

    public static String upFirstChar(String strg) {
        if (strg.length() != 0) {
            StringBuffer newBuf = new StringBuffer(strg);
            newBuf.setCharAt(0, Character.toUpperCase(newBuf.charAt(0)));
            return newBuf.toString();
        }
        return strg;
    }

    public void parseComplexExpr(String expr) {
        this.tokens = new StringTokenizer(expr, ".()* ", true);
        this.lookUpNextToken();
        if (this.word != null) {
            this.parsePathExpr();
        }
        this.myEnum = this.subPath;
    }

    private void parsePathExpr() {
        this.parseDottedList();
        while ("or".equals(this.word)) {
            Path orPath = this.subPath;
            this.lookUpNextToken();
            this.parseDottedList();
            this.subPath = orPath.or(this.subPath);
        }
    }

    private void parseDottedList() {
        Path dotPath = null;
        this.parseProperty();
        while (".".equals(this.word)) {
            dotPath = this.subPath;
            this.lookUpNextToken();
            this.parseProperty();
            this.subPath = dotPath.dot(this.subPath);
        }
    }

    private void parseProperty() {
        this.parseBasicProperty();
        if ("*".equals(this.word)) {
            this.subPath = this.subPath.star();
            this.lookUpNextToken();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseBasicProperty() {
        if ("(".equals(this.word)) {
            this.subPath = null;
            this.lookUpNextToken();
            this.parsePathExpr();
            if (!")".equals(this.word)) throw new RuntimeException("Malformed path expression, expected \")\", got \"" + this.word + "\"");
            this.lookUpNextToken();
            return;
        } else {
            this.subPath = new Path();
            this.subPath.expr = this.word;
            this.lookUpNextToken();
        }
    }

    private void lookUpNextToken() {
        boolean done = false;
        while (!done) {
            if (this.tokens.hasMoreTokens()) {
                this.word = this.tokens.nextToken().trim();
                done = !"".equals(this.word);
                continue;
            }
            this.word = null;
            done = true;
        }
    }

    public Enumeration getMyEnum() {
        return this.myEnum;
    }

    protected Object getTarget(Object source) {
        if (this.getMethod != null) {
            try {
                return this.getMethod.invoke(source, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected Enumeration createEnumeration(Object obj) {
        if (this.getEnum != null) {
            try {
                return (Enumeration)this.getEnum.invoke(obj, null);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.getIter != null) {
            try {
                return new EnumerationForAnIterator((Iterator)this.getIter.invoke(obj, null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean hasMoreElements() {
        if (this.myEnum != null) {
            this.resultsEnumeration = this.myEnum;
            this.myEnum = null;
        }
        if (this.resultsEnumeration == null) {
            this.fillResults();
        }
        if (this.resultsEnumeration != null) {
            return this.resultsEnumeration.hasMoreElements();
        }
        return false;
    }

    public Object nextElement() {
        return this.resultsEnumeration.nextElement();
    }

    private void fillResults() {
        this.results = new FHashSet();
        Enumeration tmpEnum = this.sourceEnum;
        if (tmpEnum == null) {
            tmpEnum = new OneElementEnum(this.sourceItem);
        }
        while (tmpEnum.hasMoreElements()) {
            Object nextSourceItem = tmpEnum.nextElement();
            this.applyExpr(nextSourceItem);
        }
        this.resultsEnumeration = new EnumerationForAnIterator(this.results.iterator());
    }

    private void applyExpr(Object nextSourceItem) {
        Class<?> sourceClass = nextSourceItem.getClass();
        boolean extensionFound = this.lookForGetMethod(sourceClass);
        if (extensionFound) {
            Object tmp = this.getTarget(nextSourceItem);
            if (tmp != null) {
                this.results.add(tmp);
            }
            return;
        }
        boolean bl = extensionFound = this.lookForElementsOfMethod(sourceClass) || this.lookForIteratorOfMethod(sourceClass);
        if (extensionFound) {
            Enumeration tmpEnum = this.createEnumeration(nextSourceItem);
            while (tmpEnum.hasMoreElements()) {
                Object tmp = tmpEnum.nextElement();
                this.results.add(tmp);
            }
        }
    }

    public boolean hasNext() {
        return this.hasMoreElements();
    }

    private boolean lookForIteratorOfMethod(Class sourceClass) {
        try {
            String search = "iteratorOf" + Path.upFirstChar(this.expr);
            this.getIter = sourceClass.getMethod(search, null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean lookForElementsOfMethod(Class sourceClass) {
        try {
            String search = "elementsOf" + Path.upFirstChar(this.expr);
            this.getEnum = sourceClass.getMethod(search, null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean lookForGetMethod(Class sourceClass) {
        String search = "get" + Path.upFirstChar(this.expr);
        try {
            this.getMethod = sourceClass.getMethod(search, null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object next() {
        return this.nextElement();
    }

    public void remove() {
    }

    public void setSourceItem(Object obj) {
        this.results = null;
        this.resultsEnumeration = null;
        if (this.myEnum != null && this.myEnum instanceof Path) {
            ((Path)this.myEnum).setSourceItem(obj);
        } else if (this.sourceEnum != null && this.sourceEnum instanceof Path) {
            ((Path)this.sourceEnum).setSourceItem(obj);
        } else {
            this.sourceItem = obj;
        }
    }

    public Object getSourceItem() {
        return this.sourceItem;
    }

    public void setSourceEnum(Enumeration sourceEnum) {
        this.sourceEnum = sourceEnum;
    }

    public Path getStartOfPath() {
        if (this.myEnum != null && this.myEnum instanceof Path) {
            return ((Path)this.myEnum).getStartOfPath();
        }
        if (this.sourceEnum != null && this.sourceEnum instanceof Path) {
            return ((Path)this.sourceEnum).getStartOfPath();
        }
        if (this.subPath != null) {
            return this.subPath.getStartOfPath();
        }
        return this;
    }

    public static Enumeration enumUnion(Enumeration e1, Enumeration e2) {
        return new EnumUnion(e1, e2);
    }

    public static Iterator iterUnion(Iterator e1, Iterator e2) {
        return new IterUnion(e1, e2);
    }

    public static Path union(Path enum1, Path enum2) {
        OrPath resultPath = new OrPath(enum1, enum2);
        return resultPath;
    }

    public Path or(Path enumeration) {
        return Path.union(this, enumeration);
    }

    public Path star() {
        return new StarPath(this);
    }

    public Path dot(Path secondPath) {
        secondPath.getStartOfPath().setSourceEnum(this);
        return secondPath;
    }

    public Path sortByToString() {
        ArrayList tmpArrayList = Collections.list(this);
        Collections.sort(tmpArrayList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        Path result = new Path(new EnumerationForAnIterator(tmpArrayList.iterator()));
        return result;
    }
}

