/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.sdm;

import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import de.upb.tools.sdm.FAdjustObjectListener;
import de.upb.tools.sdm.FComplexState;
import de.upb.tools.sdm.FEvent;
import de.upb.tools.sdm.FPeriodicTimer;
import de.upb.tools.sdm.FReactiveManager;
import de.upb.tools.sdm.FState;
import de.upb.tools.sdm.FTimer;
import de.upb.tools.sdm.FTransition;
import de.upb.tools.sdm.Protocolizer;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;

public class FReactive {
    public static final String READY_EVENT_PREFIX = "READY_";
    public static final String READY_EVENT_POSTFIX = "IsReady";
    public static final String TIMER_EVENT_PREFIX = "TIMER";
    public static final String INIT_EVENT_PREFIX = "INIT_";
    public static final String ELSE_GUARD = "ELSE";
    public static final int INTERNAL_EVENT = 0;
    public static final int DEFERRED_EVENT = 1;
    public static final int EXTERNAL_EVENT = 2;
    public static final String[] PRIORITY_NAMES = new String[]{"INTERNAL", "DEFERRED", "EXTERNAL"};
    private Thread thread;
    private Protocolizer protocolizer;
    private FReactiveManager manager;
    private LinkedList current;
    private LinkedList newDeferredEventsQueue;
    private LinkedList[] eventQueue;
    private FHashMap timers = new FHashMap();
    private final Object freezeLock = new Object();
    private int freezeCounter = 0;
    private boolean stopped = false;
    private FHashMap periodicTimers = new FHashMap();
    private Object handler;
    private Method notifyOfHandler = null;

    public Thread getThread() {
        return this.thread;
    }

    public FReactive() {
        this.eventQueue = new LinkedList[3];
        this.eventQueue[0] = new LinkedList();
        this.eventQueue[1] = new LinkedList();
        this.eventQueue[2] = new LinkedList();
        this.newDeferredEventsQueue = new LinkedList();
        FReactiveManager.get().addToFreactives(this);
    }

    public boolean setProtocolizer(Protocolizer value) {
        boolean changed = false;
        if (this.protocolizer != value) {
            if (this.protocolizer != null) {
                Protocolizer oldValue = this.protocolizer;
                this.protocolizer = null;
                oldValue.setFreactive(null);
            }
            this.protocolizer = value;
            if (value != null) {
                value.setFreactive(this);
            }
            changed = true;
        }
        return changed;
    }

    public Protocolizer getProtocolizer() {
        return this.protocolizer;
    }

    public boolean setManager(FReactiveManager value) {
        boolean changed = false;
        if (this.manager != value) {
            if (this.manager != null) {
                FReactiveManager oldValue = this.manager;
                this.manager = null;
                oldValue.removeFromFreactives(this);
            }
            this.manager = value;
            if (value != null) {
                value.addToFreactives(this);
            }
            changed = true;
        }
        return changed;
    }

    public FReactiveManager getManager() {
        return this.manager;
    }

    public FState getCurrent() {
        return this.getFirstFromCurrent();
    }

    public void setCurrent(FState state) {
        this.removeAllFromCurrent();
        this.addToCurrent(state);
    }

    public FState getFirstFromCurrent() {
        return this.current.isEmpty() ? null : (FState)this.current.getFirst();
    }

    public void addToCurrent(FState elem) {
        if (elem != null && !this.hasInCurrent(elem)) {
            if (this.current == null) {
                this.current = new LinkedList();
            }
            this.current.add(elem);
        }
    }

    public boolean hasInCurrent(FState elem) {
        if (this.current == null) {
            return false;
        }
        return this.current.contains(elem);
    }

    public Iterator iteratorOfCurrent() {
        return this.current == null ? FEmptyIterator.get() : this.current.iterator();
    }

    public ListIterator listIteratorOfCurrent() {
        if (this.current == null) {
            this.current = new LinkedList();
        }
        return this.current.listIterator();
    }

    public void removeFromCurrent(FState elem) {
        if (this.hasInCurrent(elem)) {
            this.current.remove(elem);
        }
    }

    public int sizeOfCurrent() {
        if (this.current == null) {
            return 0;
        }
        return this.current.size();
    }

    public void enqueueEvent(FEvent event, int priority) {
        this.eventQueue[priority].addLast(event);
        Protocolizer curProt = this.getProtocolizer();
        if (curProt != null) {
            FReactive fr;
            Protocolizer receiverProtocolizer;
            curProt.incomingEvent(event, priority, false);
            Thread curThread = Thread.currentThread();
            if (curThread instanceof FReactiveThread && (receiverProtocolizer = (fr = ((FReactiveThread)curThread).getFReactive()).getProtocolizer()) != null) {
                receiverProtocolizer.outgoingEvent(event, this, priority, false);
            }
        }
    }

    public void enqueueEventToFront(FEvent event, int priority) {
        this.eventQueue[priority].addFirst(event);
        Protocolizer curProt = this.getProtocolizer();
        if (curProt != null) {
            FReactive fr;
            Protocolizer receiverProtocolizer;
            curProt.incomingEvent(event, priority, true);
            Thread curThread = Thread.currentThread();
            if (curThread instanceof FReactiveThread && (receiverProtocolizer = (fr = ((FReactiveThread)curThread).getFReactive()).getProtocolizer()) != null) {
                receiverProtocolizer.outgoingEvent(event, this, priority, true);
            }
        }
    }

    public int getFreezeCounter() {
        return this.freezeCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeze() {
        Object object = this.freezeLock;
        synchronized (object) {
            ++this.freezeCounter;
            if (this.freezeCounter <= 1) {
                try {
                    this.notifyMe();
                    this.freezeLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfreeze() {
        Object object = this.freezeLock;
        synchronized (object) {
            --this.freezeCounter;
            if (this.freezeCounter <= 0) {
                try {
                    this.notifyMe();
                    Thread.sleep(400L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void stopThread() {
        this.stopped = true;
    }

    public void process() {
        if (this.thread != null && this.thread != Thread.currentThread()) {
            throw new UnsupportedOperationException("process() may not be called in multithreaded mode!");
        }
        this.thread = Thread.currentThread();
        this.process_internal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process_internal() {
        while (!this.stopped) {
            if (this.freezeCounter >= 1) {
                Object object = this.freezeLock;
                synchronized (object) {
                    this.freezeLock.notifyAll();
                }
            }
            while (this.freezeCounter >= 1) {
                if (this.stopped) continue;
                this.waitForNotification();
            }
            this.process_step();
        }
    }

    public void process_step() {
        FEvent event;
        boolean processExternal = true;
        if (!this.eventQueue[0].isEmpty()) {
            processExternal = false;
            event = (FEvent)this.eventQueue[0].removeFirst();
            this.handleEvent(event, 0);
        } else if (!this.eventQueue[1].isEmpty()) {
            processExternal = true;
            for (int index = 0; processExternal && index < this.eventQueue[1].size(); ++index) {
                FEvent event2 = (FEvent)this.eventQueue[1].get(index);
                boolean inSameState = false;
                Iterator iter = this.iteratorOfCurrent();
                while (!inSameState && iter.hasNext()) {
                    for (FState current = (FState)iter.next(); !inSameState && current != null; current = current.getParent()) {
                        if (!current.equals(event2.getDeferredInState())) continue;
                        inSameState = true;
                    }
                }
                if (inSameState) continue;
                processExternal = false;
                this.handleEvent(event2, 1);
            }
        }
        if (processExternal) {
            if (!this.eventQueue[2].isEmpty()) {
                event = (FEvent)this.eventQueue[2].removeFirst();
                this.handleEvent(event, 2);
            } else if (!this.stopped) {
                this.waitForNotification();
            }
        }
    }

    public boolean queuesEmpty() {
        return this.eventQueue[0].isEmpty() && this.eventQueue[1].isEmpty() && this.eventQueue[2].isEmpty();
    }

    public synchronized void notifyMe() {
        this.notify();
    }

    private synchronized void waitForNotification() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void dobsRedisplay(FEvent event) {
        FReactive.adjustObject(this.handler);
    }

    public static void adjustObject(Object obj) {
        Iterator iter = FReactiveManager.get().iteratorOfAdjustObjectListeners();
        while (iter.hasNext()) {
            FAdjustObjectListener listener = (FAdjustObjectListener)iter.next();
            listener.adjustObject(obj);
        }
    }

    private void handleEvent(FEvent event, int priority) {
        Protocolizer curProt = this.getProtocolizer();
        if (curProt != null) {
            curProt.processEvent(event, priority);
        }
        boolean rejected = true;
        int currentSize = this.sizeOfCurrent();
        for (int currentIndex = 0; currentIndex < currentSize; ++currentIndex) {
            FState currentState = (FState)this.current.get(currentIndex);
            if (event.toString().startsWith(INIT_EVENT_PREFIX)) {
                if (!(currentState instanceof FComplexState)) continue;
                FComplexState complexState = (FComplexState)currentState;
                if (complexState.hasHistory() && complexState.getHistoryState() != null) {
                    FState historyState = complexState.getHistoryState();
                    this.current.set(currentIndex, historyState);
                    this.invoke(historyState.getDoAction(), null);
                    rejected = false;
                    this.startTimer(historyState);
                    this.startPeriodicTimer(historyState);
                    this.enqueueEventToFront(new FEvent(historyState + READY_EVENT_POSTFIX), 0);
                    if (!(historyState instanceof FComplexState)) continue;
                    this.enqueueEventToFront(new FEvent(INIT_EVENT_PREFIX + historyState), 0);
                    continue;
                }
                Iterator initialIter = ((FComplexState)currentState).iteratorOfInitial();
                boolean isFirst = true;
                while (initialIter.hasNext()) {
                    FState initialState = (FState)initialIter.next();
                    if (isFirst) {
                        this.setHistoryState(initialState);
                        this.current.set(currentIndex, initialState);
                        isFirst = false;
                    } else {
                        this.current.add(initialState);
                        ++currentSize;
                    }
                    this.invoke(initialState.getEntryAction(), null);
                    this.invoke(initialState.getDoAction(), null);
                    rejected = false;
                    this.startTimer(initialState);
                    this.startPeriodicTimer(initialState);
                    this.enqueueEventToFront(new FEvent(initialState + READY_EVENT_POSTFIX), 0);
                    this.enqueueEventToFront(new FEvent(INIT_EVENT_PREFIX + initialState), 0);
                }
                continue;
            }
            FTransition transition = null;
            FState parent = currentState;
            FState newState = null;
            do {
                Iterator iter;
                if (!(iter = parent.iteratorOfTransitions(event.toString())).hasNext()) continue;
                transition = (FTransition)iter.next();
            } while ((parent = parent.getParent()) != null && transition == null);
            if (transition != null) {
                int id;
                Vector guards = transition.getGuards();
                if (guards.size() == 0) {
                    id = 0;
                } else {
                    boolean matched = false;
                    for (id = 0; id < guards.size() && !matched; ++id) {
                        Method guard = (Method)guards.get(id);
                        matched = guard != null ? (Boolean)this.invoke(guard, event) : true;
                    }
                    --id;
                    if (!matched) {
                        if (curProt != null) {
                            curProt.rejectEvent(event);
                        }
                        if (priority == 1) {
                            this.eventQueue[1].remove(event);
                        }
                        return;
                    }
                }
                newState = transition.getTarget(id);
                if (currentState != newState) {
                    int depth;
                    FState highestParent = currentState;
                    int diff = currentState.getDepth() - newState.getDepth();
                    for (int i = 0; i < diff; ++i) {
                        highestParent = highestParent.getParent();
                    }
                    int maxDepth = 0;
                    Iterator allCurrentIter = this.iteratorOfCurrent();
                    while (allCurrentIter.hasNext()) {
                        FState state = (FState)allCurrentIter.next();
                        if (!state.hasAsParent(highestParent) || (depth = state.getDepth()) <= maxDepth) continue;
                        maxDepth = depth;
                    }
                    int minDepth = highestParent.getDepth();
                    for (depth = maxDepth; depth >= minDepth; --depth) {
                        for (int innerCurrentIndex = 0; innerCurrentIndex < currentSize; ++innerCurrentIndex) {
                            FState state = (FState)this.current.get(innerCurrentIndex);
                            if (!state.hasAsParent(highestParent) || state.getDepth() != depth) continue;
                            parent = state.getParent();
                            this.invoke(state.getExitAction(), null);
                            this.removeTimer(state);
                            this.removePeriodicTimer(state);
                            if (this.hasInCurrent(parent)) {
                                this.current.remove(innerCurrentIndex);
                                --currentSize;
                                continue;
                            }
                            this.current.set(innerCurrentIndex, parent);
                        }
                    }
                    this.invoke(transition.getFromActions(id), event);
                    this.invoke(newState.getEntryAction(), null);
                } else {
                    this.invoke(currentState.getExitAction(), null);
                    this.removeTimer(currentState);
                    this.removePeriodicTimer(currentState);
                    this.invoke(transition.getFromActions(id), event);
                    this.invoke(newState.getEntryAction(), null);
                }
                this.setHistoryState(newState);
                this.current.set(currentIndex, newState);
                if ("stopStateChart".equals(newState.getName())) {
                    this.stopThread();
                }
                this.invoke(newState.getDoAction(), null);
                rejected = false;
                this.startTimer(newState);
                this.startPeriodicTimer(newState);
                this.enqueueEventToFront(new FEvent(newState + READY_EVENT_POSTFIX), 0);
                if (newState instanceof FComplexState) {
                    this.enqueueEventToFront(new FEvent(INIT_EVENT_PREFIX + newState), 0);
                }
            } else if (this.isEventDeferred(event)) {
                FState deferringState;
                if (priority != 1) {
                    this.newDeferredEventsQueue.addLast(event);
                }
                for (deferringState = currentState; deferringState != null && !deferringState.hasInDeferredEvents(event.getName()); deferringState = deferringState.getParent()) {
                }
                event.setDeferredInState(deferringState);
            }
            if (priority == 1) {
                this.eventQueue[1].remove(event);
            }
            if (currentState == newState) continue;
            Iterator queueIter = this.newDeferredEventsQueue.iterator();
            while (queueIter.hasNext()) {
                FEvent fEvent = (FEvent)queueIter.next();
                this.eventQueue[1].addLast(fEvent);
                if (curProt == null) continue;
                curProt.incomingEvent(event, 1, false);
            }
            this.newDeferredEventsQueue = new LinkedList();
        }
        if (curProt != null) {
            if (rejected && !event.getName().endsWith(READY_EVENT_POSTFIX)) {
                curProt.rejectEvent(event);
            } else {
                curProt.acknowledgeEvent(event);
            }
        }
        this.dobsRedisplay(event);
    }

    private void setHistoryState(FState historyState) {
        FComplexState parent = historyState.getParent();
        FState child = historyState;
        while (parent != null) {
            if (parent.hasHistory()) {
                if (parent.getHistoryKind() == 1) {
                    parent.setHistoryState(historyState);
                } else {
                    parent.setHistoryState(child);
                }
                parent = null;
                continue;
            }
            child = parent;
            parent = parent.getParent();
        }
    }

    private boolean isEventDeferred(FEvent event) {
        boolean result = false;
        for (FState parent = this.getCurrent(); !result && parent != null; parent = parent.getParent()) {
            if (!parent.hasInDeferredEvents(event.getName())) continue;
            result = true;
        }
        return result;
    }

    private void startTimer(FState state) {
        if (state.getTimeoutForAfterEvent() != 0L) {
            this.timers.put(state, new FTimer(this, state.getTimeoutForAfterEvent(), state.getIdOfAfterTransition()));
        }
    }

    private void removeTimer(FState state) {
        if (state.getTimeoutForAfterEvent() != 0L) {
            ((FTimer)this.timers.get(state)).interrupt();
            LinkedList internalEventQueue = this.eventQueue[0];
            Iterator iter = internalEventQueue.iterator();
            while (iter.hasNext()) {
                FEvent event = (FEvent)iter.next();
                String eventName = event.getName();
                if (eventName == null || !eventName.equals("after" + state.getIdOfAfterTransition())) continue;
                iter.remove();
            }
        }
    }

    private void startPeriodicTimer(FState state) {
        if (state.getTimeoutForWhenEvent() != 0L) {
            this.periodicTimers.put(state, new FPeriodicTimer(this, state.getTimeoutForWhenEvent(), state.getIdOfWhenTransition()));
        }
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new FReactiveThread();
            this.thread.start();
        }
    }

    private void removePeriodicTimer(FState state) {
        if (state.getTimeoutForWhenEvent() != 0L) {
            ((FTimer)this.periodicTimers.get(state)).interrupt();
            LinkedList internalEventQueue = this.eventQueue[0];
            Iterator iter = internalEventQueue.iterator();
            while (iter.hasNext()) {
                FEvent event = (FEvent)iter.next();
                String eventName = event.getName();
                if (eventName == null || !eventName.equals("when" + state.getIdOfWhenTransition())) continue;
                iter.remove();
            }
        }
    }

    public Object getHandler() {
        return this.handler;
    }

    public void setHandler(Object v) {
        this.handler = v;
        this.notifyOfHandler = this.getNamedMethod("notifyMe");
    }

    public void makeTransition(FState from, FState to, String eventName, String guardName, String actionName) {
        Iterator iter;
        Method action = this.getFirstNamedMethod(actionName);
        if (eventName == null) {
            eventName = from.getName() + READY_EVENT_POSTFIX;
        }
        if ((iter = from.iteratorOfTransitions(eventName)).hasNext()) {
            FTransition transition = (FTransition)iter.next();
            if (guardName.equals(ELSE_GUARD)) {
                transition.addToActions(action);
                Method guard = this.getFirstNamedMethod("alwaysTrue");
                transition.getGuards().add(guard);
                transition.addToTargetStates(to);
            } else {
                Method guard = this.getFirstNamedMethod(guardName);
                transition.addToActions(0, action);
                transition.getGuards().add(0, guard);
                transition.addToTargetStates(0, to);
            }
        } else {
            FTransition transition = new FTransition(eventName);
            Method guard = this.getFirstNamedMethod(guardName);
            transition.addToActions(action);
            transition.getGuards().add(guard);
            transition.addToTargetStates(to);
            from.addToTransitions(transition);
        }
    }

    public FState makeState(String name, String entryAction, String doAction, String exitAction) {
        FState state = new FState(name);
        state.setEntryAction(this.getNamedMethod(entryAction));
        state.setDoAction(this.getNamedMethod(doAction));
        state.setExitAction(this.getNamedMethod(exitAction));
        return state;
    }

    public FComplexState makeComplexState(String name, String entryAction, String doAction, String exitAction) {
        FComplexState state = new FComplexState(name);
        state.setEntryAction(this.getNamedMethod(entryAction));
        state.setDoAction(this.getNamedMethod(doAction));
        state.setExitAction(this.getNamedMethod(exitAction));
        return state;
    }

    public Method getNamedMethod(String methodName) {
        Method methodToReturn = null;
        if (methodName != null) {
            try {
                methodToReturn = this.handler.getClass().getMethod(methodName, null);
            }
            catch (NoSuchMethodException e) {
                System.out.println("Could not find method '" + methodName + " ()' in class '" + this.handler.getClass().toString() + "'.");
                e.printStackTrace();
            }
        }
        return methodToReturn;
    }

    public Method getFirstNamedMethod(String methodName) {
        Method methodToReturn = null;
        if (methodName != null) {
            Method[] allMethods = this.handler.getClass().getDeclaredMethods();
            for (int i = 0; i < allMethods.length; ++i) {
                Method currentMethod = allMethods[i];
                if (!currentMethod.getName().equals(methodName)) continue;
                methodToReturn = currentMethod;
                break;
            }
        }
        return methodToReturn;
    }

    public Object invoke(Method m, FEvent event) {
        Object result = null;
        if (m != null) {
            try {
                if (event == null) {
                    result = m.invoke(this.handler, null);
                } else {
                    Object[] args = event.getArgsArray();
                    result = m.invoke(this.handler, args);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (event != null) {
            event.setHasResult(true);
            event.setResult(result);
            this.invoke(this.notifyOfHandler, null);
        }
        return result;
    }

    public void removeAllFromCurrent() {
        Iterator iter = this.iteratorOfCurrent();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    public void removeYou() {
        this.removeAllFromCurrent();
        this.setManager(null);
        Protocolizer curProt = this.getProtocolizer();
        if (curProt != null) {
            this.setProtocolizer(null);
            curProt.removeYou();
        }
    }

    public class FReactiveThread
    extends Thread {
        public FReactive getFReactive() {
            return FReactive.this;
        }

        public void run() {
            FReactive.this.process();
        }
    }
}

