/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.fca;

import de.upb.tools.fca.FLinkedList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IteratorConcatenation
implements Iterator {
    FLinkedList iterators;
    Iterator lastIterator;

    public IteratorConcatenation(Iterator first, Iterator second) {
        this();
        this.append(first);
        this.append(second);
    }

    public IteratorConcatenation(Iterator first, Iterator second, Iterator third) {
        this(first, second);
        this.append(third);
    }

    public IteratorConcatenation() {
    }

    public void append(Iterator next) {
        if (next != null) {
            if (this.iterators == null) {
                this.iterators = new FLinkedList();
            }
            this.iterators.add(next);
        }
    }

    public boolean hasNext() {
        Iterator currentIterator = this.currentIterator();
        return currentIterator != null;
    }

    private Iterator currentIterator() {
        if (this.lastIterator != null && this.lastIterator.hasNext()) {
            return this.lastIterator;
        }
        while (this.iterators != null && this.iterators.size() > 0) {
            Iterator iterator = (Iterator)this.iterators.getFirst();
            if (!iterator.hasNext()) {
                this.iterators.removeFirst();
                continue;
            }
            return iterator;
        }
        return null;
    }

    public Object next() {
        Iterator currentIterator = this.currentIterator();
        if (currentIterator != null) {
            this.lastIterator = currentIterator;
            return currentIterator.next();
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        if (this.lastIterator == null) {
            throw new IllegalStateException();
        }
        this.lastIterator.remove();
    }
}

