/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.fca;

import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FTreeMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.SortedSet;

public class FTreeSet
extends AbstractSet
implements SortedSet,
Cloneable,
Serializable {
    transient FTreeMap map;
    private static final Object DUMMY_VALUE = "DUMMYVALUE";

    FTreeSet(SortedMap map) {
        this.map = (FTreeMap)map;
    }

    public FTreeSet() {
        this.map = new FTreeMap();
    }

    public FTreeSet(Comparator comp) {
        this.map = new FTreeMap(comp);
    }

    public FTreeSet(Collection collection) {
        this();
        this.addAll(collection);
    }

    public FTreeSet(SortedSet set) {
        this(set.comparator());
        this.addAll((Collection)set);
    }

    Map getMap() {
        return this.map;
    }

    public synchronized Object clone() {
        return new FTreeSet(this);
    }

    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized int size() {
        return this.map == null ? 0 : this.map.size();
    }

    public synchronized boolean isEmpty() {
        return this.map == null ? true : this.map.isEmpty();
    }

    public synchronized boolean add(Object obj) {
        return this.map.put(obj, DUMMY_VALUE) != DUMMY_VALUE;
    }

    public synchronized boolean addAll(Collection c) {
        if (this.map.size() == 0 && c.size() > 0 && c instanceof SortedSet) {
            Comparator mc;
            SortedSet set = (SortedSet)c;
            FTreeMap treeMap = this.map;
            Comparator cc = set.comparator();
            if (cc == (mc = this.map.comparator()) || cc != null && ((Object)cc).equals(mc)) {
                treeMap.addAllForTreeSet(set, DUMMY_VALUE);
                return true;
            }
        }
        return super.addAll(c);
    }

    public synchronized boolean contains(Object o) {
        return this.map == null ? false : this.map.containsKey(o);
    }

    public synchronized boolean remove(Object obj) {
        return this.map.remove(obj) == DUMMY_VALUE;
    }

    public synchronized Iterator iterator() {
        return this.map == null ? FEmptyIterator.get() : this.map.keySet().iterator();
    }

    public synchronized Comparator comparator() {
        return this.map.comparator();
    }

    public synchronized SortedSet subSet(Object fromElement, Object toElement) {
        return new FTreeSet(new FTreeMap(this.map.subMap(fromElement, toElement)));
    }

    public synchronized SortedSet headSet(Object toElement) {
        return new FTreeSet(new FTreeMap(this.map.headMap(toElement)));
    }

    public synchronized SortedSet tailSet(Object fromElement) {
        return new FTreeSet(new FTreeMap(this.map.tailMap(fromElement)));
    }

    public synchronized Object first() {
        return this.map.firstKey();
    }

    public synchronized Object last() {
        return this.map.lastKey();
    }

    public synchronized Object pop() {
        Object first;
        Object oldFirst = first = this.first();
        this.remove(first);
        return oldFirst;
    }

    public Object getFirst() {
        Object obj = null;
        try {
            obj = this.first();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return obj;
    }

    public Object getLast() {
        Object obj = null;
        try {
            obj = this.last();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return obj;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.map.comparator());
        out.writeInt(this.map.size());
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            out.writeObject(iter.next());
        }
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Comparator comp = (Comparator)in.readObject();
        this.map = comp == null ? new FTreeMap() : new FTreeMap(comp);
        int size = in.readInt();
        this.map.readTreeSet(size, in, DUMMY_VALUE);
    }
}

