/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.fca;

import de.upb.tools.fca.FTreeMap;
import de.upb.tools.pcs.CollectionChangeEvent;
import de.upb.tools.pcs.PropertyChangeInterface;
import java.beans.PropertyChangeSupport;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;

public class FPropTreeMap
extends FTreeMap {
    private PropertyChangeInterface owner = null;
    private String propertyName = null;

    private FPropTreeMap() {
    }

    public FPropTreeMap(PropertyChangeInterface owner, String name) {
        this.setOwner(owner);
        this.setPropertyName(name);
    }

    public FPropTreeMap(Comparator comp, PropertyChangeInterface owner, String name) {
        super(comp);
        this.setOwner(owner);
        this.setPropertyName(name);
    }

    public FPropTreeMap(Map map, PropertyChangeInterface owner, String name) {
        super(map);
        this.setOwner(owner);
        this.setPropertyName(name);
        if (this.getPropertyChangeSupport() != null) {
            Iterator iter = this.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                this.firePropertyChange(null, entry.getValue(), entry.getKey(), 1);
            }
        }
    }

    public FPropTreeMap(SortedMap map, PropertyChangeInterface owner, String name) {
        super(map);
        this.setOwner(owner);
        this.setPropertyName(name);
        if (this.getPropertyChangeSupport() != null) {
            Iterator iter = this.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                this.firePropertyChange(null, entry.getValue(), entry.getKey(), 1);
            }
        }
    }

    public synchronized Object clone() {
        return new FPropTreeMap(this, null, null);
    }

    public synchronized Object put(Object key, Object value) {
        boolean fire = this.getPropertyChangeSupport() != null && !this.containsKey(key);
        Object result = super.put(key, value);
        if (fire) {
            this.firePropertyChange(result, value, key, 1);
        }
        return result;
    }

    public synchronized void clear() {
        Map.Entry[] entries = null;
        PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
        if (propertyChangeSupport != null) {
            entries = (Map.Entry[])super.entrySet().toArray();
        }
        super.clear();
        if (propertyChangeSupport != null) {
            for (int i = 0; i < entries.length; ++i) {
                this.firePropertyChange(entries[i].getValue(), null, entries[i].getKey(), 2);
            }
        }
    }

    protected void deleteNode(FTreeMap.Node zNode) {
        super.deleteNode(zNode);
        this.firePropertyChange(zNode.getValue(), null, zNode.getKey(), 2);
    }

    protected FTreeMap.Node createNode(Object key, Object value, FTreeMap.Node parent) {
        return new PropNode(this, key, value, parent);
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.owner == null ? null : this.owner.getPropertyChangeSupport();
    }

    public void setOwner(PropertyChangeInterface owner) {
        this.owner = owner;
    }

    public PropertyChangeInterface getOwner() {
        return this.owner;
    }

    public void setPropertyName(String name) {
        this.propertyName = name;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    protected void firePropertyChange(Object oldValue, Object newValue, Object key, int type) {
        PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange(CollectionChangeEvent.get((Object)this.owner, this.propertyName, (Object)this, oldValue, newValue, key, type));
        }
    }

    class PropNode
    extends FTreeMap.Node {
        private FPropTreeMap map = null;

        public PropNode(FPropTreeMap map, Object key, Object value, FTreeMap.Node parent) {
            super(key, value, parent);
            this.map = map;
        }

        public Object clone() {
            return new PropNode(this.map, this.getKey(), this.getValue(), this.getParent());
        }

        public Object setValue(Object value) {
            Object old = super.setValue(value);
            if (old != value && this.map != null) {
                this.map.firePropertyChange(old, value, this.getKey(), 3);
            }
            return old;
        }
    }
}

