/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.fca;

import de.upb.tools.fca.FHashSet;
import de.upb.tools.pcs.CollectionChangeEvent;
import de.upb.tools.pcs.PropertyChangeInterface;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Iterator;

public class FPropHashSet
extends FHashSet {
    private PropertyChangeInterface owner = null;
    private String propertyName = null;

    private FPropHashSet() {
    }

    public FPropHashSet(PropertyChangeInterface owner, String name) {
        this.setOwner(owner);
        this.setPropertyName(name);
    }

    public FPropHashSet(Collection c, PropertyChangeInterface owner, String name) {
        super(c);
        this.setOwner(owner);
        this.setPropertyName(name);
        if (this.getPropertyChangeSupport() != null) {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                this.firePropertyChange(null, iter.next(), 1);
            }
        }
    }

    public FPropHashSet(int initialCapacity, float loadFactor, PropertyChangeInterface owner, String name) {
        super(initialCapacity, loadFactor);
        this.setOwner(owner);
        this.setPropertyName(name);
    }

    public FPropHashSet(int initialCapacity, PropertyChangeInterface owner, String name) {
        super(initialCapacity);
        this.setOwner(owner);
        this.setPropertyName(name);
    }

    public synchronized Object clone() {
        return new FPropHashSet(this, null, null);
    }

    public synchronized void clear() {
        Object[] entries = null;
        PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
        if (propertyChangeSupport != null) {
            entries = this.toArray();
        }
        super.clear();
        if (propertyChangeSupport != null) {
            for (int i = 0; i < entries.length; ++i) {
                this.firePropertyChange(entries[i], null, 2);
            }
        }
    }

    public synchronized boolean add(Object obj) {
        boolean added = super.add(obj);
        if (added && this.getPropertyChangeSupport() != null) {
            this.firePropertyChange(null, obj, 1);
        }
        return added;
    }

    public synchronized boolean remove(Object obj) {
        boolean removed = super.remove(obj);
        if (removed && this.getPropertyChangeSupport() != null) {
            this.firePropertyChange(obj, null, 2);
        }
        return removed;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.owner == null ? null : this.owner.getPropertyChangeSupport();
    }

    public void setOwner(PropertyChangeInterface owner) {
        this.owner = owner;
    }

    public PropertyChangeInterface getOwner() {
        return this.owner;
    }

    public void setPropertyName(String name) {
        this.propertyName = name;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    protected void firePropertyChange(Object oldValue, Object newValue, int type) {
        PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange(CollectionChangeEvent.get(this.owner, this.propertyName, this, oldValue, newValue, type));
        }
    }
}

