/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.fca;

import de.upb.tools.fca.FHashMap;
import de.upb.tools.pcs.CollectionChangeEvent;
import de.upb.tools.pcs.PropertyChangeInterface;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.Map;

public class FPropHashMap
extends FHashMap {
    private PropertyChangeInterface owner = null;
    private String propertyName = null;

    private FPropHashMap() {
    }

    public FPropHashMap(PropertyChangeInterface owner, String name) {
        this.setOwner(owner);
        this.setPropertyName(name);
    }

    public FPropHashMap(int initialCapacity, PropertyChangeInterface owner, String name) {
        super(initialCapacity);
        this.setOwner(owner);
        this.setPropertyName(name);
    }

    public FPropHashMap(Map map, PropertyChangeInterface owner, String name) {
        super(map);
        this.setOwner(owner);
        this.setPropertyName(name);
        if (this.getPropertyChangeSupport() != null) {
            Iterator iter = this.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                this.firePropertyChange(null, entry.getValue(), entry.getKey(), 1);
            }
        }
    }

    public FPropHashMap(int initialCapacity, float loadFactor, PropertyChangeInterface owner, String name) {
        super(initialCapacity, loadFactor);
        this.setOwner(owner);
        this.setPropertyName(name);
    }

    public Object clone() {
        return new FPropHashMap(this, null, null);
    }

    public synchronized Object put(Object key, Object value) {
        boolean fire = this.getPropertyChangeSupport() != null && !this.containsKey(key);
        Object result = super.put(key, value);
        if (fire) {
            this.firePropertyChange(null, value, key, 1);
        }
        return result;
    }

    public synchronized Object remove(Object key) {
        boolean fire = this.getPropertyChangeSupport() != null && this.containsKey(key);
        Object result = super.remove(key);
        if (fire) {
            this.firePropertyChange(result, null, key, 2);
        }
        return result;
    }

    public synchronized void clear() {
        Map.Entry[] tab = null;
        PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
        if (propertyChangeSupport != null) {
            tab = (Map.Entry[])this.entrySet().toArray();
        }
        super.clear();
        if (propertyChangeSupport != null) {
            for (int i = tab.length - 1; i >= 0; --i) {
                this.firePropertyChange(tab[i].getValue(), null, tab[i].getKey(), 2);
            }
        }
    }

    protected FHashMap.Element createElement(int hash, Object key, Object value, FHashMap.Element nextKey) {
        return new PropElement(this, hash, key, value, nextKey);
    }

    protected FHashMap.Element createElement(int hash, Object key, Object value, FHashMap.Element nextKey, FHashMap.Element nextElem, FHashMap.Element prevElem) {
        return new PropElement(this, hash, key, value, nextKey, nextElem, prevElem);
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.owner == null ? null : this.owner.getPropertyChangeSupport();
    }

    public void setOwner(PropertyChangeInterface owner) {
        this.owner = owner;
    }

    public PropertyChangeInterface getOwner() {
        return this.owner;
    }

    public void setPropertyName(String name) {
        this.propertyName = name;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    protected void firePropertyChange(Object oldValue, Object newValue, Object key, int type) {
        PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange(CollectionChangeEvent.get((Object)this.owner, this.propertyName, (Object)this, oldValue, newValue, key, type));
        }
    }

    static class PropElement
    extends FHashMap.Element {
        FPropHashMap map = null;

        public PropElement(FPropHashMap map, int hash, Object key, Object value, FHashMap.Element nextKey) {
            super(hash, key, value, nextKey);
            this.map = map;
        }

        public PropElement(FPropHashMap map, int hash, Object key, Object value, FHashMap.Element nextKey, FHashMap.Element nextElem, FHashMap.Element prevElem) {
            super(hash, key, value, nextKey, nextElem, prevElem);
            this.map = map;
        }

        protected Object clone() {
            return new PropElement(this.map, this.hash, this.key, this.getValue(), this.nextKey == null ? null : (FHashMap.Element)this.nextKey.clone());
        }

        public Object setValue(Object value) {
            Object old = super.setValue(value);
            if (old != value && this.map != null) {
                this.map.firePropertyChange(old, value, this.key, 3);
            }
            return old;
        }
    }
}

