/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.fca;

import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.pcs.CollectionChangeEvent;
import de.upb.tools.pcs.PropertyChangeInterface;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class FPropCollection
implements Serializable,
Cloneable,
Collection {
    private PropertyChangeInterface owner = null;
    private String propertyName = null;
    transient Collection collection = null;

    private FPropCollection() {
    }

    public FPropCollection(Collection collection, PropertyChangeInterface owner, String name) {
        this.setOwner(owner);
        this.setPropertyName(name);
        this.collection = collection;
        if (this.getPropertyChangeSupport() != null && collection != null) {
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                this.firePropertyChange(null, iter.next(), 1);
            }
        }
    }

    public boolean add(Object o) {
        boolean added = this.collection.add(o);
        if (added && this.getPropertyChangeSupport() != null) {
            this.firePropertyChange(null, o, 1);
        }
        return added;
    }

    public boolean addAll(Collection c) {
        boolean changed = false;
        if (this.collection == null) {
            throw new NullPointerException();
        }
        if (this.getPropertyChangeSupport() == null) {
            changed = this.collection.addAll(c);
        } else {
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                changed = this.add(iter.next()) | changed;
            }
        }
        return changed;
    }

    public void clear() {
        Object[] entries = null;
        PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
        if (this.collection == null) {
            return;
        }
        if (propertyChangeSupport != null) {
            entries = this.collection.toArray();
        }
        this.collection.clear();
        if (propertyChangeSupport != null) {
            for (int i = 0; i < entries.length; ++i) {
                this.firePropertyChange(entries[i], null, 2);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public boolean contains(Object o) {
        if (this.collection == null) {
            return false;
        }
        return this.collection.contains(o);
    }

    public boolean containsAll(Collection c) {
        if (this.collection == null) {
            return false;
        }
        return this.collection.containsAll(c);
    }

    public boolean equals(Object o) {
        if (this.collection == o) {
            return true;
        }
        return this.collection != null && ((Object)this.collection).equals(o);
    }

    public boolean isEmpty() {
        if (this.collection == null) {
            return true;
        }
        return this.collection.isEmpty();
    }

    public Iterator iterator() {
        return this.collection == null ? FEmptyIterator.get() : new MyIterator();
    }

    public boolean remove(Object o) {
        if (this.collection == null) {
            return false;
        }
        boolean result = this.collection.remove(o);
        if (result && this.getPropertyChangeSupport() != null) {
            this.firePropertyChange(o, null, 2);
        }
        return result;
    }

    public boolean removeAll(Collection c) {
        if (this.collection == null) {
            return false;
        }
        boolean result = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            result = this.remove(iter.next()) | result;
        }
        return result;
    }

    public boolean retainAll(Collection c) {
        boolean modified = false;
        Iterator e = this.iterator();
        while (e.hasNext()) {
            Object current = e.next();
            if (c.contains(current)) continue;
            e.remove();
            this.firePropertyChange(current, null, 2);
            modified = true;
        }
        return modified;
    }

    public int size() {
        if (this.collection == null) {
            return 0;
        }
        return this.collection.size();
    }

    public Object[] toArray() {
        if (this.collection == null) {
            return null;
        }
        return this.collection.toArray();
    }

    public Object[] toArray(Object[] a) {
        if (this.collection == null) {
            return null;
        }
        return this.collection.toArray(a);
    }

    public String toString() {
        return super.toString() + "\n\t[underlying Collection: " + this.collection.toString() + "]";
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.owner == null ? null : this.owner.getPropertyChangeSupport();
    }

    public void setOwner(PropertyChangeInterface owner) {
        this.owner = owner;
    }

    public PropertyChangeInterface getOwner() {
        return this.owner;
    }

    public void setPropertyName(String name) {
        this.propertyName = name;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    protected void firePropertyChange(Object oldValue, Object newValue, int type) {
        PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange(CollectionChangeEvent.get(this.owner, this.propertyName, this, oldValue, newValue, type));
        }
    }

    private class MyIterator
    extends FEmptyIterator {
        private Iterator iterator = null;
        private Object current = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MyIterator() {
            FPropCollection fPropCollection = FPropCollection.this;
            synchronized (fPropCollection) {
                this.iterator = FPropCollection.this.collection != null ? FPropCollection.this.collection.iterator() : FEmptyIterator.get();
            }
        }

        public synchronized boolean hasNext() {
            return this.iterator.hasNext();
        }

        public synchronized Object next() {
            Object result = this.iterator.next();
            this.current = result;
            return result;
        }

        public synchronized void remove() {
            this.iterator.remove();
            if (FPropCollection.this.getPropertyChangeSupport() != null) {
                FPropCollection.this.firePropertyChange(this.current, null, 2);
            }
        }
    }
}

