/*
 * Decompiled with CFR 0.152.
 */
package de.upb.assocdetection.preferences.gui;

import de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel;
import de.upb.assocdetection.preferences.AssocDetectionPreferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class AssocDetectionPreferencesPanel
extends PreferencesPanel {
    private JCheckBox assocDetectionCheckBox;
    private JCheckBox accessMethodDetectionCheckBox;
    private StringListModel primitiveClasses;
    private StringListModel containerClasses;
    private StringListModel accessMethodPrefixes;

    public AssocDetectionPreferencesPanel() {
        AssocDetectionPreferences options = AssocDetectionPreferences.get();
        this.primitiveClasses = new StringListModel(options.getPrimitiveClasses());
        this.containerClasses = new StringListModel(options.getContainerClasses());
        this.accessMethodPrefixes = new StringListModel(options.getAccessMethodPrefixes());
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JPanel optionsPanel = this.createOptionsPanel();
        optionsPanel.setBorder(new TitledBorder("Options"));
        mainPanel.add((Component)optionsPanel, "North");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Container Classes", this.createStringList(this.containerClasses));
        tabbedPane.addTab("Access Method Prefixes", this.createStringList(this.accessMethodPrefixes));
        tabbedPane.setToolTipText("Specify prefixes for methods that will be removed from class view.");
        mainPanel.add((Component)tabbedPane, "Center");
        this.add(mainPanel);
    }

    private JPanel createOptionsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Options"));
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(gridBag);
        this.assocDetectionCheckBox = new JCheckBox("Enable association detection");
        this.assocDetectionCheckBox.setToolTipText("Start association detection after parsing.");
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.assocDetectionCheckBox, constraints);
        this.accessMethodDetectionCheckBox = new JCheckBox("Don't display access methods in classes");
        this.accessMethodDetectionCheckBox.setToolTipText("Detect access methods and remove them from class view.");
        constraints.insets = new Insets(0, 3, 3, 3);
        panel.add((Component)this.accessMethodDetectionCheckBox, constraints);
        return panel;
    }

    private JPanel createStringList(StringListModel model) {
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        JList stringList = new JList(model);
        JScrollPane scrollPane = new JScrollPane(stringList);
        listPanel.add((Component)scrollPane, "Center");
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel southPanel = new JPanel();
        southPanel.setLayout(gridBag);
        JLabel label = new JLabel("Name:   ");
        constraints.gridwidth = -1;
        constraints.fill = 1;
        gridBag.setConstraints(label, constraints);
        southPanel.add(label);
        JTextField newStringTextField = new JTextField();
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        gridBag.setConstraints(newStringTextField, constraints);
        southPanel.add(newStringTextField);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton addButton = new JButton("Add");
        addButton.addActionListener(new AddButtonListener(newStringTextField, model));
        buttonPanel.add(addButton);
        JButton removeButton = new JButton("Remove");
        removeButton.addActionListener(new RemoveButtonListener(stringList, model));
        buttonPanel.add(removeButton);
        constraints.gridwidth = 0;
        constraints.weightx = 0.0;
        gridBag.setConstraints(buttonPanel, constraints);
        southPanel.add(buttonPanel);
        listPanel.add((Component)southPanel, "South");
        return listPanel;
    }

    public String getPreferredTabName() {
        return "Association Detection";
    }

    public void setDefaults() {
        AssocDetectionPreferences.get().setDefaults();
        this.setPreferences();
    }

    public void setPreferences() {
        AssocDetectionPreferences options = AssocDetectionPreferences.get();
        this.assocDetectionCheckBox.setSelected(options.isAssocDetectionEnabled());
        this.accessMethodDetectionCheckBox.setSelected(options.isAccessMethodDetectionEnabled());
        this.primitiveClasses.setStrings(options.getPrimitiveClasses());
        this.containerClasses.setStrings(options.getContainerClasses());
        this.accessMethodPrefixes.setStrings(options.getAccessMethodPrefixes());
    }

    public void okPressed() {
        AssocDetectionPreferences options = AssocDetectionPreferences.get();
        options.setAssocDetectionEnabled(this.assocDetectionCheckBox.isSelected());
        options.setAccessMethodDetectionEnabled(this.accessMethodDetectionCheckBox.isSelected());
        options.setPrimitiveClasses(this.primitiveClasses.getStrings());
        options.setContainerClasses(this.containerClasses.getStrings());
        options.setAccessMethodPrefixes(this.accessMethodPrefixes.getStrings());
    }

    private static class AddButtonListener
    implements ActionListener {
        private JTextField textField;
        private StringListModel model;

        public AddButtonListener(JTextField textField, StringListModel model) {
            this.textField = textField;
            this.model = model;
        }

        public void actionPerformed(ActionEvent e) {
            String string = this.textField.getText();
            this.model.addElement(string);
        }
    }

    private static class RemoveButtonListener
    implements ActionListener {
        private JList list;
        private StringListModel model;

        public RemoveButtonListener(JList list, StringListModel model) {
            this.list = list;
            this.model = model;
        }

        public void actionPerformed(ActionEvent e) {
            Object[] values = this.list.getSelectedValues();
            int i = 0;
            while (i < values.length) {
                this.model.removeElement((String)values[i]);
                ++i;
            }
            this.list.clearSelection();
        }
    }

    private static class StringListModel
    extends AbstractListModel {
        private Vector strings;

        public StringListModel(Vector strings) {
            this.strings = strings;
        }

        public Object getElementAt(int index) {
            return this.strings.elementAt(index);
        }

        public int getSize() {
            return this.strings.size();
        }

        public void addElement(String newString) {
            if (!this.strings.contains(newString)) {
                this.strings.addElement(newString);
                this.fireContentsChanged(this, 0, this.getSize());
            }
        }

        public void removeElement(String oldString) {
            if (this.strings.contains(oldString)) {
                this.strings.removeElement(oldString);
                this.fireContentsChanged(this, 0, this.getSize());
            }
        }

        public Vector getStrings() {
            return this.strings;
        }

        public void setStrings(Vector newStrings) {
            this.strings = newStrings;
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }
}

