/*
 * Decompiled with CFR 0.152.
 */
package de.upb.assocdetection.preferences;

import de.uni_paderborn.fujaba.preferences.AbstractPreferences;
import de.uni_paderborn.fujaba.preferences.PreferencesProperties;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.Vector;

public class AssocDetectionPreferences
extends AbstractPreferences {
    public static final String PROPERTY_KEY = "de/upb/assocdetection/AssocDetection.properties";
    public static final String PROPERTY_NAME = "AssocDetection.";
    private static final String CATALOG_FILENAME = "CatalogFileName";
    private static final String PRIMITIVE_CLASSES = "PrimitiveClasses.";
    private static final String CONTAINER_CLASSES = "ContainerClasses.";
    private static final String ACCESS_METHOD_PREFIXES = "AccessMethodPrefixes.";
    public static final String ASSOC_DETECTION_ENABLED = "AssocDetectionEnabled";
    public static final String ACCESS_METHOD_DETECTION_ENABLED = "AccessMethodDetectionEnabled";
    public static final String DEF_CATALOG_FILENAME = String.valueOf(System.getProperty("user.dir")) + File.separator + "plugins" + File.separator + "AssocDetection" + File.separator + "catalogs" + File.separator + "AssocDetectionCatalog.jar";
    private static final boolean DEF_ASSOC_DETECTION_ENABLED = true;
    private static final boolean DEF_ACCESS_METHOD_DETECTION_ENABLED = true;
    private static AssocDetectionPreferences options;
    private boolean primitiveClassesDirty = true;
    private boolean containerClassesDirty = true;
    private boolean accessMethodPrefixesDirty = true;

    private AssocDetectionPreferences() {
    }

    public static synchronized AssocDetectionPreferences get() {
        if (options == null) {
            options = new AssocDetectionPreferences();
        }
        return options;
    }

    public void setDefaults() {
        this.setPrimitiveClassesDefaults();
        this.setContainerClassesDefaults();
        this.setAccessMethodPrefixesDefaults();
        PreferencesProperties options = PreferencesProperties.get((String)PROPERTY_KEY);
        options.putSetting("AssocDetection.AssocDetectionEnabled", true);
        options.putSetting("AssocDetection.AccessMethodDetectionEnabled", true);
    }

    private Vector setPrimitiveClassesDefaults() {
        Vector<String> primitiveClasses = new Vector<String>(10);
        primitiveClasses.addElement("Boolean");
        primitiveClasses.addElement("Character");
        primitiveClasses.addElement("Byte");
        primitiveClasses.addElement("Short");
        primitiveClasses.addElement("Integer");
        primitiveClasses.addElement("Long");
        primitiveClasses.addElement("Float");
        primitiveClasses.addElement("Double");
        primitiveClasses.addElement("String");
        primitiveClasses.addElement("StringBuffer");
        this.setPrimitiveClasses(primitiveClasses);
        return primitiveClasses;
    }

    private Vector setContainerClassesDefaults() {
        Vector<String> containerClasses = new Vector<String>(42);
        containerClasses.addElement("Collection");
        containerClasses.addElement("List");
        containerClasses.addElement("Map");
        containerClasses.addElement("Set");
        containerClasses.addElement("SortedMap");
        containerClasses.addElement("SortedSet");
        containerClasses.addElement("AbstractCollection");
        containerClasses.addElement("AbstractList");
        containerClasses.addElement("AbstractMap");
        containerClasses.addElement("AbstractSequentialList");
        containerClasses.addElement("AbstractSet");
        containerClasses.addElement("ArrayList");
        containerClasses.addElement("HashMap");
        containerClasses.addElement("HashSet");
        containerClasses.addElement("Hashtable");
        containerClasses.addElement("IdentityHashMap");
        containerClasses.addElement("LinkedHashMap");
        containerClasses.addElement("LinkedHashSet");
        containerClasses.addElement("LinkedList");
        containerClasses.addElement("TreeMap");
        containerClasses.addElement("TreeSet");
        containerClasses.addElement("Vector");
        containerClasses.addElement("WeakHashMap");
        containerClasses.addElement("FDuplicatedHashMap");
        containerClasses.addElement("FDuplicatedLinkedHashMap");
        containerClasses.addElement("FDuplicatedMap");
        containerClasses.addElement("FDuplicatedSortedMap");
        containerClasses.addElement("FDuplicatedTreeMap");
        containerClasses.addElement("FHashMap");
        containerClasses.addElement("FHashSet");
        containerClasses.addElement("FLinkedList");
        containerClasses.addElement("FLinkedUniqueElementList");
        containerClasses.addElement("FPropCollection");
        containerClasses.addElement("FPropDuplicatedHashMap");
        containerClasses.addElement("FPropHashMap");
        containerClasses.addElement("FPropHashSet");
        containerClasses.addElement("FPropLinkedList");
        containerClasses.addElement("FPropMap");
        containerClasses.addElement("FPropTreeMap");
        containerClasses.addElement("FPropTreeSet");
        containerClasses.addElement("FTreeMap");
        containerClasses.addElement("FTreeSet");
        this.setContainerClasses(containerClasses);
        return containerClasses;
    }

    private Vector setAccessMethodPrefixesDefaults() {
        Vector<String> accessMethodPrefixes = new Vector<String>(26);
        accessMethodPrefixes.addElement("set");
        accessMethodPrefixes.addElement("get");
        accessMethodPrefixes.addElement("is");
        accessMethodPrefixes.addElement("addTo");
        accessMethodPrefixes.addElement("hasIn");
        accessMethodPrefixes.addElement("iteratorOf");
        accessMethodPrefixes.addElement("removeFrom");
        accessMethodPrefixes.addElement("removeAllFrom");
        accessMethodPrefixes.addElement("sizeOf");
        accessMethodPrefixes.addElement("entriesOf");
        accessMethodPrefixes.addElement("getFrom");
        accessMethodPrefixes.addElement("hasKeyIn");
        accessMethodPrefixes.addElement("keysOf");
        accessMethodPrefixes.addElement("removeKeyFrom");
        accessMethodPrefixes.addElement("addAfterOf");
        accessMethodPrefixes.addElement("addBeforeOf");
        accessMethodPrefixes.addElement("getFirstOf");
        accessMethodPrefixes.addElement("getLastOf");
        accessMethodPrefixes.addElement("getNextIndexOf");
        accessMethodPrefixes.addElement("getNextOf");
        accessMethodPrefixes.addElement("getPreviousIndexOf");
        accessMethodPrefixes.addElement("getPreviousOf");
        accessMethodPrefixes.addElement("isAfterOf");
        accessMethodPrefixes.addElement("isBeforeOf");
        accessMethodPrefixes.addElement("lastIndexOf");
        accessMethodPrefixes.addElement("setIn");
        this.setAccessMethodPrefixes(accessMethodPrefixes);
        return accessMethodPrefixes;
    }

    public void setCatalogFilename(String catalogFilename) {
        PreferencesProperties options = PreferencesProperties.get((String)PROPERTY_KEY);
        if (options.getSetting("AssocDetection.CatalogFileName", DEF_CATALOG_FILENAME) != catalogFilename) {
            options.putSetting("AssocDetection.CatalogFileName", catalogFilename);
            this.setModified(true);
        }
    }

    public String getCatalogFilename() {
        return PreferencesProperties.get((String)PROPERTY_KEY).getSetting("AssocDetection.CatalogFileName", DEF_CATALOG_FILENAME);
    }

    public void setPrimitiveClasses(Vector vector) {
        PreferencesProperties.get((String)PROPERTY_KEY).putSetting("AssocDetection.PrimitiveClasses.", (List)vector);
        this.setModified(true);
        this.setPrimitiveClassesDirty(true);
    }

    public Vector getPrimitiveClasses() {
        Vector primitiveClasses = PreferencesProperties.get((String)PROPERTY_KEY).getVectorSetting("AssocDetection.PrimitiveClasses.");
        if (primitiveClasses.size() == 0) {
            primitiveClasses = this.setPrimitiveClassesDefaults();
        }
        return primitiveClasses;
    }

    public void setContainerClasses(Vector vector) {
        PreferencesProperties.get((String)PROPERTY_KEY).putSetting("AssocDetection.ContainerClasses.", (List)vector);
        this.setModified(true);
        this.setContainerClassesDirty(true);
    }

    public Vector getContainerClasses() {
        Vector containerClasses = PreferencesProperties.get((String)PROPERTY_KEY).getVectorSetting("AssocDetection.ContainerClasses.");
        if (containerClasses.size() == 0) {
            containerClasses = this.setContainerClassesDefaults();
        }
        return containerClasses;
    }

    public void setAccessMethodPrefixes(Vector vector) {
        PreferencesProperties.get((String)PROPERTY_KEY).putSetting("AssocDetection.AccessMethodPrefixes.", (List)vector);
        this.setModified(true);
        this.setAccessMethodPrefixesDirty(true);
    }

    public Vector getAccessMethodPrefixes() {
        Vector accessMethodPrefixes = PreferencesProperties.get((String)PROPERTY_KEY).getVectorSetting("AssocDetection.AccessMethodPrefixes.");
        if (accessMethodPrefixes.size() == 0) {
            accessMethodPrefixes = this.setAccessMethodPrefixesDefaults();
        }
        return accessMethodPrefixes;
    }

    public boolean isAssocDetectionEnabled() {
        return PreferencesProperties.get((String)PROPERTY_KEY).getBoolSetting("AssocDetection.AssocDetectionEnabled", true);
    }

    public void setAssocDetectionEnabled(boolean assocDetectionEnabled) {
        PreferencesProperties options = PreferencesProperties.get((String)PROPERTY_KEY);
        if (options.getBoolSetting("AssocDetection.AssocDetectionEnabled", true) != assocDetectionEnabled) {
            options.putSetting("AssocDetection.AssocDetectionEnabled", assocDetectionEnabled);
            this.setModified(true);
        }
    }

    public boolean isAccessMethodDetectionEnabled() {
        return PreferencesProperties.get((String)PROPERTY_KEY).getBoolSetting("AssocDetection.AccessMethodDetectionEnabled", true);
    }

    public void setAccessMethodDetectionEnabled(boolean accessMethodDetectionEnabled) {
        PreferencesProperties options = PreferencesProperties.get((String)PROPERTY_KEY);
        if (options.getBoolSetting("AssocDetection.AccessMethodDetectionEnabled", true) != accessMethodDetectionEnabled) {
            options.putSetting("AssocDetection.AccessMethodDetectionEnabled", accessMethodDetectionEnabled);
            this.setModified(true);
        }
    }

    public void setPrimitiveClassesDirty(boolean dirty) {
        this.primitiveClassesDirty = dirty;
    }

    public boolean isPrimitiveClassesDirty() {
        return this.primitiveClassesDirty;
    }

    public void setContainerClassesDirty(boolean dirty) {
        this.containerClassesDirty = dirty;
    }

    public boolean isContainerClassesDirty() {
        return this.containerClassesDirty;
    }

    public void setAccessMethodPrefixesDirty(boolean dirty) {
        this.accessMethodPrefixesDirty = dirty;
    }

    public boolean isAccessMethodPrefixesDirty() {
        return this.accessMethodPrefixesDirty;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PreferencesProperties.get((String)PROPERTY_KEY).addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PreferencesProperties.get((String)PROPERTY_KEY).removePropertyChangeListener(propertyName, listener);
    }
}

