/*
 * Decompiled with CFR 0.152.
 */
package de.upb.assocdetection;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.parser.ParserPostProcessor;
import de.uni_paderborn.fujaba.uml.UMLAssoc;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.lib.classloader.UPBClassLoader;
import de.upb.assocdetection.generators.AbstractGenerator;
import de.upb.assocdetection.generators.ArrayMultiReferenceRoleGenerator;
import de.upb.assocdetection.generators.AssocGenerator;
import de.upb.assocdetection.generators.MultiReferenceRoleGenerator;
import de.upb.assocdetection.generators.QualifiedReferenceRoleGenerator;
import de.upb.assocdetection.generators.ReferenceGenerator;
import de.upb.assocdetection.generators.SingleReferenceRoleGenerator;
import de.upb.assocdetection.preferences.AssocDetectionPreferences;
import de.upb.inferenceengine.InferenceEngine;
import de.upb.inferenceengine.RuleCatalog;
import de.upb.inferenceengine.engines.GFRNAnnotation;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class AssocDetector
implements ParserPostProcessor,
PropertyChangeListener {
    private HashSet assocGenerators = new HashSet();
    private HashSet referenceGenerators = new HashSet();
    private HashSet roleGenerators = new HashSet();
    private boolean active = AssocDetectionPreferences.get().isAssocDetectionEnabled();
    static /* synthetic */ Class class$0;

    public AssocDetector() {
        this.addGenerator(new AssocGenerator());
        this.addGenerator(new ReferenceGenerator());
        this.addGenerator(new SingleReferenceRoleGenerator());
        this.addGenerator(new MultiReferenceRoleGenerator());
        this.addGenerator(new ArrayMultiReferenceRoleGenerator());
        this.addGenerator(new QualifiedReferenceRoleGenerator());
    }

    public void addGenerator(AbstractGenerator generator) {
        if (generator.getResponsibility() == 1) {
            this.assocGenerators.add(generator);
        } else if (generator.getResponsibility() == 2) {
            this.referenceGenerators.add(generator);
        } else {
            this.roleGenerators.add(generator);
        }
    }

    public String getName() {
        return "Association Detection";
    }

    public boolean isActive() {
        return this.active;
    }

    public void execute() {
        String catalogFilename = AssocDetectionPreferences.DEF_CATALOG_FILENAME;
        File catalogFile = new File(catalogFilename);
        if (catalogFile.exists()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.upb.assocdetection.AssocDetectionPlugin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            RuleCatalog ruleCatalog = new RuleCatalog(catalogFile, UPBClassLoader.get((String)clazz.getName()));
            InferenceEngine inferenceEngine = InferenceEngine.get();
            inferenceEngine.addToCatalogs(ruleCatalog);
            inferenceEngine.setCurrentCatalog(ruleCatalog);
            inferenceEngine.setShowProgress(false);
            inferenceEngine.setAddResultsToDiagram(false);
            try {
                inferenceEngine.run();
            }
            catch (RuntimeException exception) {
                JOptionPane.showMessageDialog(null, "Association detection failed due to internal runtime error:\n" + exception.getMessage(), "Association detection failed!", 0);
            }
            inferenceEngine.removeFromCatalogs(ruleCatalog);
            this.enrichModel(this.assocGenerators, inferenceEngine);
            this.enrichModel(this.referenceGenerators, inferenceEngine);
            this.enrichModel(this.roleGenerators, inferenceEngine);
            Iterator iter = inferenceEngine.iteratorOfResults();
            while (iter.hasNext()) {
                GFRNAnnotation annotation = (GFRNAnnotation)iter.next();
                annotation.removeYou();
            }
        } else {
            JOptionPane.showMessageDialog(null, "Association detection catalog can not be found!", "File not found", 0);
        }
    }

    private void enrichModel(HashSet generators, InferenceEngine inferenceEngine) {
        Iterator iter = generators.iterator();
        while (iter.hasNext()) {
            AbstractGenerator generator = (AbstractGenerator)iter.next();
            Iterator annotationsIter = inferenceEngine.iteratorOfResults();
            while (annotationsIter.hasNext()) {
                UMLAssoc umlAssoc;
                GFRNAnnotation annotation = (GFRNAnnotation)annotationsIter.next();
                if (!generator.isResponsible(annotation) || (umlAssoc = (UMLAssoc)generator.enrichModel(annotation)) == null) continue;
                UMLClass umlClass = umlAssoc.getLeftRole().getTarget();
                UMLDiagram umlDiagram = (UMLDiagram)umlClass.iteratorOfDiagrams().next();
                umlDiagram.addToElements((ASGElement)umlAssoc);
            }
        }
    }

    public static boolean isPrimitiveClass(String name) {
        AssocDetectionPreferences preferences = AssocDetectionPreferences.get();
        boolean result = preferences.getPrimitiveClasses().contains(name);
        return result;
    }

    public static boolean isContainerClass(String name) {
        AssocDetectionPreferences preferences = AssocDetectionPreferences.get();
        boolean result = preferences.getContainerClasses().contains(name);
        return result;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("AssocDetection.AssocDetectionEnabled")) {
            this.active = Boolean.valueOf((String)event.getNewValue());
        }
    }
}

