/*
 * Decompiled with CFR 0.152.
 */
package de.uni_kassel.fujaba.search;

import de.uni_kassel.fujaba.search.FindAction;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.messages.Message;
import de.uni_paderborn.fujaba.messages.Warning;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLAssoc;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLGeneralization;
import de.uni_paderborn.fujaba.uml.UMLLink;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLObject;
import java.util.Iterator;

public class FindUsagesAction
extends FindAction {
    protected void performSearch(Iterator selection) {
        String unsupported = null;
        Iterator it = selection;
        while (it.hasNext()) {
            Object element = it.next();
            if (element instanceof UMLClass) {
                this.findUsages((UMLClass)element);
                continue;
            }
            if (element instanceof UMLAssoc) {
                this.findUsages((UMLAssoc)element);
                continue;
            }
            unsupported = unsupported == null ? this.getShortClassName(element) : String.valueOf(unsupported) + ", " + this.getShortClassName(element);
        }
        if (unsupported != null) {
            Warning warning = new Warning("Searching for usages of these types is unsupported: " + unsupported);
            warning.setMessageCategory("Search");
            FrameMain.get().getMessageView().addToMessages((Message)warning);
        }
    }

    private void findUsages(UMLClass umlClass) {
        FClass fClass;
        Iterator it = umlClass.iteratorOfInstances();
        while (it.hasNext()) {
            UMLObject object = (UMLObject)it.next();
            this.showMatch("instance: " + object.getObjectName(), (FElement)object);
        }
        it = umlClass.iteratorOfRevAttrType();
        while (it.hasNext()) {
            UMLAttr attr = (UMLAttr)it.next();
            fClass = attr.getFParent();
            this.showMatch("attribute: " + (fClass != null ? String.valueOf(fClass.getName()) + "." : "") + attr.getName(), (FElement)attr);
        }
        it = umlClass.iteratorOfRevResultType();
        while (it.hasNext()) {
            UMLMethod method = (UMLMethod)it.next();
            fClass = method.getFParent();
            this.showMatch("method: " + (fClass != null ? String.valueOf(fClass.getName()) + "." : "") + method.getName(), (FElement)method);
        }
        it = umlClass.iteratorOfRevSuperclass();
        while (it.hasNext()) {
            UMLGeneralization generalization = (UMLGeneralization)it.next();
            this.showMatch("subclass: " + generalization.getSubclass().getName(), (FElement)generalization);
        }
    }

    private void findUsages(UMLAssoc umlAssoc) {
        Iterator it = umlAssoc.iteratorOfInstances();
        while (it.hasNext()) {
            UMLLink link = (UMLLink)it.next();
            this.showMatch("link: " + link.getName(), (FElement)link);
        }
    }
}

