/*
 * Decompiled with CFR 0.152.
 */
package de.uni_kassel.fujaba.search;

import de.uni_kassel.fujaba.search.FindAction;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.messages.Message;
import de.uni_paderborn.fujaba.messages.Warning;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLLink;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLStartActivity;
import java.util.Iterator;

public class FindDefinitionAction
extends FindAction {
    protected void performSearch(Iterator selection) {
        String unsupported = null;
        Iterator it = selection;
        while (it.hasNext()) {
            Object element = it.next();
            if (element instanceof UMLObject) {
                this.findDefinition((UMLObject)element);
                continue;
            }
            if (element instanceof UMLLink) {
                this.findDefinition((UMLLink)element);
                continue;
            }
            if (element instanceof UMLActivityDiagram) {
                this.findDefinition((UMLActivityDiagram)element);
                continue;
            }
            unsupported = unsupported == null ? this.getShortClassName(element) : String.valueOf(unsupported) + ", " + this.getShortClassName(element);
        }
        if (unsupported != null) {
            Warning warning = new Warning("Searching for definition of these types is unsupported: " + unsupported);
            warning.setMessageCategory("Search");
            FrameMain.get().getMessageView().addToMessages((Message)warning);
        }
    }

    private void findDefinition(UMLLink link) {
        this.showMatch(link.getInstanceOf().getName(), (FElement)link.getInstanceOf());
    }

    private void findDefinition(UMLObject object) {
        this.showMatch(object.getInstanceOf().getFullClassName(), (FElement)object.getInstanceOf());
    }

    private void findDefinition(UMLActivityDiagram activityDiagram) {
        UMLStartActivity startActivity = activityDiagram.getStartActivity();
        if (startActivity != null && startActivity.getSpec() != null) {
            this.showMatch(startActivity.getSpec().getFullMethodName(), (FElement)startActivity.getSpec());
        }
    }
}

