/*
 * Decompiled with CFR 0.152.
 */
package de.uni_kassel.fujaba.search;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.messages.Message;
import de.uni_paderborn.fujaba.messages.SearchResult;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.upb.tools.fca.SingleObjectIterator;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;

public abstract class FindAction
extends AbstractAction {
    public static final String MESSAGE_CLASS_SEARCH = "Search";
    private int matchCount;
    private SearchResult firstMatch;

    public void actionPerformed(ActionEvent e) {
        FrameMain.get().getMessageView().deleteMessages(MESSAGE_CLASS_SEARCH);
        Object source = e.getSource();
        this.matchCount = 0;
        this.firstMatch = null;
        if (source instanceof Iterator) {
            this.performSearch((Iterator)source);
        } else {
            this.performSearch((Iterator)new SingleObjectIterator(source));
        }
        if (this.matchCount == 0) {
            this.showMatch("No matches found", null);
        } else if (this.matchCount == 1) {
            this.firstMatch.showContext();
            this.showMatch("1 match found", null);
        } else {
            this.showMatch(String.valueOf(this.matchCount) + " matches found", null);
        }
        FrameMain.get().showMessageView();
    }

    protected abstract void performSearch(Iterator var1);

    protected void showMatch(String text, FElement context) {
        SearchResult searchResult = new SearchResult();
        searchResult.setText(text);
        searchResult.addToContext(context);
        searchResult.setMessageCategory(MESSAGE_CLASS_SEARCH);
        FrameMain.get().getMessageView().addToMessages((Message)searchResult);
        if (this.firstMatch == null) {
            this.firstMatch = searchResult;
        }
        ++this.matchCount;
    }

    protected String getShortClassName(Object element) {
        String name = element.getClass().getName();
        int indexOfDot = name.lastIndexOf(46);
        if (indexOfDot >= 0) {
            name = name.substring(indexOfDot + 1);
        }
        if (name.startsWith("UML")) {
            name = name.substring(3);
        }
        return name;
    }
}

