/*
 * Decompiled with CFR 0.152.
 */
package de.uni_kassel.fujaba.refactorings.actions;

import de.uni_kassel.fujaba.refactorings.Refactoring;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.action.UpdateProjectTreeAction;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.upb.tools.fca.SingleObjectIterator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public abstract class RefactoringAction
extends AbstractAction {
    Set checkedSelection;

    protected void checkSelection() {
        HashSet<ASGElement> selection = new HashSet<ASGElement>();
        Iterator it = SelectionManager.get().iteratorOfSelectionAsIncrements();
        while (it.hasNext()) {
            ASGElement element = (ASGElement)it.next();
            selection.add(element);
        }
        if (selection.equals(this.checkedSelection)) {
            return;
        }
        this.checkedSelection = selection;
        try {
            Refactoring refactoring = this.getRefactoring(SelectionManager.get().iteratorOfSelectionAsIncrements(), false);
            this.setEnabled(refactoring.preconditionCheck().isSuccessful());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        Refactoring refactoring = source instanceof Iterator ? this.getRefactoring((Iterator)source, true) : this.getRefactoring((Iterator)new SingleObjectIterator(source), true);
        if (refactoring == null) {
            return;
        }
        try {
            Refactoring.PreconditionCheckResult preconditionCheckResult = refactoring.perform();
            String userFeedback = preconditionCheckResult.getUserFeedback();
            new UpdateProjectTreeAction().actionPerformed(null);
            if (userFeedback != null && !"".equals(userFeedback)) {
                JOptionPane.showMessageDialog((Component)FrameMain.get(), "The refactoring has been performed.\nBut note: " + userFeedback, refactoring.toString(), 2);
            } else {
                FrameMain.get().setStatusLabel("refactoring successful");
            }
        }
        catch (Refactoring.PreconditionCheckFailedException e1) {
            JOptionPane.showMessageDialog((Component)FrameMain.get(), e1.getPreconditionCheckResult().getUserFeedback(), refactoring.toString(), 0);
        }
    }

    protected abstract Refactoring getRefactoring(Iterator var1, boolean var2);
}

