/*
 * Decompiled with CFR 0.152.
 */
package de.uni_kassel.fujaba.refactorings;

public abstract class Refactoring {
    public abstract PreconditionCheckResult preconditionCheck() throws NotInitializedException;

    public PreconditionCheckResult perform() throws NotInitializedException, PreconditionCheckFailedException {
        PreconditionCheckResult preconditionCheck = this.preconditionCheck();
        if (!preconditionCheck.isSuccessful()) {
            throw new PreconditionCheckFailedException(preconditionCheck);
        }
        this.execute();
        return preconditionCheck;
    }

    protected abstract void execute();

    public String toString() {
        String name = this.getClass().getName();
        int lastIndexOfDot = name.lastIndexOf(46);
        if (lastIndexOfDot >= 0) {
            name = name.substring(lastIndexOfDot + 1);
        }
        return name;
    }

    public static class PreconditionCheckResult {
        public static final PreconditionCheckResult SUCCESS = new PreconditionCheckResult();
        private boolean successful;
        private String userFeedback;

        private PreconditionCheckResult() {
            this(true, null);
        }

        protected PreconditionCheckResult(boolean successful, String userFeedback) {
            this.successful = successful;
            this.userFeedback = userFeedback;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public String getUserFeedback() {
            return this.userFeedback;
        }
    }

    public static class NotInitializedException
    extends RuntimeException {
        public NotInitializedException(String message) {
            super(message);
        }

        public NotInitializedException() {
        }
    }

    public static class PreconditionCheckFailedException
    extends RuntimeException {
        private PreconditionCheckResult preconditionCheckResult;

        public PreconditionCheckFailedException(PreconditionCheckResult preconditionCheckResult) {
            this.preconditionCheckResult = preconditionCheckResult;
        }

        public PreconditionCheckResult getPreconditionCheckResult() {
            return this.preconditionCheckResult;
        }
    }
}

