/*
 * Decompiled with CFR 0.152.
 */
package de.uni_kassel.fujaba.refactorings;

import de.uni_kassel.fujaba.refactorings.Refactoring;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.asg.ASGUnparseInformation;
import de.uni_paderborn.fujaba.metamodel.FConstraint;
import de.uni_paderborn.fujaba.metamodel.FDiagram;
import de.uni_paderborn.fujaba.metamodel.FMethod;
import de.uni_paderborn.fujaba.metamodel.FParam;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLCollabStat;
import de.uni_paderborn.fujaba.uml.UMLComplexState;
import de.uni_paderborn.fujaba.uml.UMLConstraint;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLNopActivity;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStartActivity;
import de.uni_paderborn.fujaba.uml.UMLStatementActivity;
import de.uni_paderborn.fujaba.uml.UMLStopActivity;
import de.uni_paderborn.fujaba.uml.UMLStoryActivity;
import de.uni_paderborn.fujaba.uml.UMLStoryPattern;
import de.uni_paderborn.fujaba.uml.UMLTransition;
import de.uni_paderborn.fujaba.uml.UMLTransitionGuard;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class ExtractMethodRefactoring
extends Refactoring {
    private boolean warnNoStoryActivities;
    private boolean warnUnparsedExpressions;
    private UMLClass containingClass;
    private UMLActivityDiagram activityDiagram;
    private UMLObject resultValue;
    private Set activities;
    private UMLActivity successTarget;
    private UMLActivity failureTarget;
    private UMLActivity source;
    private Map objectsUsedBound;
    private List parameters;
    private String methodName;

    public boolean addToActivities(UMLActivity value) {
        boolean changed = false;
        if (value != null) {
            if (this.activities == null) {
                this.activities = new FHashSet();
            }
            changed = this.activities.add(value);
        }
        return changed;
    }

    public boolean hasInActivities(UMLActivity value) {
        return this.activities != null && value != null && this.activities.contains(value);
    }

    public Iterator iteratorOfActivities() {
        if (this.activities == null) {
            return FEmptyIterator.get();
        }
        return this.activities.iterator();
    }

    public void removeAllFromActivities() {
        Iterator iter = this.iteratorOfActivities();
        while (iter.hasNext()) {
            UMLActivity tmpValue = (UMLActivity)iter.next();
            this.removeFromActivities(tmpValue);
        }
    }

    public boolean removeFromActivities(UMLActivity value) {
        boolean changed = false;
        if (this.activities != null && value != null) {
            changed = this.activities.remove(value);
        }
        return changed;
    }

    public int sizeOfActivities() {
        return this.activities == null ? 0 : this.activities.size();
    }

    private void clear() {
        this.successTarget = null;
        this.failureTarget = null;
        this.source = null;
        this.objectsUsedBound = new TreeMap();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Refactoring.PreconditionCheckResult preconditionCheck() throws Refactoring.NotInitializedException {
        this.clear();
        if (this.getMethodName() == null || this.getMethodName().length() == 0) {
            return new Refactoring.PreconditionCheckResult(false, "Specify a name for the extracted method!");
        }
        this.warnNoStoryActivities = false;
        this.warnUnparsedExpressions = false;
        if (this.sizeOfActivities() == 0) {
            return new Refactoring.PreconditionCheckResult(false, "No activities selected to extract!");
        }
        this.activityDiagram = ((UMLActivity)this.iteratorOfActivities().next()).getActivityDiagram();
        UMLMethod storyMethod = this.activityDiagram.getStartActivity().getSpec();
        if (storyMethod == null) {
            return new Refactoring.PreconditionCheckResult(false, "The activity diagram does not belong to a method. Methods cannot be extracted from story boards.");
        }
        this.containingClass = storyMethod.getParent();
        Iterator it = this.iteratorOfActivities();
        while (it.hasNext()) {
            UMLActivity activity = (UMLActivity)it.next();
            if (activity instanceof UMLComplexState) {
                return new Refactoring.PreconditionCheckResult(false, "Cannot extract states!");
            }
            if (activity instanceof UMLStopActivity) {
                return new Refactoring.PreconditionCheckResult(false, "Stop activities not yet supported.");
            }
            if (activity instanceof UMLStartActivity) {
                return new Refactoring.PreconditionCheckResult(false, "Start activities not yet supported.");
            }
            if (activity instanceof UMLStatementActivity) {
                this.warnUnparsedExpressions = true;
            } else if (!(activity instanceof UMLNopActivity) && !(activity instanceof UMLStoryActivity)) {
                this.warnNoStoryActivities = true;
            }
            Refactoring.PreconditionCheckResult result = this.checkEntryTransitions(activity);
            if (!result.isSuccessful()) {
                return result;
            }
            result = this.checkExitTransitions(activity);
            if (!result.isSuccessful()) {
                return result;
            }
            Iterator itConstraint = activity.iteratorOfConstraints();
            while (itConstraint.hasNext()) {
                UMLConstraint constraint = (UMLConstraint)itConstraint.next();
                if (constraint.getText().startsWith("maybe")) continue;
                this.warnUnparsedExpressions = true;
            }
        }
        if (this.source == null) {
            return new Refactoring.PreconditionCheckResult(false, "Could not determine first activity: No entry transitions found!");
        }
        if (this.failureTarget == null && this.successTarget == null) {
            return new Refactoring.PreconditionCheckResult(false, "Could not determine last activities: No exit transitions found!");
        }
        HashSet knownObjectNames = new HashSet();
        HashSet visitedActivities = new HashSet();
        HashSet modifiedVariables = new HashSet();
        this.findObjectsUsedBound(this.source, knownObjectNames, visitedActivities, modifiedVariables, false, this.objectsUsedBound);
        if (visitedActivities.size() < this.sizeOfActivities()) {
            return new Refactoring.PreconditionCheckResult(false, "Some of the selected activities are not reachable from the entry transition!");
        }
        HashMap objectsUsedBoundAfterwards = new HashMap();
        if (this.successTarget != null) {
            this.findObjectsUsedBound(this.successTarget, new HashSet(), new HashSet(), new HashSet(), true, objectsUsedBoundAfterwards);
        }
        if (this.failureTarget != null) {
            this.findObjectsUsedBound(this.failureTarget, new HashSet(), new HashSet(), new HashSet(), true, objectsUsedBoundAfterwards);
        }
        modifiedVariables.retainAll(objectsUsedBoundAfterwards.keySet());
        if (modifiedVariables.size() > 0) {
            if (modifiedVariables.size() > 1) {
                return new Refactoring.PreconditionCheckResult(false, "Multiple object variables are changed within the selected activities that are used 'bound' afterwards,\nbut only one value can be returned as result value.\nSet some of the objects in the succeeding activities to unbound: " + modifiedVariables);
            }
            this.resultValue = (UMLObject)objectsUsedBoundAfterwards.get(modifiedVariables.iterator().next());
            if (this.successTarget != null && this.failureTarget != null) {
                return new Refactoring.PreconditionCheckResult(false, "More than one activity is reached by transitions from the selected activities,\nthis requires a boolean result value for the method.\nThe object '" + this.resultValue.getObjectName() + "' is used in the succeeding activities and thus the method requires an object as result value.\n" + "Set the object '" + this.resultValue.getObjectName() + "' to unbound in the succeeding activities or remove a transition.");
            }
        } else {
            this.resultValue = null;
        }
        this.parameters = new Vector(this.objectsUsedBound.size());
        Iterator it2 = this.objectsUsedBound.values().iterator();
        while (it2.hasNext()) {
            UMLObject object = (UMLObject)it2.next();
            UMLParam param = new UMLParam(false);
            param.setName(object.getObjectName());
            param.setParamType((FType)object.getInstanceOf());
            this.parameters.add(param);
        }
        String methodSignature = UMLMethod.constructFullMethodName((String)this.getMethodName(), this.parameters.iterator());
        if (this.containingClass.getFromMethods(methodSignature) != null) {
            return new Refactoring.PreconditionCheckResult(false, "A method with the generated signature already exists in the class: " + methodSignature);
        }
        String feedback = "";
        if (this.warnNoStoryActivities) {
            feedback = String.valueOf(feedback) + "Some of the extracted activities are unknown to this refactoring, this may result in wrong method extraction.";
        } else if (this.warnUnparsedExpressions) {
            feedback = String.valueOf(feedback) + "As condition expressions (and typecast sources) are not parsed yet they may result in wrong method extraction.";
        }
        if ("".equals(feedback)) {
            return Refactoring.PreconditionCheckResult.SUCCESS;
        }
        return new Refactoring.PreconditionCheckResult(true, feedback);
    }

    private void findObjectsUsedBound(UMLActivity activity, HashSet knownObjectNames, HashSet visitedActivities, HashSet modifiedVariables, boolean searchInUnselectedActivities, Map objectsUsedBound) {
        knownObjectNames.add("this");
        visitedActivities.add(activity);
        if (activity instanceof UMLStoryActivity) {
            UMLStoryActivity storyActivity = (UMLStoryActivity)activity;
            Iterator itObjects = storyActivity.getStoryPattern().iteratorOfObjects();
            while (itObjects.hasNext()) {
                String name;
                UMLObject object = (UMLObject)itObjects.next();
                if (searchInUnselectedActivities && object.sizeOfAttrs() > 0) {
                    this.warnUnparsedExpressions = true;
                }
                if (!knownObjectNames.contains(name = object.getObjectName())) {
                    if (object.isBound()) {
                        String typeCastSource = object.getTypeCastSource();
                        if (typeCastSource == null) {
                            objectsUsedBound.put(name, object);
                        } else if (!knownObjectNames.contains(typeCastSource)) {
                            this.warnUnparsedExpressions = true;
                        }
                    }
                    knownObjectNames.add(name);
                }
                if (object.isBound() && object.getTypeCastSource() == null) continue;
                modifiedVariables.add(name);
            }
        }
        Iterator it = activity.iteratorOfExit();
        while (it.hasNext()) {
            UMLTransition transition = (UMLTransition)it.next();
            UMLActivity target = transition.getRevEntry();
            if (visitedActivities.contains(target) || !searchInUnselectedActivities && !this.hasInActivities(target)) continue;
            this.findObjectsUsedBound(target, knownObjectNames, visitedActivities, modifiedVariables, searchInUnselectedActivities, objectsUsedBound);
        }
    }

    private Refactoring.PreconditionCheckResult checkExitTransitions(UMLActivity activity) {
        Iterator itTransitions = activity.iteratorOfExit();
        while (itTransitions.hasNext()) {
            UMLTransition transition = (UMLTransition)itTransitions.next();
            UMLActivity targetActivity = transition.getRevEntry();
            if (!this.hasInActivities(targetActivity) && this.successTarget != targetActivity && this.failureTarget != targetActivity) {
                if (this.successTarget != null || transition.getGuard() != null && transition.getGuard().getType() == 2) {
                    if (this.failureTarget == null) {
                        this.failureTarget = targetActivity;
                    } else {
                        if (this.successTarget != null) {
                            return new Refactoring.PreconditionCheckResult(false, "More than two exiting transitions found but only boolean result values are supported!");
                        }
                        this.successTarget = targetActivity;
                    }
                } else if (this.successTarget == null) {
                    this.successTarget = targetActivity;
                } else {
                    if (this.failureTarget != null) {
                        return new Refactoring.PreconditionCheckResult(false, "More than two exiting transitions found but only boolean result values are supported!");
                    }
                    this.failureTarget = targetActivity;
                }
            }
            if (transition.getGuard() == null || transition.getGuard().getType() != 6) continue;
            this.warnUnparsedExpressions = true;
        }
        return Refactoring.PreconditionCheckResult.SUCCESS;
    }

    private Refactoring.PreconditionCheckResult checkEntryTransitions(UMLActivity activity) {
        Iterator itTransitions = activity.iteratorOfEntry();
        while (itTransitions.hasNext()) {
            UMLTransition transition = (UMLTransition)itTransitions.next();
            if (!this.hasInActivities(transition.getRevExit())) {
                if (this.source != null && this.source != activity) {
                    return new Refactoring.PreconditionCheckResult(false, "Cannot handle entry transitions to different activities!");
                }
                this.source = activity;
                continue;
            }
            if (transition.getGuard() == null || transition.getGuard().getType() != 6) continue;
            this.warnUnparsedExpressions = true;
        }
        return Refactoring.PreconditionCheckResult.SUCCESS;
    }

    protected void execute() {
        UMLTransitionGuard guard;
        UMLStopActivity stop;
        UMLTransition transition;
        Iterator it;
        UMLMethod extractedMethod = new UMLMethod(this.getMethodName());
        Iterator it2 = this.parameters.iterator();
        while (it2.hasNext()) {
            UMLParam param = (UMLParam)it2.next();
            extractedMethod.addToParam((FParam)new UMLParam(param.getName(), param.getParamType()));
        }
        this.containingClass.addToMethods((FMethod)extractedMethod);
        UMLActivityDiagram newStoryDiagram = extractedMethod.createStoryDiagram();
        Iterator it3 = this.iteratorOfActivities();
        while (it3.hasNext()) {
            UMLActivity activity = (UMLActivity)it3.next();
            ASGUnparseInformation unparseInformations = activity.getFromUnparseInformations((ASGElement)this.activityDiagram);
            activity.removeFromUnparseInformations((ASGElement)this.activityDiagram);
            activity.addToUnparseInformations((ASGElement)newStoryDiagram, unparseInformations);
            activity.removeAllFromDiagrams();
            activity.addToDiagrams((FDiagram)newStoryDiagram);
            Iterator it22 = activity.iteratorOfExit();
            while (it22.hasNext()) {
                UMLTransition transition2 = (UMLTransition)it22.next();
                transition2.removeAllFromDiagrams();
                transition2.addToDiagrams((FDiagram)newStoryDiagram);
            }
        }
        UMLStoryPattern storyPattern = new UMLStoryPattern();
        UMLStoryActivity newStoryActivity = new UMLStoryActivity(false, storyPattern);
        newStoryActivity.addToUnparseInformations((ASGElement)this.activityDiagram, new ASGUnparseInformation(this.source.getFromUnparseInformations((ASGElement)newStoryDiagram)));
        newStoryActivity.addToDiagrams((FDiagram)this.activityDiagram);
        boolean useBooleanResult = this.successTarget != null && this.failureTarget != null;
        String callText = String.valueOf(this.methodName) + "( ";
        Iterator it4 = this.parameters.iterator();
        while (it4.hasNext()) {
            UMLParam param = (UMLParam)it4.next();
            callText = String.valueOf(callText) + param.getName();
            if (!it4.hasNext()) continue;
            callText = String.valueOf(callText) + ", ";
        }
        callText = String.valueOf(callText) + " )";
        if (useBooleanResult) {
            UMLConstraint constraint = new UMLConstraint(callText);
            newStoryActivity.addToConstraints((FConstraint)constraint);
            newStoryActivity.getStoryPattern().addToElements((ASGElement)constraint);
            extractedMethod.setResultType((FType)UMLProject.get().getFromBaseTypes("Boolean"));
        } else if (this.resultValue != null) {
            UMLObject resultObject = new UMLObject(this.resultValue.getObjectName(), null, 0, true, 0, this.resultValue.getInstanceOf());
            resultObject.setTypeCastSource(callText);
            storyPattern.addToElements((ASGElement)resultObject);
            extractedMethod.setResultType((FType)this.resultValue.getInstanceOf());
        } else {
            UMLObject thisObject = new UMLObject("this", null, 0, true, 0, this.containingClass);
            storyPattern.addToElements((ASGElement)thisObject);
            UMLCollabStat masterCollabStat = new UMLCollabStat();
            storyPattern.setRevMasterCollabStat(masterCollabStat);
            UMLCollabStat invocation = new UMLCollabStat(masterCollabStat, thisObject, thisObject, (UMLDiagram)storyPattern);
            invocation.setNumber(1);
            invocation.setCallText(callText);
            extractedMethod.setResultType((FType)UMLProject.get().getFromBaseTypes("Void"));
        }
        it4 = this.source.iteratorOfEntry();
        while (it4.hasNext()) {
            UMLTransition transition3 = (UMLTransition)it4.next();
            if (this.hasInActivities(transition3.getRevExit())) continue;
            transition3.setRevEntry((UMLActivity)newStoryActivity);
        }
        UMLStartActivity newStartActivity = newStoryDiagram.getStartActivity();
        newStoryDiagram.addToElements((ASGElement)new UMLTransition((UMLActivity)newStartActivity, this.source, new UMLTransitionGuard()));
        newStartActivity.addToUnparseInformations((ASGElement)newStoryDiagram, new ASGUnparseInformation(this.activityDiagram.getStartActivity().getFromUnparseInformations((ASGElement)this.activityDiagram)));
        if (this.successTarget != null) {
            it = this.successTarget.iteratorOfEntry();
            while (it.hasNext()) {
                transition = (UMLTransition)it.next();
                if (!this.hasInActivities(transition.getRevExit())) continue;
                stop = new UMLStopActivity(true, useBooleanResult ? "true" : null);
                transition.setRevEntry((UMLActivity)stop);
                stop.addToUnparseInformations((ASGElement)newStoryDiagram, new ASGUnparseInformation(this.successTarget.getFromUnparseInformations((ASGElement)this.activityDiagram)));
                newStoryDiagram.addToElements((ASGElement)stop);
            }
        }
        if (this.failureTarget != null) {
            it = this.failureTarget.iteratorOfEntry();
            while (it.hasNext()) {
                transition = (UMLTransition)it.next();
                if (!this.hasInActivities(transition.getRevExit())) continue;
                stop = new UMLStopActivity(true, useBooleanResult ? "false" : null);
                transition.setRevEntry((UMLActivity)stop);
                stop.addToUnparseInformations((ASGElement)newStoryDiagram, new ASGUnparseInformation(this.failureTarget.getFromUnparseInformations((ASGElement)this.activityDiagram)));
                newStoryDiagram.addToElements((ASGElement)stop);
            }
        }
        if (this.successTarget != null) {
            guard = useBooleanResult ? new UMLTransitionGuard(1, null, null) : new UMLTransitionGuard();
            new UMLTransition((UMLActivity)newStoryActivity, this.successTarget, guard).addToDiagrams((FDiagram)this.activityDiagram);
        }
        if (this.failureTarget != null) {
            guard = useBooleanResult ? new UMLTransitionGuard(2, null, null) : new UMLTransitionGuard();
            new UMLTransition((UMLActivity)newStoryActivity, this.failureTarget, guard).addToDiagrams((FDiagram)this.activityDiagram);
        }
    }
}

