/*
 * Decompiled with CFR 0.152.
 */
package de.uni_kassel.fujaba.refactorings;

import de.uni_kassel.fujaba.refactorings.Refactoring;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FDiagram;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLGeneralization;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.fujaba.uml.UMLStartActivity;
import de.uni_paderborn.fujaba.uml.UMLTransition;
import de.uni_paderborn.fujaba.uml.UMLTransitionGuard;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class CreateMethod
extends Refactoring {
    private Set methods;
    private UMLClass declaringClass;

    public boolean addToMethods(UMLMethod value) {
        boolean changed = false;
        if (value != null) {
            if (this.methods == null) {
                this.methods = new FHashSet();
            }
            changed = this.methods.add(value);
        }
        return changed;
    }

    public boolean hasInMethods(UMLMethod value) {
        return this.methods != null && value != null && this.methods.contains(value);
    }

    public Iterator iteratorOfMethods() {
        if (this.methods == null) {
            return FEmptyIterator.get();
        }
        return this.methods.iterator();
    }

    public void removeAllFromMethods() {
        Iterator iter = this.iteratorOfMethods();
        while (iter.hasNext()) {
            UMLMethod tmpValue = (UMLMethod)iter.next();
            this.removeFromMethods(tmpValue);
        }
    }

    public boolean removeFromMethods(UMLMethod value) {
        boolean changed = false;
        if (this.methods != null && value != null) {
            changed = this.methods.remove(value);
        }
        return changed;
    }

    public int sizeOfMethods() {
        return this.methods == null ? 0 : this.methods.size();
    }

    public UMLClass getDeclaringClass() {
        return this.declaringClass;
    }

    public void setDeclaringClass(UMLClass value) {
        UMLClass oldValue = this.declaringClass;
        if (oldValue != value) {
            this.declaringClass = value;
        }
    }

    public Refactoring.PreconditionCheckResult preconditionCheck() throws Refactoring.NotInitializedException {
        if (this.getDeclaringClass() == null) {
            return new Refactoring.PreconditionCheckResult(false, "Select one class that will receive the new method(s).");
        }
        if (this.getDeclaringClass().getFromStereotypes("interface") != null) {
            return new Refactoring.PreconditionCheckResult(false, "Cannot override/implement methods in an interface.");
        }
        if (this.sizeOfMethods() == 0) {
            return new Refactoring.PreconditionCheckResult(false, "No method chosen!");
        }
        Iterator itMethods = this.iteratorOfMethods();
        while (itMethods.hasNext()) {
            UMLMethod method = (UMLMethod)itMethods.next();
            if (method.isStatic()) {
                return new Refactoring.PreconditionCheckResult(false, "A selected method is static! One can only override instance methods.");
            }
            if (method.getVisibility() == 0) {
                return new Refactoring.PreconditionCheckResult(false, "A selected method is private! One can only override public, protected and package visible methods.");
            }
            String signature = method.getFullMethodName();
            if (this.getDeclaringClass().getFromMethods(signature) != null) {
                return new Refactoring.PreconditionCheckResult(false, "A method named '" + signature + "' is already implemented in " + this.getDeclaringClass().getFullClassName());
            }
            Refactoring.PreconditionCheckResult specificCheckResult = this.checkSpecific(method);
            if (specificCheckResult != null && !specificCheckResult.isSuccessful()) {
                return specificCheckResult;
            }
            Refactoring.PreconditionCheckResult result = this.methodInSuperClass(this.getDeclaringClass(), method);
            if (result != null) {
                if (result.isSuccessful()) continue;
                return result;
            }
            return new Refactoring.PreconditionCheckResult(false, "A selected method is not within a superclass/interface of the selected class.");
        }
        return Refactoring.PreconditionCheckResult.SUCCESS;
    }

    protected Refactoring.PreconditionCheckResult methodInSuperClass(UMLClass cls, UMLMethod method) {
        String signature = method.getFullMethodName();
        Refactoring.PreconditionCheckResult result = null;
        Iterator it = cls.iteratorOfRevSubclass();
        while (it.hasNext()) {
            UMLGeneralization gen = (UMLGeneralization)it.next();
            UMLClass superclass = gen.getSuperclass();
            if (this.getDeclaringClass() == superclass) {
                return new Refactoring.PreconditionCheckResult(false, "The selected class is a subclass of itselves! Refactoring aborted.");
            }
            if (method.getParent() == superclass) {
                return Refactoring.PreconditionCheckResult.SUCCESS;
            }
            if (superclass.getFromMethods(signature) != null) {
                UMLMethod foundMethod = superclass.getFromMethods(signature);
                if (this.checkFoundMethod(method, foundMethod)) continue;
                return new Refactoring.PreconditionCheckResult(false, "Method '" + signature + "' already in '" + superclass.getFullClassName());
            }
            Refactoring.PreconditionCheckResult superResult = this.methodInSuperClass(superclass, method);
            if (superResult == null) continue;
            result = superResult;
        }
        return result;
    }

    protected abstract boolean checkFoundMethod(UMLMethod var1, UMLMethod var2);

    protected abstract Refactoring.PreconditionCheckResult checkSpecific(UMLMethod var1);

    protected void execute() {
        Iterator itMethods = this.iteratorOfMethods();
        while (itMethods.hasNext()) {
            UMLMethod method = (UMLMethod)itMethods.next();
            UMLMethod newMethod = new UMLMethod(method.getName());
            newMethod.setResultType((FType)method.getResultType());
            Iterator it = method.iteratorOfParam();
            while (it.hasNext()) {
                UMLParam param = (UMLParam)it.next();
                new UMLParam(param.getName(), param.getParamType(), newMethod);
            }
            newMethod.setParent((FClass)this.getDeclaringClass());
            UMLActivityDiagram activityDiagram = newMethod.createStoryDiagram();
            UMLStartActivity startActivity = activityDiagram.getStartActivity();
            UMLActivity firstActivity = this.createMethodContentActivities(activityDiagram, method);
            new UMLTransition((UMLActivity)startActivity, firstActivity, new UMLTransitionGuard()).addToDiagrams((FDiagram)activityDiagram);
        }
    }

    protected abstract UMLActivity createMethodContentActivities(UMLActivityDiagram var1, UMLMethod var2);
}

