/*
 * Decompiled with CFR 0.152.
 */
package de.uni_kassel.fujaba.refactorings;

import de.uni_kassel.fujaba.refactorings.Refactoring;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FParam;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.uni_paderborn.tools.util.MethodDeclaration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ChangeSignatureRefactoring
extends Refactoring {
    private UMLMethod newMethod;
    private HashSet dependentMethods;
    private UMLMethod method;
    private String newSignature;

    public UMLMethod getMethod() {
        return this.method;
    }

    public void setMethod(UMLMethod value) {
        UMLMethod oldValue = this.method;
        if (oldValue != value) {
            this.method = value;
        }
    }

    public String getNewSignature() {
        return this.newSignature;
    }

    public void setNewSignature(String value) {
        String oldValue = this.newSignature;
        if (oldValue != value) {
            this.newSignature = value;
        }
    }

    public Refactoring.PreconditionCheckResult preconditionCheck() throws Refactoring.NotInitializedException {
        FType returnType;
        String warnings = "";
        if (this.getMethod() == null) {
            return new Refactoring.PreconditionCheckResult(false, "No method was selected.");
        }
        if (this.getNewSignature() == null) {
            return new Refactoring.PreconditionCheckResult(false, "No new signature was specified.");
        }
        MethodDeclaration methodDeclaration = new MethodDeclaration(this.getNewSignature());
        String newMethodName = methodDeclaration.getName();
        if (newMethodName == null || "".equals(newMethodName)) {
            newMethodName = this.getMethod().getName();
        }
        if ((returnType = this.findType(methodDeclaration.getReturnType(), this.getMethod().getResultType())) == null) {
            returnType = this.getMethod().getResultType();
            warnings = String.valueOf(warnings) + "The specified result type was not found.\n";
        }
        this.newMethod = new UMLMethod(false);
        this.newMethod.setName(newMethodName);
        this.newMethod.setResultType(returnType);
        String[] parameterTypes = methodDeclaration.getParameters();
        String[] parameterVariables = methodDeclaration.getParameterVariables();
        int i = 0;
        while (i < parameterTypes.length) {
            String parameterType = parameterTypes[i];
            UMLParam param = new UMLParam(false);
            param.setName(parameterVariables[i]);
            FType type = this.findType(parameterType, null);
            if (type == null) {
                warnings = String.valueOf(warnings) + "The parameter type '" + parameterType + "' was not found and replaced by 'String'.\n";
                type = UMLProject.get().getFromBaseTypes("String");
            }
            param.setParamType(type);
            this.newMethod.addToParam((FParam)param);
            ++i;
        }
        String newFullMethodName = this.newMethod.getFullMethodName();
        this.dependentMethods = new HashSet();
        this.findDependentMethods(this.getMethod(), this.dependentMethods);
        this.dependentMethods.add(this.getMethod());
        if (!newFullMethodName.equals(this.getMethod().getFullMethodName())) {
            HashSet collidingMethods = new HashSet();
            Iterator it = this.dependentMethods.iterator();
            while (it.hasNext()) {
                UMLMethod method = (UMLMethod)it.next();
                collidingMethods.addAll(method.getParent().findMethodsWithSignatureInSuperclasses(newFullMethodName));
                collidingMethods.addAll(method.getParent().findMethodsWithSignatureInSubclasses(newFullMethodName));
            }
            if (collidingMethods.size() > 0) {
                String classes = "";
                HashSet<UMLClass> classesSet = new HashSet<UMLClass>();
                Iterator it2 = collidingMethods.iterator();
                while (it2.hasNext()) {
                    UMLMethod method = (UMLMethod)it2.next();
                    classesSet.add(method.getParent());
                }
                it2 = classesSet.iterator();
                while (it2.hasNext()) {
                    UMLClass aClass = (UMLClass)it2.next();
                    classes = "".equals(classes) ? aClass.getName() : String.valueOf(classes) + ", " + aClass.getName();
                }
                return new Refactoring.PreconditionCheckResult(false, "New method signature conflicts with already existing methods in\nthe class hierarchy in " + classes);
            }
        }
        return new Refactoring.PreconditionCheckResult(true, warnings.trim());
    }

    private void findDependentMethods(UMLMethod method, Set methods) {
        UMLMethod dependentMethod;
        Iterator it = method.iteratorOfOverridingMethods();
        while (it.hasNext()) {
            dependentMethod = (UMLMethod)it.next();
            if (!methods.add(dependentMethod)) continue;
            this.findDependentMethods(dependentMethod, methods);
        }
        it = method.iteratorOfOverriddenMethods();
        while (it.hasNext()) {
            dependentMethod = (UMLMethod)it.next();
            if (!methods.add(dependentMethod)) continue;
            this.findDependentMethods(dependentMethod, methods);
        }
    }

    private FType findType(String typeName, UMLType defaultType) {
        UMLType type;
        if (typeName == null || "".equals(typeName)) {
            type = defaultType;
        } else {
            if ("int".equals(typeName)) {
                typeName = "Integer";
            } else if ("bool".equals(typeName)) {
                typeName = "Boolean";
            } else if ("long".equals(typeName)) {
                typeName = "LongInteger";
            } else if ("char".equals(typeName)) {
                typeName = "Character";
            } else if ("void".equals(typeName)) {
                typeName = "Void";
            } else if ("double".equals(typeName)) {
                typeName = "Double";
            } else if ("short".equals(typeName)) {
                typeName = "ShortInteger";
            }
            type = UMLProject.get().getTypeList().getFromFTypes(typeName);
            if (type == null && (type = UMLProject.get().findClass(null, typeName, false)) == null) {
                Iterator it = UMLProject.get().getTypeList().iteratorOfTypes();
                while (it.hasNext()) {
                    UMLType aType = (UMLType)it.next();
                    if (!typeName.equals(aType.getName())) continue;
                    return aType;
                }
            }
        }
        return type;
    }

    protected void execute() {
        Iterator it = this.dependentMethods.iterator();
        while (it.hasNext()) {
            UMLMethod method = (UMLMethod)it.next();
            UMLClass parent = method.getParent();
            method.setParent(null);
            method.setName(this.newMethod.getName());
            method.setResultType((FType)this.newMethod.getResultType());
            Iterator paramIter = this.newMethod.iteratorOfParam();
            Iterator it2 = method.iteratorOfParam();
            while (it2.hasNext()) {
                UMLParam param = (UMLParam)it2.next();
                if (paramIter.hasNext()) {
                    UMLParam newParam = (UMLParam)paramIter.next();
                    param.setName(newParam.getName());
                    param.setParamType((FType)newParam.getParamType());
                    continue;
                }
                param.removeYou();
            }
            while (paramIter.hasNext()) {
                UMLParam newParam = (UMLParam)paramIter.next();
                method.addToParam((FParam)new UMLParam(newParam.getName(), newParam.getParamType()));
            }
            method.setParent((FClass)parent);
        }
    }
}

