/*
 * Decompiled with CFR 0.152.
 */
package org.jibble.simplewebserver;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.jibble.simplewebserver.SimpleWebServer;

public class SecureWebServer
extends SimpleWebServer {
    private final String keyStorageFile;
    private final char[] keyStoragePassword;
    private final char[] keyPassword;
    private final boolean requireClientAuthentication;
    public static final int DEFAULT_PORT = 444;

    public static void main(String[] args) {
        try {
            new SecureWebServer(new File("."), 444, false, "certs", "cbrpwd", "cbrpass");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SecureWebServer(File rootDir, int port, boolean requireClientAuthentication, String keyStorageFile, String keyStoragePassword, String keyPassword) throws IOException {
        super(rootDir, port);
        this.requireClientAuthentication = requireClientAuthentication;
        this.keyStorageFile = keyStorageFile;
        this.keyStoragePassword = keyStoragePassword.toCharArray();
        this.keyPassword = keyPassword.toCharArray();
        this.start();
    }

    protected ServerSocket getServerSocket(int port) throws IOException {
        try {
            Security.addProvider((java.security.Provider)new Provider());
            KeyStore keystore = KeyStore.getInstance("JKS");
            keystore.load(new FileInputStream(this.keyStorageFile), this.keyStoragePassword);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keystore, this.keyPassword);
            SSLContext sslc = SSLContext.getInstance("SSLv3");
            sslc.init(kmf.getKeyManagers(), null, null);
            SSLServerSocketFactory ssf = sslc.getServerSocketFactory();
            SSLServerSocket serverSocket = (SSLServerSocket)ssf.createServerSocket(port);
            serverSocket.setNeedClientAuth(this.requireClientAuthentication);
            return serverSocket;
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
    }
}

