/*
 * Decompiled with CFR 0.152.
 */
package org.jibble.simplewebserver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Vector;
import org.jibble.simplewebserver.SimpleWebServer;

public class RequestThread
extends Thread {
    private static final int CODE_NOT_FOUND = 404;
    private static final int CODE_PERMISSION_DENIED = 403;
    private static final int TIMEOUT = 30000;
    private static final int CODE_INVALID_METHOD = 500;
    private static final int CODE_OK = 200;
    private static final int BUFFER_SIZE = 4096;
    private File rootDir;
    private Socket _socket;

    public RequestThread(Socket socket, File rootDir) {
        this._socket = socket;
        this.rootDir = rootDir;
    }

    protected static void sendHeader(BufferedOutputStream out, int code, String contentType, long contentLength, long lastModified) throws IOException {
        out.write(("HTTP/1.0 " + code + " OK\r\n" + "Date: " + new Date().toString() + "\r\n" + "Server: JibbleWebServer/1.0\r\n" + "Content-Type: " + contentType + "\r\n" + "Expires: Thu, 01 Dec 1994 16:00:00 GMT\r\n" + (contentLength != -1L ? "Content-Length: " + contentLength + "\r\n" : "") + "Last-modified: " + new Date(lastModified).toString() + "\r\n" + "\r\n").getBytes());
    }

    protected void sendError(BufferedOutputStream out, int code, String message) throws IOException {
        message = message + "<hr>" + this.getVersion();
        RequestThread.sendHeader(out, code, "text/html", message.length(), System.currentTimeMillis());
        out.write(message.getBytes());
        out.flush();
        out.close();
    }

    public void run() {
        try {
            String firstLine;
            String requestLine;
            this._socket.setSoTimeout(30000);
            BufferedReader in = new BufferedReader(new InputStreamReader(this._socket.getInputStream()));
            BufferedOutputStream out = new BufferedOutputStream(this._socket.getOutputStream());
            String host = null;
            Vector<String> request = new Vector<String>();
            while ((requestLine = in.readLine()) != null && !"".equals(requestLine)) {
                int hostIndex;
                int httpIndex;
                request.add(requestLine);
                if (requestLine.startsWith("GET ") && (httpIndex = requestLine.indexOf("http://")) >= 0) {
                    host = requestLine.substring(httpIndex + 7, requestLine.indexOf(47, httpIndex + 7)).trim();
                }
                if ((hostIndex = requestLine.indexOf("Host: ")) < 0) continue;
                host = requestLine.substring(hostIndex + 6, requestLine.length()).trim();
            }
            String string = firstLine = request.size() < 1 ? null : (String)request.get(0);
            if (firstLine == null || !firstLine.startsWith("GET ") || !firstLine.endsWith(" HTTP/1.0") && !firstLine.endsWith("HTTP/1.1")) {
                this.sendError(out, 500, "Invalid Method.");
                return;
            }
            String path = firstLine.substring(4, firstLine.length() - 9);
            this.handleRequest(path, out, host);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void handleRequest(String path, BufferedOutputStream out, String clientSpecifiedServerName) throws IOException {
        this.handleFileRequest(path, out, clientSpecifiedServerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFileRequest(String path, BufferedOutputStream out, String clientSpecifiedServerName) throws IOException {
        File indexFile;
        File file = new File(this.getRootDir(), URLDecoder.decode(path, "UTF-8")).getCanonicalFile();
        if (file.isDirectory() && (indexFile = new File(file, "index.html")).exists() && !indexFile.isDirectory()) {
            this.handleRequest(indexFile.getPath(), out, clientSpecifiedServerName);
            return;
        }
        if (this.getRootDir() == null || !file.toString().startsWith(this.getRootDir().toString())) {
            this.sendError(out, 403, "Permission Denied.");
        } else if (!file.exists()) {
            this.sendError(out, 404, "File Not Found.");
        } else if (file.isDirectory()) {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            File[] files = file.listFiles();
            RequestThread.sendHeader(out, 200, "text/html", -1L, System.currentTimeMillis());
            String title = "Index of " + path;
            out.write(("<html><head><title>" + title + "</title></head><body><h3>Index of " + path + "</h3><p>\n").getBytes());
            for (int i = 0; i < files.length; ++i) {
                file = files[i];
                String filename = file.getName();
                String description = "";
                if (file.isDirectory()) {
                    description = "&lt;DIR&gt;";
                }
                out.write(("<a href=\"" + path + filename + "\">" + filename + "</a> " + description + "<br>\n").getBytes());
            }
            out.write(("</p><hr><p>" + this.getVersion() + ": Request: " + this._socket + "</p></body><html>").getBytes());
        } else {
            BufferedInputStream reader = new BufferedInputStream(new FileInputStream(file));
            try {
                int bytesRead;
                String extension = SimpleWebServer.getExtension(file.getName());
                String contentType = RequestThread.getContentType(extension);
                RequestThread.sendHeader(out, 200, contentType, file.length(), file.lastModified());
                byte[] buffer = new byte[4096];
                while ((bytesRead = ((InputStream)reader).read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            finally {
                try {
                    ((InputStream)reader).close();
                }
                catch (Exception anye) {
                    anye.printStackTrace();
                }
            }
        }
    }

    protected String getVersion() {
        return "SimpleWebServer  http://www.jibble.org/";
    }

    protected static String getContentType(String extension) {
        String contentType = (String)SimpleWebServer.MIME_TYPES.get(extension);
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        return contentType;
    }

    public File getRootDir() {
        return this.rootDir;
    }
}

