/*
 * Decompiled with CFR 0.152.
 */
package de.uni_kassel.prop;

import de.uni_kassel.prop.JPropertyTable;
import de.uni_kassel.prop.ObjectInspector;
import de.uni_kassel.prop.PropertyChangeSource;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.fca.FLinkedList;
import de.upb.tools.fca.FTreeMap;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class PropertyTableTest
extends TestCase {
    public PropertyTableTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        new PropertyTableTest("PropertyTableTest").testTables();
    }

    public void testTables() {
        JPropertyTable table1 = JPropertyTable.createPropertyTableWindow(true);
        JPropertyTable table2 = JPropertyTable.createPropertyTableWindow(false);
        MySomething lister = new MySomething();
        lister.setName("master");
        for (int i = 0; i < 10; ++i) {
            MySomething ms = new MySomething();
            ms.setName("item " + i);
            ms.setParent(lister);
        }
        ObjectInspector.get().setProposalLister(MySomething.class, "parent", lister, "allItems");
        table1.linkShownObjectsToProperty(lister, "children");
        table2.linkShownObjectsToProperty(lister, "allItems");
        FTreeMap defaultValues = new FTreeMap();
        defaultValues.put("parent", lister);
        defaultValues.put("name", "new");
        table1.setClassForNewObjects(MySomething.class, (Map)defaultValues);
        table2.setClassForNewObjects(MySomething.class, (Map)defaultValues);
    }

    private static class MySomething
    implements PropertyChangeSource {
        private String name;
        private boolean enabled;
        private MySomething parent;
        private String readonly = "cannot be altered";
        private Set children = new FHashSet();
        private Point position;
        private int number;
        private static List allItems = new FLinkedList();
        private PropertyChangeSupport changeSupport;

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            int oldValue = this.number;
            this.number = number;
            this.firePropertyChange(new PropertyChangeEvent(this, "number", new Integer(oldValue), new Integer(number)));
        }

        public Point getPosition() {
            return this.position;
        }

        public void setPosition(Point position) {
            this.position = position;
        }

        public String getReadonly() {
            return this.readonly;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            if (this.enabled != enabled) {
                boolean oldValue = this.enabled;
                this.enabled = enabled;
                this.firePropertyChange(new PropertyChangeEvent(this, "enabled", oldValue, new Boolean(enabled)));
                Iterator it = this.iteratorOfChildren();
                while (it.hasNext()) {
                    MySomething child = (MySomething)it.next();
                    child.setEnabled(enabled);
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public MySomething getParent() {
            return this.parent;
        }

        public void setParent(MySomething parent) {
            if (this.parent != parent) {
                if (this.parent != null) {
                    MySomething oldParent = this.parent;
                    this.parent = null;
                    oldParent.children.remove(this);
                    oldParent.firePropertyChange(new PropertyChangeEvent(oldParent, "children", this, null));
                }
                if (parent != null) {
                    this.parent = parent;
                    parent.children.add(this);
                    parent.firePropertyChange(new PropertyChangeEvent(parent, "children", null, this));
                }
            }
        }

        public Iterator iteratorOfChildren() {
            return this.children.iterator();
        }

        public String toString() {
            return this.name == null ? "(unnamed)" : this.name;
        }

        public static Iterator iteratorOfAllItems() {
            return allItems.iterator();
        }

        public MySomething() {
            allItems.add(this);
            ((MySomething)allItems.get(0)).firePropertyChange(new PropertyChangeEvent(allItems.get(0), "allItems", null, this));
            this.position = new Point(0, 0);
        }

        private void firePropertyChange(PropertyChangeEvent e) {
            if (this.changeSupport != null) {
                this.changeSupport.firePropertyChange(e);
            }
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            if (listener == null) {
                return;
            }
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            if (listener == null || this.changeSupport == null) {
                return;
            }
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }
}

