/*
 * Decompiled with CFR 0.152.
 */
package de.uni_kassel.prop;

import de.uni_kassel.prop.CustomEditor;
import de.uni_kassel.prop.PropertyConfiguration;
import de.upb.tools.fca.FHashMap;
import de.upb.tools.fca.FTreeMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPopupMenu;

public class PropertyConfigurationAdapter
implements PropertyConfiguration {
    private Map fieldValueProposals;
    Map clientProperties = new FTreeMap();
    private Map inspectionLevels = new FTreeMap();
    private Map editors = new FHashMap();

    public void setProposalLister(Class cls, String fieldName, Object lister, String listerFieldName) {
        if (this.fieldValueProposals == null) {
            this.fieldValueProposals = new FTreeMap();
        }
        this.fieldValueProposals.put(cls.getName() + "." + fieldName, new PropertyConfiguration.ProposalListerInfo(lister, listerFieldName));
    }

    public void setProposalLister(Class fieldClass, Object lister, String listerFieldName) {
        if (this.fieldValueProposals == null) {
            this.fieldValueProposals = new FTreeMap();
        }
        this.fieldValueProposals.put("fieldClass:" + fieldClass.getName(), new PropertyConfiguration.ProposalListerInfo(lister, listerFieldName));
    }

    public PropertyConfiguration.ProposalListerInfo getProposalLister(Class cls, String fieldName) {
        return this.fieldValueProposals != null ? (PropertyConfiguration.ProposalListerInfo)this.fieldValueProposals.get(cls.getName() + "." + fieldName) : null;
    }

    public PropertyConfiguration.ProposalListerInfo getProposalLister(Class fieldClass) {
        return this.fieldValueProposals != null ? (PropertyConfiguration.ProposalListerInfo)this.fieldValueProposals.get("fieldClass:" + fieldClass.getName()) : null;
    }

    public Object getClientProperty(String name) {
        return this.clientProperties != null ? this.clientProperties.get(name) : null;
    }

    public void setClientProperty(String name, Object value) {
        this.clientProperties.put(name, value);
    }

    public int inspectionLevel(Class cls, String fieldName) {
        Integer level;
        if (cls != null && (level = (Integer)this.inspectionLevels.get(cls.getName() + "." + fieldName)) != null) {
            return level;
        }
        return 0;
    }

    public void setInspectionLevel(Class cls, String fieldName, int level) {
        if (cls != null) {
            this.inspectionLevels.put(cls.getName() + "." + fieldName, new Integer(level));
        }
    }

    public void copyPropertyDisplayConfig(PropertyConfiguration config) {
        Integer value;
        String key;
        Map.Entry entry;
        Iterator iter;
        if (this.inspectionLevels != null) {
            iter = this.inspectionLevels.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                key = (String)entry.getKey();
                value = (Integer)entry.getValue();
                int delim = key.lastIndexOf(".");
                if (delim <= 0 || delim >= key.length() - 1) continue;
                String fieldName = key.substring(delim + 1);
                String className = key.substring(0, delim);
                try {
                    Class<?> clazz = Class.forName(className);
                    int level = value == null ? 0 : value;
                    config.setInspectionLevel(clazz, fieldName, level);
                }
                catch (Exception ex) {}
            }
        }
        if (this.clientProperties != null) {
            iter = this.clientProperties.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                key = (String)entry.getKey();
                value = entry.getValue();
                config.setClientProperty(key, value);
            }
        }
    }

    public JPopupMenu getPopupMenu(Object object) {
        return null;
    }

    public JPopupMenu getPopupMenu(Object object, String property) {
        return null;
    }

    public void writeConfig(OutputStream out) throws IOException {
        if (this.inspectionLevels != null) {
            Map.Entry entry;
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
            Iterator it = this.inspectionLevels.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                writer.write(entry.getKey().toString());
                writer.write("\n");
                writer.write(entry.getValue().toString());
                writer.write("\n");
            }
            writer.write("\n");
            it = this.clientProperties.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                if (!(entry.getValue() instanceof String)) continue;
                writer.write(entry.getKey().toString());
                writer.write("\n");
                writer.write(entry.getValue().toString());
                writer.write("\n");
            }
            ((Writer)writer).flush();
        }
    }

    public void readConfig(InputStream in) throws IOException, NumberFormatException {
        String value;
        String key;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        this.inspectionLevels.clear();
        String line = reader.readLine();
        while (line != null && !"".equals(line)) {
            key = line;
            value = reader.readLine();
            if (value != null) {
                this.inspectionLevels.put(key, Integer.valueOf(value));
            }
            line = reader.readLine();
        }
        line = reader.readLine();
        while (line != null && !"".equals(line)) {
            key = line;
            value = reader.readLine();
            if (value != null) {
                this.clientProperties.put(key, value);
            }
            line = reader.readLine();
        }
    }

    public void setCustomEditor(Class cls, String fieldName, CustomEditor editor) {
        this.editors.put(cls.getName() + "." + fieldName, editor);
    }

    public CustomEditor getCustomEditor(Class cls, String fieldName) {
        return (CustomEditor)this.editors.get(cls.getName() + "." + fieldName);
    }

    public void setCustomEditor(Class valueClass, CustomEditor editor) {
        this.editors.put(valueClass.getName(), editor);
    }

    public CustomEditor getCustomEditor(Class valueClass) {
        return (CustomEditor)this.editors.get(valueClass.getName());
    }
}

