/*
 * Decompiled with CFR 0.152.
 */
package de.uni_kassel.prop;

import de.uni_kassel.prop.InspectionAware;
import de.uni_kassel.prop.InspectionException;
import de.uni_kassel.prop.PropertyConfiguration;
import de.uni_kassel.prop.PropertyConfigurationAdapter;
import de.upb.tools.fca.EnumerationForAnIterator;
import de.upb.tools.fca.FHashMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;

public class ObjectInspector {
    private static ObjectInspector instance;
    private Map fieldNames;
    private static final String[] emptyStringArray;
    PropertyConfiguration config;

    protected ObjectInspector() {
    }

    public static ObjectInspector get() {
        if (instance == null) {
            instance = new ObjectInspector();
        }
        return instance;
    }

    private void addToFieldNames(Class objectClass, String[] fieldNames) {
        if (this.fieldNames == null) {
            this.fieldNames = new FHashMap();
        }
        this.fieldNames.put(objectClass, fieldNames);
    }

    private String[] getFromFieldNames(Class objectClass) {
        return this.fieldNames != null ? (String[])this.fieldNames.get(objectClass) : null;
    }

    public String[] findFieldNames(Class objectClass) {
        if (objectClass != null) {
            String[] names = this.getFromFieldNames(objectClass);
            if (names == null) {
                Method[] methods = objectClass.getMethods();
                Vector<String> foundNames = new Vector<String>();
                for (int i = 0; i < methods.length; ++i) {
                    String foundName;
                    Method method = methods[i];
                    if (Modifier.isStatic(method.getModifiers()) || (foundName = this.fieldNameFromAccessor(method)) == null) continue;
                    foundNames.add(foundName);
                }
                names = foundNames.toArray(emptyStringArray);
                this.addToFieldNames(objectClass, names);
            }
            return names;
        }
        return emptyStringArray;
    }

    protected String fieldNameFromAccessor(Method method) {
        String name = method.getName();
        int prefixLength = 0;
        if (name.startsWith("get")) {
            prefixLength = 3;
        } else if (name.startsWith("is")) {
            prefixLength = 2;
        } else if (name.startsWith("iteratorOf")) {
            prefixLength = 10;
        }
        String foundName = null;
        if (prefixLength > 0 && name.length() > prefixLength && method.getParameterTypes().length == 0 && name.substring(prefixLength, prefixLength + 1).equals(name.substring(prefixLength, prefixLength + 1).toUpperCase()) && "class".equals(foundName = name.substring(prefixLength, prefixLength + 1).toLowerCase() + name.substring(prefixLength + 1, name.length()))) {
            foundName = null;
        }
        return foundName;
    }

    public String[] findFieldNames(Object object) {
        if (object != null) {
            String[] names = this.findFieldNames(object.getClass());
            InspectionAware inspectionAware = object instanceof InspectionAware ? (InspectionAware)object : null;
            Vector<String> filteredNames = new Vector<String>();
            for (int i = 0; i < names.length; ++i) {
                int inspectionLevel = this.getConfig().inspectionLevel(object.getClass(), names[i]);
                boolean inspect = true;
                for (Class<?> superClass = object.getClass().getSuperclass(); inspectionLevel == 0 && superClass != null; superClass = superClass.getSuperclass()) {
                    inspectionLevel = this.getConfig().inspectionLevel(superClass, names[i]);
                }
                if (inspectionLevel == 0 && inspectionAware != null) {
                    inspect = inspectionAware.isInspectableField(names[i]);
                }
                if (inspectionLevel == 1) {
                    inspect = true;
                } else if (inspectionLevel == 2) {
                    inspect = false;
                }
                if (!inspect) continue;
                filteredNames.add(names[i]);
            }
            return filteredNames.toArray(emptyStringArray);
        }
        return emptyStringArray;
    }

    public boolean isCollectionField(Object object, String fieldName) {
        return this.getField(object, fieldName) instanceof Iterator;
    }

    public Object getField(Object object, String fieldName) {
        if (object != null) {
            try {
                Class<?> cls = object.getClass();
                Method getter = this.findGetter(fieldName, cls);
                getter.setAccessible(true);
                return getter.invoke(object, null);
            }
            catch (NoSuchMethodException e) {
                throw new InspectionException("Could not find getter for field " + fieldName, e);
            }
            catch (IllegalAccessException e) {
                throw new InspectionException("Could not access getter for field " + fieldName, e);
            }
            catch (InvocationTargetException e) {
                throw new InspectionException("Could not invoke getter for field " + fieldName, e);
            }
        }
        return null;
    }

    private Method findGetter(String fieldName, Class cls) throws NoSuchMethodException {
        Method getter;
        String getterName = this.accessorNameReadField(fieldName);
        try {
            getter = cls.getMethod(getterName, null);
        }
        catch (NoSuchMethodException e1) {
            Method[] methods = cls.getMethods();
            try {
                getter = this.findMethod(getterName, null, methods, false);
            }
            catch (NoSuchMethodException e1a) {
                getterName = this.accessorNameReadBooleanField(fieldName);
                try {
                    getter = cls.getMethod(getterName, null);
                }
                catch (NoSuchMethodException e2) {
                    try {
                        getter = this.findMethod(getterName, null, methods, false);
                    }
                    catch (NoSuchMethodException e2a) {
                        getterName = this.accessorNameIteratorOfCollectionField(fieldName);
                        try {
                            getter = cls.getMethod(getterName, null);
                        }
                        catch (NoSuchMethodException e3) {
                            try {
                                getter = this.findMethod(getterName, null, methods, false);
                            }
                            catch (NoSuchMethodException e3a) {
                                throw new NoSuchMethodException("No getter found for field " + fieldName + " in class " + cls.getName());
                            }
                        }
                    }
                }
            }
        }
        return getter;
    }

    private Method findMethod(String methodName, Class[] parameterTypes, Method[] methods, boolean caseSensitive) throws NoSuchMethodException {
        Method result = null;
        for (int i = 0; i < methods.length && result == null; ++i) {
            result = methods[i];
            if (caseSensitive && !methodName.equals(result.getName()) || !caseSensitive && !methodName.equalsIgnoreCase(result.getName())) {
                result = null;
            }
            if (result == null) continue;
            Class<?>[] tempPTypes = result.getParameterTypes();
            if (tempPTypes.length != parameterTypes.length) {
                result = null;
                continue;
            }
            for (int j = 0; j < tempPTypes.length && result != null; ++j) {
                if (parameterTypes[j].isAssignableFrom(tempPTypes[j])) continue;
                result = null;
            }
        }
        if (result == null) {
            throw new NoSuchMethodException();
        }
        return result;
    }

    public Class findDeclaringClass(String fieldName, Object object) {
        if (object != null) {
            try {
                Method getter = this.findGetter(fieldName, object.getClass());
                return getter.getDeclaringClass();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public Class getFieldClass(Class objectClass, String fieldName) {
        if (objectClass != null) {
            String triedAccessorNames = "";
            try {
                Class cls = objectClass;
                try {
                    Method getter;
                    String getterName = this.accessorNameReadField(fieldName);
                    triedAccessorNames = triedAccessorNames + "'" + getterName + "' ";
                    try {
                        getter = cls.getMethod(getterName, null);
                    }
                    catch (NoSuchMethodException e) {
                        getterName = this.accessorNameReadBooleanField(fieldName);
                        triedAccessorNames = triedAccessorNames + "'" + getterName + "' ";
                        getter = cls.getMethod(getterName, null);
                    }
                    return getter.getReturnType();
                }
                catch (NoSuchMethodException e) {
                    return this.getCollectionFieldClass(cls, fieldName);
                }
            }
            catch (NoSuchMethodException e) {
                throw new InspectionException("Could not find getter for field " + fieldName + " - tried " + triedAccessorNames + " + collection accessors", e);
            }
        }
        return null;
    }

    protected Class getCollectionFieldClass(Class cls, String fieldName) throws NoSuchMethodException {
        String addName = this.accessorNameAddToCollectionField(fieldName);
        Method[] methods = cls.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method.getParameterTypes().length != 1 || !addName.equals(method.getName())) continue;
            return method.getParameterTypes()[0];
        }
        String getterName = this.accessorNameIteratorOfCollectionField(fieldName);
        cls.getMethod(getterName, null);
        return Object.class;
    }

    protected String accessorNameReadField(String fieldName) {
        return "get" + this.firstCharUp(fieldName);
    }

    protected String accessorNameReadBooleanField(String fieldName) {
        return "is" + this.firstCharUp(fieldName);
    }

    protected String accessorNameAddToCollectionField(String fieldName) {
        return "addTo" + this.firstCharUp(fieldName);
    }

    protected String accessorNameIteratorOfCollectionField(String fieldName) {
        return "iteratorOf" + this.firstCharUp(fieldName);
    }

    protected String accessorNameRemoveFromCollectionField(String fieldName) {
        return "removeFrom" + this.firstCharUp(fieldName);
    }

    protected String accessorNameWriteField(String fieldName) {
        return "set" + this.firstCharUp(fieldName);
    }

    public final String firstCharUp(String string) {
        if (string != null) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return "";
    }

    public void setField(Object object, String fieldName, Object newValue) {
        if (object != null) {
            try {
                Method setter;
                String setterName = this.accessorNameWriteField(fieldName);
                Class<?> objectClass = object.getClass();
                Class[] argTypes = new Class[]{this.getFieldClass(objectClass, fieldName)};
                try {
                    setter = objectClass.getMethod(setterName, argTypes);
                }
                catch (NoSuchMethodException nsme) {
                    setter = this.findMethod(setterName, argTypes, objectClass.getMethods(), false);
                }
                Object[] args = new Object[]{newValue};
                setter.setAccessible(true);
                setter.invoke(object, args);
            }
            catch (NoSuchMethodException e) {
                throw new InspectionException("Could not find getter/setter pair for field " + fieldName, e);
            }
            catch (IllegalAccessException e) {
                throw new InspectionException("Could not access getter/setter pair for field " + fieldName, e);
            }
            catch (InvocationTargetException e) {
                throw new InspectionException("Could not invoke getter/setter pair for field " + fieldName, e);
            }
        }
    }

    public boolean hasSetter(Class objectClass, String fieldName) {
        if (objectClass != null) {
            try {
                String setterName = this.accessorNameWriteField(fieldName);
                Class[] argTypes = new Class[]{this.getFieldClass(objectClass, fieldName)};
                objectClass.getMethod(setterName, argTypes);
                return true;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        return false;
    }

    public PropertyConfiguration getConfig() {
        if (this.config == null) {
            this.config = new PropertyConfigurationAdapter();
        }
        return this.config;
    }

    public void setConfig(PropertyConfiguration config) {
        this.config = config;
    }

    public void setProposalLister(Class cls, String fieldName, Object lister, String listerFieldName) {
        this.getConfig().setProposalLister(cls, fieldName, lister, listerFieldName);
    }

    public void setProposalLister(Class fieldClass, Object lister, String listerFieldName) {
        this.getConfig().setProposalLister(fieldClass, lister, listerFieldName);
    }

    public Enumeration proposeFieldValues(Object object, String fieldName) {
        if (object != null) {
            Enumeration customProposals;
            Class fieldClass = this.getFieldClass(object.getClass(), fieldName);
            if (object instanceof InspectionAware && (customProposals = ((InspectionAware)object).proposeFieldValues(fieldName, fieldClass)) != null) {
                return customProposals;
            }
            PropertyConfiguration.ProposalListerInfo info = this.getConfig().getProposalLister(object.getClass(), fieldName);
            if (info == null) {
                info = this.getConfig().getProposalLister(fieldClass);
            }
            if (info != null) {
                Object value = this.getField(info.getObject(), info.getFieldName());
                if (value instanceof Iterator) {
                    return new EnumerationForAnIterator((Iterator)value);
                }
                if (value instanceof Enumeration) {
                    return (Enumeration)value;
                }
                LinkedList<Object> list = new LinkedList<Object>();
                list.add(value);
                return new EnumerationForAnIterator(list.iterator());
            }
        }
        return null;
    }

    public void addToField(Object object, String fieldName, Object value) {
        if (object != null) {
            try {
                String setterName = this.accessorNameAddToCollectionField(fieldName);
                Class<?> objectClass = object.getClass();
                Class[] argTypes = new Class[]{this.getFieldClass(objectClass, fieldName)};
                Method setter = objectClass.getMethod(setterName, argTypes);
                Object[] args = new Object[]{value};
                setter.setAccessible(true);
                setter.invoke(object, args);
            }
            catch (NoSuchMethodException e) {
                throw new InspectionException("Could not find add method for field " + fieldName, e);
            }
            catch (IllegalAccessException e) {
                throw new InspectionException("Could not access add method for field " + fieldName, e);
            }
            catch (InvocationTargetException e) {
                throw new InspectionException("Could not invoke add method for field " + fieldName, e);
            }
        }
    }

    public void removeFromField(Object object, String fieldName, Object value) {
        if (object != null) {
            try {
                String setterName = this.accessorNameRemoveFromCollectionField(fieldName);
                Class<?> objectClass = object.getClass();
                Class[] argTypes = new Class[]{this.getFieldClass(objectClass, fieldName)};
                Method setter = objectClass.getMethod(setterName, argTypes);
                Object[] args = new Object[]{value};
                setter.setAccessible(true);
                setter.invoke(object, args);
            }
            catch (NoSuchMethodException e) {
                throw new InspectionException("Could not find add method for field " + fieldName, e);
            }
            catch (IllegalAccessException e) {
                throw new InspectionException("Could not access add method for field " + fieldName, e);
            }
            catch (InvocationTargetException e) {
                throw new InspectionException("Could not invoke add method for field " + fieldName, e);
            }
        }
    }

    static {
        emptyStringArray = new String[0];
    }
}

