/*
 * Decompiled with CFR 0.152.
 */
package de.uni_kassel.prop;

import de.uni_kassel.prop.InspectionException;
import de.uni_kassel.prop.ObjectInspector;
import de.uni_kassel.prop.PropertyChangeSource;
import de.upb.tools.fca.FHashMap;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.fca.FLinkedList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class JPropertyTable
extends JTable {
    static final long serialVersionUID = 1L;
    private boolean vertical;
    private int extraLines = 0;
    private int popupSourceColumn;
    private int popupSourceRow;
    private JMenuItem hidePropertyMenuItem;
    private JMenuItem renamePropertyMenuItem;
    private JMenuItem deleteObjectMenuItem;
    private PropertyChangeListener columnWidthListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("preferredWidth".equals(evt.getPropertyName())) {
                TableColumn column = (TableColumn)evt.getSource();
                if (!JPropertyTable.this.isVertical()) {
                    String property = JPropertyTable.this.getPropertyNameForCell(0, column.getModelIndex());
                    Class cls = JPropertyTable.this.getClassForCell(0, column.getModelIndex());
                    if (property != null && cls != null) {
                        ObjectInspector.get().getConfig().setClientProperty(cls.getName() + "." + property + ".width", evt.getNewValue());
                    }
                }
            }
        }
    };
    PropertyModel propertyModel;
    String name;
    private String propertyCaption = "Property";
    private String valueCaption = "Value";
    private String newCaption = "New";
    private PropertyChangeSource linkedObject;
    private String linkedProperty;
    private PropertyChangeListener linkedListener = new LinkedPropertyChangeListener();
    private List viewableObjects = new FLinkedList();
    Vector comboBoxVector = new Vector();
    JComboBox comboBox = new JComboBox(this.comboBoxVector);
    MouseListener sortListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            JTableHeader header = (JTableHeader)e.getSource();
            JPropertyTable table = (JPropertyTable)header.getTable();
            if (!table.isVertical()) {
                int column = header.columnAtPoint(e.getPoint());
                String property = table.getPropertyNameForCell(0, column);
                JPropertyTable.this.sortShownObjects(property, JPropertyTable.this.isShownObjectsSorted(property, false));
            }
        }
    };
    MouseListener popupListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Object obj;
                Object obj2;
                JPropertyTable.this.popupSourceColumn = JPropertyTable.this.columnAtPoint(e.getPoint());
                JPropertyTable.this.popupSourceRow = JPropertyTable.this.rowAtPoint(e.getPoint());
                Class cls = JPropertyTable.this.getClassForCell(JPropertyTable.this.popupSourceRow, JPropertyTable.this.popupSourceColumn);
                if (cls != null) {
                    JPropertyTable.this.hidePropertyMenuItem.setText("hide property " + cls.getName() + "." + JPropertyTable.this.getPropertyNameForCell(JPropertyTable.this.popupSourceRow, JPropertyTable.this.popupSourceColumn));
                    JPropertyTable.this.hidePropertyMenuItem.setEnabled(true);
                } else {
                    JPropertyTable.this.hidePropertyMenuItem.setEnabled(false);
                }
                if (!JPropertyTable.this.propertyModel.shownObjects.isEmpty() && (obj2 = JPropertyTable.this.propertyModel.shownObjects.get(0)) != null) {
                    String property = JPropertyTable.this.getPropertyNameForCell(JPropertyTable.this.popupSourceRow, JPropertyTable.this.popupSourceColumn);
                    cls = ObjectInspector.get().findDeclaringClass(property, obj2);
                    if (cls != null) {
                        JPropertyTable.this.renamePropertyMenuItem.setText("rename property " + cls.getName() + "." + property);
                        JPropertyTable.this.renamePropertyMenuItem.setEnabled(true);
                    } else {
                        JPropertyTable.this.renamePropertyMenuItem.setEnabled(false);
                    }
                }
                if ((obj = JPropertyTable.this.getObjectForCell(JPropertyTable.this.popupSourceRow, JPropertyTable.this.popupSourceColumn)) != null) {
                    JPropertyTable.this.deleteObjectMenuItem.setEnabled(true);
                } else {
                    JPropertyTable.this.deleteObjectMenuItem.setEnabled(false);
                }
                JPropertyTable.this.hideEmptyMenu(JPropertyTable.this.popupMenu);
                if (JPropertyTable.this.popupMenu.isEnabled()) {
                    JPropertyTable.this.popupMenu.setInvoker(JPropertyTable.this);
                    JPropertyTable.this.popupMenu.show(JPropertyTable.this, e.getX(), e.getY());
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.mousePressed(e);
        }
    };
    JPopupMenu popupMenu = new JPopupMenu();
    JMenu configMenu = new JMenu("config");
    private Class classForNewObjects;
    private Map defaultValues;
    static /* synthetic */ Class class$java$lang$Comparable;

    public int getPopupSourceRow() {
        return this.popupSourceRow;
    }

    public int getPopupSourceColumn() {
        return this.popupSourceColumn;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public boolean isPopupMenuVisible() {
        return this.popupMenu.isVisible();
    }

    static void printInspectionException(InspectionException e) {
        if (e.getCause() != null) {
            if (e.getCause() instanceof InvocationTargetException && e.getCause().getCause() != null) {
                e.getCause().getCause().printStackTrace();
            } else {
                e.getCause().printStackTrace();
            }
        } else {
            e.printStackTrace();
        }
    }

    public static Class mapPrimitives(Class cls) {
        if (cls == Boolean.TYPE) {
            cls = Boolean.class;
        } else if (cls == Double.TYPE) {
            cls = Double.class;
        } else if (cls == Long.TYPE) {
            cls = Long.class;
        } else if (cls == Integer.TYPE) {
            cls = Integer.class;
        } else if (cls == Float.TYPE) {
            cls = Float.class;
        } else if (cls == Character.TYPE) {
            cls = Character.class;
        } else if (cls == Double.TYPE) {
            cls = Double.class;
        } else if (cls == Byte.TYPE) {
            cls = Byte.class;
        } else if (cls == Short.TYPE) {
            cls = Short.class;
        } else if (cls == Void.TYPE) {
            cls = Void.class;
        }
        return cls;
    }

    public String getName() {
        return this.name;
    }

    public JPropertyTable(boolean vertical, String name) {
        this.name = name;
        this.vertical = vertical;
        this.getTableHeader().setReorderingAllowed(!vertical);
        this.propertyModel = new PropertyModel();
        this.setModel(this.propertyModel);
        this.setRowSelectionAllowed(true);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JPropertyTable.this.checkSelection();
            }
        });
        this.hidePropertyMenuItem = new JMenuItem();
        this.hidePropertyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int col = JPropertyTable.this.popupSourceColumn;
                int row = JPropertyTable.this.popupSourceRow;
                String property = JPropertyTable.this.getPropertyNameForCell(JPropertyTable.this.popupSourceRow, JPropertyTable.this.popupSourceColumn);
                Class cls = JPropertyTable.this.getClassForCell(row, col);
                if (cls != null) {
                    ObjectInspector.get().getConfig().setInspectionLevel(cls, property, 2);
                    JPropertyTable.this.propertyModel.update();
                }
            }
        });
        this.renamePropertyMenuItem = new JMenuItem();
        this.renamePropertyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int col = JPropertyTable.this.popupSourceColumn;
                int row = JPropertyTable.this.popupSourceRow;
                String property = JPropertyTable.this.getPropertyNameForCell(JPropertyTable.this.popupSourceRow, JPropertyTable.this.popupSourceColumn);
                Class cls = JPropertyTable.this.getClassForCell(row, col);
                if (cls != null) {
                    String formerCaption = JPropertyTable.this.getCaptionForCell(JPropertyTable.this.popupSourceRow, JPropertyTable.this.popupSourceColumn);
                    String caption = JOptionPane.showInputDialog(JPropertyTable.this, "Enter new caption for property " + cls.getName() + "." + property, formerCaption);
                    ObjectInspector.get().getConfig().setClientProperty("propertyCaption:" + cls.getName() + "." + property, caption);
                    JPropertyTable.this.propertyModel.update();
                    JPropertyTable.this.propertyModel.notifyListeners(new TableModelEvent(JPropertyTable.this.propertyModel, -1));
                }
            }
        });
        this.deleteObjectMenuItem = new JMenuItem("delete object");
        this.deleteObjectMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int col = JPropertyTable.this.popupSourceColumn;
                int row = JPropertyTable.this.popupSourceRow;
                Object obj = JPropertyTable.this.getObjectForCell(row, col);
                HashSet<Object> deleteObjects = new HashSet<Object>();
                if (obj != null) {
                    deleteObjects.add(obj);
                }
                int[] selRows = JPropertyTable.this.getSelectedRows();
                int[] selCols = JPropertyTable.this.getSelectedColumns();
                for (int i = 0; i < selRows.length; ++i) {
                    for (int j = 0; j < selCols.length; ++j) {
                        obj = JPropertyTable.this.getObjectForCell(selRows[i], selCols[j]);
                        if (obj == null) continue;
                        deleteObjects.add(obj);
                    }
                }
                Iterator delIter = deleteObjects.iterator();
                while (delIter.hasNext()) {
                    obj = delIter.next();
                    JPropertyTable.this.removeFromShownObjects(obj);
                    try {
                        obj.getClass().getMethod("removeYou", null).invoke(obj, null);
                    }
                    catch (NoSuchMethodException e1) {
                        System.err.println("object was only removed from property editor as no removeYou() method was found!");
                    }
                    catch (IllegalAccessException e1) {
                        e1.printStackTrace();
                    }
                    catch (InvocationTargetException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.popupMenu.add(new JPopupMenuMenu("object"){
            JPopupMenu popupMenu;
            Object lastObject;

            protected JPopupMenu getSubPopup() {
                Object obj = JPropertyTable.this.getObjectForCell(JPropertyTable.this.popupSourceRow, JPropertyTable.this.popupSourceColumn);
                if (obj != this.lastObject) {
                    this.popupMenu = ObjectInspector.get().getConfig().getPopupMenu(obj);
                    this.lastObject = obj;
                }
                return this.popupMenu;
            }
        });
        this.popupMenu.add(new JPopupMenuMenu("property"){
            JPopupMenu popupMenu;
            Object lastObject;

            protected JPopupMenu getSubPopup() {
                Object obj = JPropertyTable.this.getObjectForCell(JPropertyTable.this.popupSourceRow, JPropertyTable.this.popupSourceColumn);
                String property = JPropertyTable.this.getPropertyNameForCell(JPropertyTable.this.popupSourceRow, JPropertyTable.this.popupSourceColumn);
                if (obj != this.lastObject) {
                    this.popupMenu = ObjectInspector.get().getConfig().getPopupMenu(obj, property);
                    this.lastObject = obj;
                }
                return this.popupMenu;
            }
        });
        this.popupMenu.add(new JPopupMenuMenu("value"){
            JPopupMenu popupMenu;
            Object lastObject;

            protected JPopupMenu getSubPopup() {
                Object obj = JPropertyTable.this.getObjectForCell(JPropertyTable.this.popupSourceRow, JPropertyTable.this.popupSourceColumn);
                String property = JPropertyTable.this.getPropertyNameForCell(JPropertyTable.this.popupSourceRow, JPropertyTable.this.popupSourceColumn);
                if (obj != this.lastObject) {
                    this.popupMenu = ObjectInspector.get().getConfig().getPopupMenu(ObjectInspector.get().getField(obj, property));
                    this.lastObject = obj;
                }
                return this.popupMenu;
            }
        });
        this.configMenu.add(this.hidePropertyMenuItem);
        this.configMenu.add(this.renamePropertyMenuItem);
        this.popupMenu.add(this.deleteObjectMenuItem);
        this.popupMenu.add(this.configMenu);
        this.addMouseListener(this.popupListener);
        this.getTableHeader().addMouseListener(this.sortListener);
    }

    public void addToPopupMenu(JMenu element) {
        this.popupMenu.add(element);
    }

    public void addToPopupMenu(JMenuItem element) {
        this.popupMenu.add(element);
    }

    public Class getClassForCell(int row, int col) {
        try {
            Object obj = this.getObjectForCell(row, col);
            Class cls = null;
            if (obj == null && !this.propertyModel.shownObjects.isEmpty()) {
                obj = this.propertyModel.shownObjects.get(0);
                if (obj != null) {
                    cls = ObjectInspector.get().findDeclaringClass(this.getPropertyNameForCell(row, col), obj);
                }
            } else if (obj != null) {
                cls = obj.getClass();
            }
            return cls;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public String getPropertyCaption() {
        return this.propertyCaption;
    }

    public void setPropertyCaption(String propertyCaption) {
        this.propertyCaption = propertyCaption;
    }

    public String getValueCaption() {
        return this.valueCaption;
    }

    public void setValueCaption(String valueCaption) {
        this.valueCaption = valueCaption;
    }

    public String getNewCaption() {
        return this.newCaption;
    }

    public void setNewCaption(String newCaption) {
        this.newCaption = newCaption;
    }

    private void checkSelection() {
        if (this.getClassForNewObjects() != null) {
            if (this.isVertical()) {
                if (this.getSelectedColumn() > this.viewableObjects.size()) {
                    this.createObject();
                }
            } else if (this.getSelectedRow() >= this.viewableObjects.size()) {
                this.createObject();
            }
        }
    }

    public void linkShownObjectsToProperty(PropertyChangeSource owner, String propertyName) {
        if (this.linkedObject != null) {
            this.linkedObject.removePropertyChangeListener(this.linkedListener);
        }
        this.linkedObject = owner;
        this.linkedProperty = propertyName;
        if (owner != null) {
            owner.addPropertyChangeListener(this.linkedListener);
        }
        this.linkedListener.propertyChange(null);
    }

    public void removeFromShownObjects(Object viewedObject) {
        if (viewedObject != null && this.viewableObjects.contains(viewedObject)) {
            this.viewableObjects.remove(viewedObject);
            this.propertyModel.update();
        }
    }

    public void addToShownObjects(Object viewedObject) {
        if (viewedObject != null && !this.viewableObjects.contains(viewedObject)) {
            this.viewableObjects.add(viewedObject);
            this.propertyModel.update();
        }
    }

    public void addToShownObjects(Iterator viewedObjectsIterator) {
        if (viewedObjectsIterator != null) {
            while (viewedObjectsIterator.hasNext()) {
                Object o = viewedObjectsIterator.next();
                this.viewableObjects.add(o);
            }
            this.propertyModel.update();
        }
    }

    public void removeAllFromShownObjects() {
        if (this.viewableObjects != null) {
            this.viewableObjects.clear();
            this.propertyModel.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortShownObjects(String property, boolean reverse) {
        if (this.viewableObjects != null) {
            List list = this.viewableObjects;
            synchronized (list) {
                Object[] tmpObjects = this.viewableObjects.toArray();
                Arrays.sort(tmpObjects, new PropertyComparator(property, reverse));
                for (int i = 0; i < tmpObjects.length; ++i) {
                    this.viewableObjects.set(i, tmpObjects[i]);
                }
            }
            this.propertyModel.update();
        }
    }

    protected boolean isShownObjectsSorted(String property, boolean reverse) {
        boolean result = false;
        if (this.viewableObjects != null) {
            result = true;
            PropertyComparator cmp = new PropertyComparator(property, reverse);
            Iterator objIter = this.viewableObjects.iterator();
            if (objIter.hasNext()) {
                Object o1 = objIter.next();
                while (objIter.hasNext() && result) {
                    Object o2 = objIter.next();
                    result = cmp.compare(o1, o2) <= 0;
                    o1 = o2;
                }
            }
        }
        return result;
    }

    public int indexOfShownObject(Object viewedObject) {
        int index;
        int n = index = this.propertyModel != null && this.propertyModel.shownObjects != null ? this.propertyModel.shownObjects.indexOf(viewedObject) : 0;
        if (this.isVertical()) {
            return this.convertColumnIndexToView(index + 1);
        }
        return index;
    }

    public TableCellEditor getDefaultEditor(Class columnClass) {
        TableCellEditor editor = super.getDefaultEditor(columnClass = JPropertyTable.mapPrimitives(columnClass));
        if (editor == null) {
            editor = super.getDefaultEditor(String.class);
        }
        return editor;
    }

    public TableCellRenderer getDefaultRenderer(Class columnClass) {
        TableCellRenderer renderer = super.getDefaultRenderer(columnClass = JPropertyTable.mapPrimitives(columnClass));
        if (renderer == null) {
            renderer = super.getDefaultRenderer(String.class);
        }
        return renderer;
    }

    public Object getObjectForCell(int row, int column) {
        try {
            Object object = this.isVertical() ? this.propertyModel.getObject(row, column) : (row < this.viewableObjects.size() ? this.viewableObjects.get(row) : null);
            return object;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public String getCaptionForCell(int row, int column) {
        try {
            return this.propertyModel.getCaption(row, this.convertColumnIndexToModel(column));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public String getPropertyNameForCell(int row, int column) {
        try {
            return this.propertyModel.getPropertyName(row, this.convertColumnIndexToModel(column));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public TableCellEditor getCellEditor(int row, int column) {
        Object object = this.getObjectForCell(row, column);
        String propertyName = this.getPropertyNameForCell(row, column);
        Enumeration enumeration = ObjectInspector.get().proposeFieldValues(object, propertyName);
        if (object == null) {
            this.createObject();
            return this.getDefaultEditor((Class)this.getColumnClass(column));
        }
        if (enumeration == null) {
            TableCellEditor editor = this.getDefaultEditor(ObjectInspector.get().getFieldClass(object.getClass(), propertyName));
            return editor;
        }
        Class fieldClass = ObjectInspector.get().getFieldClass(object.getClass(), propertyName);
        this.comboBoxVector.clear();
        this.comboBoxVector.add(null);
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (!fieldClass.isInstance(o)) continue;
            this.comboBoxVector.add(o);
        }
        this.comboBox.updateUI();
        return new DefaultCellEditor(this.comboBox);
    }

    private void createObject() {
        Class cls = this.getClassForNewObjects();
        if (cls != null) {
            try {
                Object object = cls.newInstance();
                this.addToShownObjects(object);
                try {
                    if (this.defaultValues != null) {
                        Iterator it = this.defaultValues.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            if (!(entry.getKey() instanceof String)) continue;
                            ObjectInspector.get().setField(object, (String)entry.getKey(), entry.getValue());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Failed to create object! See debug output for details.");
            }
        } else {
            JOptionPane.showMessageDialog(this, "No class specified to create new objects!");
        }
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        String propertyName;
        Object object;
        if (this.isVertical()) {
            object = this.propertyModel.getObject(row, column);
            propertyName = this.propertyModel.getPropertyName(row, column);
        } else {
            if (row >= this.viewableObjects.size()) {
                return this.getDefaultRenderer((Class)this.getColumnClass(column));
            }
            object = this.viewableObjects.get(row);
            propertyName = this.getColumnName(column);
        }
        TableCellRenderer renderer = this.isVertical() && object != null ? this.getDefaultRenderer(ObjectInspector.get().getFieldClass(object.getClass(), propertyName)) : super.getCellRenderer(row, column);
        Component comp = this.prepareRenderer(renderer, row, column);
        if (comp instanceof JComponent) {
            JComponent jComponent = (JComponent)comp;
            Class cls = ObjectInspector.get().findDeclaringClass(propertyName, object);
            if (cls != null) {
                jComponent.setToolTipText("value of " + cls.getName() + "." + propertyName);
            } else {
                jComponent.setToolTipText(null);
            }
        }
        return renderer;
    }

    private void hideEmptyMenu(MenuElement menu) {
        boolean subMenusVisible = false;
        MenuElement[] subMenus = menu.getSubElements();
        for (int i = 0; i < subMenus.length; ++i) {
            MenuElement subMenu = subMenus[i];
            if (subMenu instanceof JMenu || subMenu.getSubElements().length > 0) {
                this.hideEmptyMenu(subMenu);
            }
            if (!(subMenu instanceof Component) || !((Component)((Object)subMenu)).isEnabled()) continue;
            subMenusVisible = true;
        }
        if (menu instanceof Component) {
            Component component = (Component)((Object)menu);
            component.setEnabled(subMenusVisible);
            if (menu instanceof JMenu) {
                component.setVisible(component.isEnabled());
            }
        }
    }

    public Class getClassForNewObjects() {
        return this.classForNewObjects;
    }

    public void setClassForNewObjects(Class classForNewObjects) {
        if (this.classForNewObjects != classForNewObjects) {
            this.classForNewObjects = classForNewObjects;
            this.propertyModel.update();
        }
    }

    public void setClassForNewObjects(Class classForNewObjects, Map defaultValues) {
        this.setClassForNewObjects(classForNewObjects);
        this.defaultValues = defaultValues;
    }

    public static JPropertyTable createPropertyTableWindow(boolean vertical) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().setLayout(new BorderLayout());
        JPropertyTable table = new JPropertyTable(vertical, "myPropertyTable");
        JSplitPane split = JPropertyTable.createScrollablePropertyTableWithToNEditor(table);
        frame.getContentPane().add((Component)split, "Center");
        frame.pack();
        frame.show();
        return table;
    }

    public static JSplitPane createScrollablePropertyTableWithToNEditor(JPropertyTable table) {
        JScrollPane scrollPane = JPropertyTable.createScrollablePropertyTable(table);
        JSplitPane split = new JSplitPane();
        split.setLeftComponent(scrollPane);
        JComponent toNEditor = JPropertyTable.createToNEditor(table);
        split.setRightComponent(toNEditor);
        split.setResizeWeight(0.95);
        return split;
    }

    public static JComponent createToNEditor(JPropertyTable table) {
        JList toNEditor = new JList();
        ValueListModel listmodel = table.new ValueListModel();
        toNEditor.setModel(listmodel);
        toNEditor.setSelectionModel(listmodel);
        return new JScrollPane(toNEditor);
    }

    public static JScrollPane createScrollablePropertyTable(JPropertyTable table) {
        table.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane(table);
        return scrollPane;
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        try {
            return super.prepareRenderer(renderer, row, column);
        }
        catch (Exception e1) {
            try {
                return super.prepareRenderer(this.getDefaultRenderer(String.class), row, column);
            }
            catch (Exception e2) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    public static void main(String[] args) {
        DemoClass demoObject1 = new DemoClass("object 1");
        DemoClass demoObject2 = new DemoClass("object 2");
        DemoClass demoObject3 = new DemoClass("object 3");
        demoObject2.addToNeighbors(demoObject3);
        demoObject3.addToNeighbors(demoObject1);
        demoObject3.addToNeighbors(demoObject2);
        JPropertyTable table = JPropertyTable.createPropertyTableWindow(false);
        ObjectInspector.get().setProposalLister(DemoClass.class, demoObject1, "all");
        table.setClassForNewObjects(DemoClass.class);
        table.addToShownObjects(DemoClass.iteratorOfAll());
    }

    public void columnMoved(TableColumnModelEvent e) {
        String property;
        super.columnMoved(e);
        if (e.getFromIndex() != e.getToIndex() && !this.isVertical() && this.getName() != null && (property = this.getPropertyNameForCell(0, e.getToIndex())) != null) {
            ObjectInspector.get().getConfig().setClientProperty("column " + this.getName() + "." + property, new Integer(e.getToIndex()));
        }
    }

    private static class DemoClass {
        private static Set all = new HashSet();
        private String name;
        private Set neighbors = new HashSet();
        private DemoClass parent;

        public String getName() {
            throw new NullPointerException();
        }

        public DemoClass() {
        }

        public DemoClass(String name) {
            this.name = name;
            all.add(this);
        }

        public static Iterator iteratorOfAll() {
            return all.iterator();
        }

        public void addToNeighbors(DemoClass value) {
            this.neighbors.add(value);
        }

        public void removeFromNeighbors(DemoClass value) {
            this.neighbors.remove(value);
        }

        public Iterator iteratorOfNeighbors() {
            return this.neighbors.iterator();
        }

        public DemoClass getParent() {
            return this.parent;
        }

        public void setParent(DemoClass parent) {
            this.parent = parent;
        }

        public String toString() {
            return this.name;
        }
    }

    private class ValueListModel
    extends DefaultListSelectionModel
    implements ListModel,
    ListSelectionListener {
        private Set listeners = new HashSet();
        private Object object;
        private String propertyName;
        private FHashSet values = new FHashSet();
        private Vector proposedValues = new Vector();

        public ValueListModel() {
            JPropertyTable.this.getSelectionModel().addListSelectionListener(this);
            JPropertyTable.this.getColumnModel().getSelectionModel().addListSelectionListener(this);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.notifyListeners();
        }

        private void notifyListeners() {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ListDataListener listDataListener = (ListDataListener)iterator.next();
                listDataListener.contentsChanged(new ListDataEvent(this, 0, 0, Integer.MAX_VALUE));
            }
        }

        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        public synchronized Object getElementAt(int index) {
            return this.proposedValues.get(index);
        }

        public synchronized int getSize() {
            int column = JPropertyTable.this.getSelectedColumn();
            int row = JPropertyTable.this.getSelectedRow();
            if (row >= 0 && column >= 0) {
                String propertyName = JPropertyTable.this.getPropertyNameForCell(row, column);
                Object object = JPropertyTable.this.getObjectForCell(row, column);
                if (object != this.object || propertyName != this.propertyName) {
                    this.object = object;
                    this.propertyName = propertyName;
                    if (object == null) {
                        return 0;
                    }
                    ObjectInspector inspector = ObjectInspector.get();
                    try {
                        Object value = inspector.getField(object, propertyName);
                        this.proposedValues.clear();
                        if (value instanceof Iterator) {
                            Enumeration enumeration = inspector.proposeFieldValues(object, propertyName);
                            while (enumeration != null && enumeration.hasMoreElements()) {
                                Object o = enumeration.nextElement();
                                Class fieldClass = inspector.getFieldClass(object.getClass(), propertyName);
                                if (!fieldClass.isAssignableFrom(o.getClass())) continue;
                                this.proposedValues.add(o);
                            }
                            this.values.clear();
                            Iterator it = (Iterator)value;
                            while (it.hasNext()) {
                                Object o = it.next();
                                this.values.add(o);
                            }
                            return this.proposedValues.size();
                        }
                        return 0;
                    }
                    catch (InspectionException e) {
                        return 0;
                    }
                }
                return this.proposedValues != null ? this.proposedValues.size() : 0;
            }
            return 0;
        }

        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        public boolean isSelectedIndex(int index) {
            return this.values.contains(this.proposedValues.get(index));
        }

        public void addSelectionInterval(int index0, int index1) {
            for (int i = index0; i <= index1; ++i) {
                Object o = this.proposedValues.get(i);
                this.values.add(o);
                ObjectInspector.get().addToField(this.object, this.propertyName, o);
            }
            super.removeSelectionInterval(index0, index1);
        }

        public void removeSelectionInterval(int index0, int index1) {
            for (int i = index0; i <= index1; ++i) {
                Object o = this.proposedValues.get(i);
                this.values.remove(o);
                ObjectInspector.get().removeFromField(this.object, this.propertyName, o);
            }
            super.removeSelectionInterval(index0, index1);
        }

        public void setSelectionInterval(int index0, int index1) {
            this.removeSelectionInterval(0, this.getSize() - 1);
            this.addSelectionInterval(index0, index1);
        }
    }

    private static final class PropertyComparator
    implements Comparator {
        private final String fieldName;
        private final boolean reverse;

        public PropertyComparator(String fieldName, boolean reverse) {
            this.fieldName = fieldName;
            this.reverse = reverse;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public int compare(Object o1, Object o2) {
            Object val2;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return this.reverse ? 1 : -1;
            }
            if (o2 == null) {
                return this.reverse ? -1 : 1;
            }
            Object val1 = ObjectInspector.get().getField(o1, this.fieldName);
            int result = this.compareImpl(val1, val2 = ObjectInspector.get().getField(o2, this.fieldName));
            if (result == 0) {
                result = this.compareImpl(o1, o2);
            }
            return (this.reverse ? -1 : 1) * result;
        }

        private int compareImpl(Object val1, Object val2) {
            if (val1 == val2) {
                return 0;
            }
            if (val1 == null) {
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            if ((class$java$lang$Comparable == null ? (class$java$lang$Comparable = JPropertyTable.class$("java.lang.Comparable")) : class$java$lang$Comparable).isAssignableFrom(val1.getClass())) {
                try {
                    return ((Comparable)val1).compareTo(val2);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return val1.toString().compareTo(val2.toString());
        }
    }

    private class LinkedPropertyChangeListener
    implements PropertyChangeListener {
        private LinkedPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt == null || evt.getPropertyName() == null || evt.getPropertyName().equals(JPropertyTable.this.linkedProperty)) {
                Object value = ObjectInspector.get().getField(JPropertyTable.this.linkedObject, JPropertyTable.this.linkedProperty);
                JPropertyTable.this.removeAllFromShownObjects();
                if (value instanceof Iterator) {
                    JPropertyTable.this.addToShownObjects((Iterator)value);
                } else {
                    JPropertyTable.this.addToShownObjects(value);
                }
            }
        }
    }

    abstract class JPopupMenuMenu
    extends JMenu {
        public JPopupMenuMenu(String s) {
            super(s);
        }

        public JPopupMenu getPopupMenu() {
            JPopupMenu popupMenu = this.getSubPopup();
            if (popupMenu != null) {
                popupMenu.setVisible(false);
                popupMenu.setInvoker(this);
            }
            return popupMenu;
        }

        protected abstract JPopupMenu getSubPopup();

        public void setEnabled(boolean b) {
        }

        public boolean isEnabled() {
            return this.getPopupMenu() != null;
        }

        public void setSelected(boolean b) {
            super.setSelected(b);
            if (this.getPopupMenu() != null) {
                this.getPopupMenu().setVisible(false);
            }
        }
    }

    private class PropertyModel
    implements TableModel,
    Serializable {
        static final long serialVersionUID = 1L;
        private List shownObjects = new FLinkedList();
        Set listeners;
        String[] propertyNames = new String[0];
        private Map propertyChangeListeners;

        private PropertyModel() {
        }

        public void addTableModelListener(TableModelListener l) {
            if (this.listeners == null) {
                this.listeners = new FHashSet();
            }
            this.listeners.add(l);
        }

        public Class getColumnClass(int columnIndex) {
            try {
                if (!JPropertyTable.this.isVertical()) {
                    Class cls = ObjectInspector.get().getFieldClass(this.shownObjects.get(0).getClass(), this.getPropertyName(0, columnIndex));
                    cls = JPropertyTable.mapPrimitives(cls);
                    return cls;
                }
                Object object = this.getObject(JPropertyTable.this.getSelectedRow(), columnIndex);
                if (object != null) {
                    Class cls = ObjectInspector.get().getFieldClass(object.getClass(), this.getPropertyName(JPropertyTable.this.getSelectedRow(), columnIndex));
                    return JPropertyTable.mapPrimitives(cls);
                }
                return null;
            }
            catch (InspectionException e) {
                JPropertyTable.printInspectionException(e);
                return null;
            }
        }

        public int getColumnCount() {
            if (JPropertyTable.this.isVertical()) {
                return this.shownObjects.size() + 1 + JPropertyTable.this.extraLines;
            }
            return this.propertyNames.length;
        }

        public String getColumnName(int columnIndex) {
            if (JPropertyTable.this.isVertical()) {
                return columnIndex == 0 ? JPropertyTable.this.getPropertyCaption() : (columnIndex <= this.shownObjects.size() ? JPropertyTable.this.getValueCaption() : JPropertyTable.this.getNewCaption());
            }
            return this.getCaption(0, columnIndex);
        }

        private String getCaption(int row, int column) {
            String property = this.getPropertyName(row, column);
            Object obj = JPropertyTable.this.propertyModel.shownObjects.get(0);
            if (obj != null) {
                Class cls = ObjectInspector.get().findDeclaringClass(property, obj);
                Object caption = ObjectInspector.get().getConfig().getClientProperty("propertyCaption:" + cls.getName() + "." + property);
                if (caption instanceof String) {
                    return (String)caption;
                }
                if (caption != null) {
                    System.err.println("ERROR: found non-String in property caption: " + caption);
                }
            }
            return property;
        }

        public int getRowCount() {
            if (JPropertyTable.this.isVertical()) {
                return this.propertyNames.length;
            }
            return this.shownObjects.size() + JPropertyTable.this.extraLines;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                Object value;
                if (!JPropertyTable.this.isVertical() || columnIndex != 0) {
                    Object object = this.getObject(rowIndex, columnIndex);
                    if (object == null) {
                        if (JPropertyTable.this.defaultValues == null) return null;
                        return JPropertyTable.this.defaultValues.get(this.getPropertyName(rowIndex, columnIndex));
                    }
                    value = ObjectInspector.get().getField(object, this.getPropertyName(rowIndex, columnIndex));
                } else {
                    value = this.getCaption(rowIndex, columnIndex);
                }
                if (!(value instanceof Iterator)) return value;
                Iterator it = (Iterator)value;
                String text = null;
                while (it.hasNext()) {
                    Object o = it.next();
                    text = text == null ? "{ " : text + ", ";
                    text = text + o;
                }
                if (text == null) return "{}";
                return text + " }";
            }
            catch (InspectionException e) {
                JPropertyTable.printInspectionException(e);
                return "(error reading field)";
            }
        }

        private String getPropertyName(int rowIndex, int columnIndex) {
            return JPropertyTable.this.isVertical() ? this.propertyNames[rowIndex] : this.propertyNames[columnIndex];
        }

        private Object getObject(int rowIndex, int columnIndex) {
            if (JPropertyTable.this.isVertical()) {
                return columnIndex > 0 && columnIndex <= this.shownObjects.size() ? this.shownObjects.get(columnIndex - 1) : null;
            }
            return rowIndex < this.shownObjects.size() ? this.shownObjects.get(rowIndex) : null;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            try {
                Object object = this.getObject(rowIndex, columnIndex);
                if (object != null) {
                    return ObjectInspector.get().hasSetter(object.getClass(), this.getPropertyName(rowIndex, columnIndex));
                }
                return !JPropertyTable.this.isVertical() || columnIndex > 0;
            }
            catch (InspectionException e) {
                return false;
            }
        }

        public void removeTableModelListener(TableModelListener l) {
            if (this.listeners != null) {
                this.listeners.remove(l);
            }
        }

        private void notifyListeners(TableModelEvent e) {
            if (this.listeners != null) {
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    TableModelListener tableModelListener = (TableModelListener)iterator.next();
                    tableModelListener.tableChanged(e);
                }
            }
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Object object = this.getObject(rowIndex, columnIndex);
            String propertyName = this.getPropertyName(rowIndex, columnIndex);
            if (object != null && propertyName != null) {
                Class fieldClass;
                Class clazz = fieldClass = aValue != null ? ObjectInspector.get().getFieldClass(object.getClass(), propertyName) : null;
                if (aValue == null || JPropertyTable.mapPrimitives(fieldClass).isInstance(aValue)) {
                    try {
                        ObjectInspector.get().setField(object, propertyName, aValue);
                    }
                    catch (InspectionException e) {
                        JPropertyTable.printInspectionException(e);
                        JOptionPane.showMessageDialog(JPropertyTable.this, "Error while setting value: see debug output for details hit ESC to discard the value.");
                    }
                } else {
                    System.err.println("found " + aValue.getClass() + " but needed descendant of " + fieldClass);
                    JOptionPane.showMessageDialog(JPropertyTable.this, "Failed to convert data!");
                }
            }
            this.notifyListeners(new TableModelEvent(this, rowIndex, rowIndex, columnIndex));
        }

        private void update() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (PropertyModel.this.propertyChangeListeners == null) {
                        PropertyModel.this.propertyChangeListeners = (Map)new FHashMap();
                    } else {
                        Iterator iterator = PropertyModel.this.propertyChangeListeners.values().iterator();
                        while (iterator.hasNext()) {
                            TablePCListener pcl = (TablePCListener)iterator.next();
                            pcl.stillNeeded = false;
                        }
                    }
                    Class<?> superClass = null;
                    TreeSet names = null;
                    int objectIndex = 0;
                    Iterator<Object> iterator = JPropertyTable.this.viewableObjects.iterator();
                    while (iterator.hasNext()) {
                        Object o = iterator.next();
                        if (o instanceof PropertyChangeSource) {
                            TablePCListener pcl = (TablePCListener)PropertyModel.this.propertyChangeListeners.get(o);
                            if (pcl == null) {
                                pcl = new TablePCListener((PropertyChangeSource)o, objectIndex);
                                PropertyModel.this.propertyChangeListeners.put(o, pcl);
                            } else {
                                pcl.stillNeeded = true;
                                pcl.index = objectIndex;
                            }
                        }
                        if (superClass == null || !superClass.isInstance(o)) {
                            TreeSet<String> tmpNames = new TreeSet<String>();
                            String[] tmp = ObjectInspector.get().findFieldNames(o);
                            for (int i = 0; i < tmp.length; ++i) {
                                tmpNames.add(tmp[i]);
                            }
                            if (names != null) {
                                TreeSet whatIsOnlyInNames = new TreeSet(names);
                                whatIsOnlyInNames.removeAll(tmpNames);
                                names.removeAll(whatIsOnlyInNames);
                            } else {
                                names = tmpNames;
                            }
                            if (superClass != null) {
                                if (o.getClass().isAssignableFrom(superClass)) {
                                    superClass = o.getClass();
                                }
                            } else {
                                superClass = o.getClass();
                            }
                        }
                        ++objectIndex;
                    }
                    if (names == null) {
                        names = new TreeSet();
                    }
                    iterator = PropertyModel.this.propertyChangeListeners.values().iterator();
                    while (iterator.hasNext()) {
                        TablePCListener pcl = (TablePCListener)iterator.next();
                        if (pcl.stillNeeded) continue;
                        PropertyModel.this.propertyChangeListeners.remove(pcl.object);
                        pcl.removeYou();
                    }
                    PropertyModel.this.shownObjects.clear();
                    PropertyModel.this.shownObjects.addAll(JPropertyTable.this.viewableObjects);
                    JPropertyTable.this.extraLines = JPropertyTable.this.getClassForNewObjects() != null ? 1 : 0;
                    boolean newNames = false;
                    if (names != null) {
                        TreeSet<String> oldNames = new TreeSet<String>();
                        for (int i = 0; i < PropertyModel.this.propertyNames.length; ++i) {
                            String propertyName = PropertyModel.this.propertyNames[i];
                            oldNames.add(propertyName);
                        }
                        Iterator iterator2 = names.iterator();
                        while (iterator2.hasNext()) {
                            String name = (String)iterator2.next();
                            if (oldNames.contains(name)) {
                                oldNames.remove(name);
                                continue;
                            }
                            newNames = true;
                            break;
                        }
                        if (!oldNames.isEmpty()) {
                            newNames = true;
                        }
                        if (newNames) {
                            PropertyModel.this.propertyNames = names.toArray(new String[names.size()]);
                            PropertyModel.this.notifyListeners(new TableModelEvent(PropertyModel.this, -1));
                        }
                    }
                    Enumeration<TableColumn> columns = JPropertyTable.this.getColumnModel().getColumns();
                    while (columns.hasMoreElements()) {
                        Object clientProperty;
                        TableColumn column = columns.nextElement();
                        column.removePropertyChangeListener(JPropertyTable.this.columnWidthListener);
                        String property = JPropertyTable.this.getPropertyNameForCell(0, column.getModelIndex());
                        Class cls = JPropertyTable.this.getClassForCell(0, column.getModelIndex());
                        if (property != null && cls != null) {
                            clientProperty = ObjectInspector.get().getConfig().getClientProperty(cls.getName() + "." + property + ".width");
                            try {
                                if (clientProperty instanceof Integer) {
                                    column.setPreferredWidth((Integer)clientProperty);
                                } else if (clientProperty instanceof String) {
                                    column.setPreferredWidth(Integer.parseInt((String)clientProperty));
                                }
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        if (JPropertyTable.this.getName() != null && property != null) {
                            clientProperty = ObjectInspector.get().getConfig().getClientProperty("column " + JPropertyTable.this.getName() + "." + property);
                            int newColumn = -1;
                            try {
                                if (clientProperty instanceof Integer) {
                                    newColumn = (Integer)clientProperty;
                                } else if (clientProperty instanceof String) {
                                    newColumn = Integer.parseInt((String)clientProperty);
                                }
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                            if (newColumn >= 0) {
                                if (newColumn >= PropertyModel.this.getColumnCount()) {
                                    newColumn = PropertyModel.this.getColumnCount() - 1;
                                }
                                JPropertyTable.this.moveColumn(column.getModelIndex(), newColumn);
                            }
                        }
                        column.addPropertyChangeListener(JPropertyTable.this.columnWidthListener);
                    }
                    if (!newNames) {
                        PropertyModel.this.notifyListeners(new TableModelEvent(PropertyModel.this));
                    }
                }
            });
        }

        private class TablePCListener
        implements PropertyChangeListener {
            private PropertyChangeSource object;
            private int index;
            private boolean stillNeeded;

            public TablePCListener(PropertyChangeSource object, int index) {
                this.object = object;
                this.index = index;
                object.addPropertyChangeListener(this);
                this.stillNeeded = true;
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt != null && evt.getPropertyName() != null) {
                    for (int propIndex = 0; propIndex < PropertyModel.this.propertyNames.length; ++propIndex) {
                        String propName = PropertyModel.this.getPropertyName(0, propIndex);
                        if (!evt.getPropertyName().equals(propName)) continue;
                        if (JPropertyTable.this.isVertical()) {
                            PropertyModel.this.notifyListeners(new TableModelEvent(PropertyModel.this, propIndex, propIndex, 1));
                        } else {
                            PropertyModel.this.notifyListeners(new TableModelEvent(PropertyModel.this, this.index, this.index, propIndex));
                        }
                        return;
                    }
                }
                PropertyModel.this.notifyListeners(new TableModelEvent(PropertyModel.this));
            }

            public void removeYou() {
                if (this.object != null) {
                    this.object.removePropertyChangeListener(this);
                    this.object = null;
                }
            }
        }
    }
}

