/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.coobra.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Password {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String passwordHash(String password) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            ByteBuffer bf = Charset.forName("UTF-8").encode(password);
            md.update(bf.array(), bf.arrayOffset(), bf.limit());
            byte[] digest = md.digest();
            StringBuffer digestString = new StringBuffer(digest.length + 1);
            digestString.append('#');
            for (int i = 0; i < digest.length; ++i) {
                byte b = digest[i];
                digestString.append(digits[b >> 4 & 0xF]);
                digestString.append(digits[b & 0xF]);
            }
            return digestString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                String password = null;
                while (!"".equals(password)) {
                    System.out.print("password: ");
                    password = new BufferedReader(new InputStreamReader(System.in)).readLine();
                    System.out.println("hash = " + Password.passwordHash(password));
                }
            } else {
                for (int i = 0; i < args.length; ++i) {
                    String password = args[i];
                    System.out.println(Password.passwordHash(password));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

