/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.coobra.remote.lightweight;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class XMLObjectChangeUtils {
    private static XMLObjectChangeUtils instance;
    private static XMLOutputter xMLOutputter;
    private Comparator sortForCompactComparator;
    private Comparator sortInSequenceComparator;

    protected XMLObjectChangeUtils() {
    }

    public static XMLObjectChangeUtils get() {
        if (instance == null) {
            instance = new XMLObjectChangeUtils();
        }
        return instance;
    }

    public static void set(XMLObjectChangeUtils instance) {
        XMLObjectChangeUtils.instance = instance;
    }

    private static String getAffectedObject(Element xmlChange) {
        String id = xmlChange.getAttributeValue("object");
        if (id == null) {
            System.out.println("whoops - affected object id not found: " + xmlChange);
        }
        return id;
    }

    private static String getFieldName(Element xmlChange) {
        return xmlChange.getAttributeValue("field");
    }

    private static BigInteger getSequenceNumber(Element xmlChange) {
        return new BigInteger(xmlChange.getAttributeValue("number"));
    }

    private static int getTypeOfChange(Element xmlChange) {
        return Integer.parseInt(xmlChange.getAttributeValue("type"));
    }

    private static Object getKey(Element xmlChange) {
        String objectId;
        Element keyElement = xmlChange.getChild("key");
        if (keyElement != null && (objectId = keyElement.getAttributeValue("object")) != null) {
            return objectId;
        }
        return keyElement;
    }

    private static XMLOutputter getXMLOutputter() {
        if (xMLOutputter == null) {
            xMLOutputter = new XMLOutputter();
            xMLOutputter.setEncoding("UTF-8");
            xMLOutputter.setNewlines(false);
            xMLOutputter.setIndent(null);
        }
        return xMLOutputter;
    }

    private static String xmlToString(Element xml) {
        if (xml != null) {
            try {
                StringWriter xmlStringWriter = new StringWriter();
                XMLObjectChangeUtils.getXMLOutputter().output(xml, (Writer)xmlStringWriter);
                xmlStringWriter.flush();
                return xmlStringWriter.toString();
            }
            catch (IOException e) {
                throw new RuntimeException("Whoops! StringWriter has thrown an IOException!");
            }
        }
        return null;
    }

    private static String getOldValue(Element xmlChange) {
        String objectId;
        Element valueElement = xmlChange.getChild("oldValue");
        if (valueElement != null && (objectId = valueElement.getAttributeValue("object")) != null) {
            return objectId;
        }
        return XMLObjectChangeUtils.xmlToString(valueElement);
    }

    private static String getNewValue(Element xmlChange) {
        String objectId;
        Element valueElement = xmlChange.getChild("newValue");
        if (valueElement != null && (objectId = valueElement.getAttributeValue("object")) != null) {
            return objectId;
        }
        return XMLObjectChangeUtils.xmlToString(valueElement);
    }

    public boolean valuesEqual(Object value1, Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (!(value1 instanceof String) && !(value2 instanceof String)) {
            if (value1 != null && value2 != null) {
                return value1.equals(value2);
            }
            return false;
        }
        return value1 != null ? value1.equals(value2) : value2.equals(value1);
    }

    protected Comparator getSortForCompactComparator() {
        if (this.sortForCompactComparator == null) {
            this.sortForCompactComparator = new SortForCompact();
        }
        return this.sortForCompactComparator;
    }

    protected Comparator getSortInSequenceComparator() {
        if (this.sortInSequenceComparator == null) {
            this.sortInSequenceComparator = new SortBySequenceNumber();
        }
        return this.sortInSequenceComparator;
    }

    public void compact(Element changesParent) {
        if (changesParent != null) {
            Iterator iterator;
            TreeSet changes = new TreeSet(this.getSortForCompactComparator());
            changes.addAll(changesParent.getChildren());
            changesParent.getChildren().clear();
            TreeSet resultingChangesSet = new TreeSet(this.getSortInSequenceComparator());
            TreeSet<Element> changesToObject = new TreeSet<Element>(this.getSortInSequenceComparator());
            Element formerChange = null;
            String formerObjectId = null;
            TreeMap<String, Element> addedValues = new TreeMap<String, Element>();
            int created = 0;
            HashSet<String> removedObjects = new HashSet<String>();
            Iterator it = changes.iterator();
            boolean onceAgain = it.hasNext();
            while (onceAgain) {
                String currentObjectId;
                Element change;
                if (it.hasNext()) {
                    change = (Element)it.next();
                } else {
                    change = null;
                    onceAgain = false;
                }
                boolean sameField = false;
                String string = currentObjectId = change != null ? XMLObjectChangeUtils.getAffectedObject(change) : null;
                if (currentObjectId != null && currentObjectId.equals(formerObjectId)) {
                    String fieldName = XMLObjectChangeUtils.getFieldName(change);
                    if (formerChange != null && fieldName != null && XMLObjectChangeUtils.getFieldName(formerChange) != null && fieldName.equals(XMLObjectChangeUtils.getFieldName(formerChange))) {
                        Object changeKey = XMLObjectChangeUtils.getKey(change);
                        Object formerChangeKey = XMLObjectChangeUtils.getKey(formerChange);
                        if (changeKey == null && formerChangeKey == null || changeKey instanceof String && changeKey.equals(formerChangeKey) || changeKey instanceof Element && formerChangeKey instanceof Element && XMLObjectChangeUtils.xmlToString((Element)changeKey).equals(XMLObjectChangeUtils.xmlToString((Element)formerChangeKey))) {
                            Element addChange;
                            sameField = true;
                            if (XMLObjectChangeUtils.getTypeOfChange(change) == 12 && XMLObjectChangeUtils.getTypeOfChange(formerChange) == 12) {
                                if (!this.valuesEqual(XMLObjectChangeUtils.getOldValue(formerChange), XMLObjectChangeUtils.getNewValue(change))) {
                                    change = (Element)change.clone();
                                    change.removeChild("oldValue");
                                    Element oldValueElement = formerChange.getChild("oldValue");
                                    if (oldValueElement != null) {
                                        change.addContent((Element)oldValueElement.clone());
                                    }
                                    formerChange = null;
                                } else {
                                    change = null;
                                    formerChange = null;
                                }
                            } else if (XMLObjectChangeUtils.getTypeOfChange(change) == 8 && XMLObjectChangeUtils.getOldValue(change) != null && (addChange = (Element)addedValues.get(XMLObjectChangeUtils.getOldValue(change))) != null) {
                                if (formerChange == addChange) {
                                    formerChange = null;
                                } else {
                                    changesToObject.remove(addChange);
                                }
                                change = null;
                            }
                        }
                    }
                }
                if (formerChange != null && XMLObjectChangeUtils.getAffectedObject(formerChange).equals(formerObjectId)) {
                    changesToObject.add(formerChange);
                }
                if (!sameField) {
                    addedValues.clear();
                }
                if (currentObjectId == null || !currentObjectId.equals(formerObjectId)) {
                    if (formerObjectId != null) {
                        if (created >= 0) {
                            if (change != null && XMLObjectChangeUtils.getAffectedObject(change).equals(formerObjectId)) {
                                changesToObject.add(change);
                            }
                            resultingChangesSet.addAll(changesToObject);
                            formerChange = null;
                        } else {
                            removedObjects.add(formerObjectId);
                        }
                    }
                    formerObjectId = currentObjectId;
                    created = 0;
                    changesToObject.clear();
                }
                if (formerChange != null && XMLObjectChangeUtils.getAffectedObject(formerChange).equals(formerObjectId)) {
                    changesToObject.add(formerChange);
                }
                if (change != null) {
                    if (XMLObjectChangeUtils.getTypeOfChange(change) == 2 && created == 1) {
                        created = -1;
                    } else if (XMLObjectChangeUtils.getTypeOfChange(change) == 1) {
                        created = 1;
                    }
                    if (XMLObjectChangeUtils.getTypeOfChange(change) == 4) {
                        if (XMLObjectChangeUtils.getNewValue(change) != null) {
                            addedValues.put(XMLObjectChangeUtils.getNewValue(change), change);
                        }
                    } else if (XMLObjectChangeUtils.getTypeOfChange(change) == 8 && XMLObjectChangeUtils.getOldValue(change) != null) {
                        addedValues.remove(XMLObjectChangeUtils.getOldValue(change));
                    }
                }
                formerChange = change;
            }
            boolean useIteratorDotRemove = false;
            boolean finished = false;
            TreeSet changesWithRemovedKeys = new TreeSet();
            while (!finished) {
                try {
                    iterator = resultingChangesSet.iterator();
                    while (iterator.hasNext()) {
                        boolean remove;
                        Element change = (Element)iterator.next();
                        if (removedObjects.contains(XMLObjectChangeUtils.getNewValue(change)) || removedObjects.contains(XMLObjectChangeUtils.getOldValue(change))) {
                            remove = true;
                        } else if (removedObjects.contains(XMLObjectChangeUtils.getKey(change))) {
                            remove = true;
                            Element newChange = (Element)change.clone();
                            newChange.removeChild("key");
                        } else {
                            remove = false;
                        }
                        if (!remove) continue;
                        if (useIteratorDotRemove) {
                            iterator.remove();
                            continue;
                        }
                        resultingChangesSet.remove(change);
                    }
                    finished = true;
                }
                catch (ConcurrentModificationException e) {
                    useIteratorDotRemove = true;
                }
            }
            removedObjects.clear();
            resultingChangesSet.addAll(changesWithRemovedKeys);
            iterator = resultingChangesSet.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                changesParent.addContent(element);
            }
            resultingChangesSet.clear();
        }
    }

    public static class SortBySequenceNumber
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Element change1 = (Element)o1;
            Element change2 = (Element)o2;
            return XMLObjectChangeUtils.getSequenceNumber(change1).compareTo(XMLObjectChangeUtils.getSequenceNumber(change2));
        }
    }

    public static class SortForCompact
    implements Comparator {
        public int compare(Object o1, Object o2) {
            boolean sameKey;
            Element change1 = (Element)o1;
            Element change2 = (Element)o2;
            if (change1 == change2) {
                return 0;
            }
            if (!XMLObjectChangeUtils.getAffectedObject(change1).equals(XMLObjectChangeUtils.getAffectedObject(change2))) {
                String id2;
                String id1 = XMLObjectChangeUtils.getAffectedObject(change1);
                int cmp = id1.compareTo(id2 = XMLObjectChangeUtils.getAffectedObject(change2));
                if (cmp != 0) {
                    return cmp;
                }
                throw new RuntimeException("Two object are not the same but have equal ids!");
            }
            if (XMLObjectChangeUtils.getFieldName(change1) != null && !XMLObjectChangeUtils.getFieldName(change1).equals(XMLObjectChangeUtils.getFieldName(change2))) {
                if (XMLObjectChangeUtils.getFieldName(change2) == null) {
                    return 1;
                }
                return XMLObjectChangeUtils.getFieldName(change1).compareTo(XMLObjectChangeUtils.getFieldName(change2));
            }
            if (XMLObjectChangeUtils.getFieldName(change1) == null && XMLObjectChangeUtils.getFieldName(change2) != null) {
                if (XMLObjectChangeUtils.getFieldName(change1) == null) {
                    return -1;
                }
                return -XMLObjectChangeUtils.getFieldName(change2).compareTo(XMLObjectChangeUtils.getFieldName(change1));
            }
            Object changeKey = XMLObjectChangeUtils.getKey(change1);
            Object formerChangeKey = XMLObjectChangeUtils.getKey(change2);
            boolean bl = sameKey = changeKey == null && formerChangeKey == null || changeKey instanceof String && changeKey.equals(formerChangeKey) || changeKey instanceof Element && formerChangeKey instanceof Element && XMLObjectChangeUtils.xmlToString((Element)changeKey).equals(XMLObjectChangeUtils.xmlToString((Element)formerChangeKey));
            if (!sameKey) {
                if (XMLObjectChangeUtils.getKey(change1) == null) {
                    return -1;
                }
                if (XMLObjectChangeUtils.getKey(change2) == null) {
                    return 1;
                }
                if (XMLObjectChangeUtils.getKey(change1) instanceof String && XMLObjectChangeUtils.getKey(change2) instanceof String) {
                    return ((String)XMLObjectChangeUtils.getKey(change1)).compareTo((String)XMLObjectChangeUtils.getKey(change2));
                }
                if (XMLObjectChangeUtils.getKey(change1) instanceof Element && XMLObjectChangeUtils.getKey(change2) instanceof Element) {
                    return XMLObjectChangeUtils.xmlToString((Element)XMLObjectChangeUtils.getKey(change1)).compareTo(XMLObjectChangeUtils.xmlToString((Element)XMLObjectChangeUtils.getKey(change2)));
                }
                int cmp = change1.hashCode() - change2.hashCode();
                if (cmp != 0) {
                    return cmp;
                }
                System.err.println("cannot handle keys in " + change1 + " and " + change2);
                return 1;
            }
            if (!XMLObjectChangeUtils.getSequenceNumber(change1).equals(XMLObjectChangeUtils.getSequenceNumber(change2))) {
                return XMLObjectChangeUtils.getSequenceNumber(change1).compareTo(XMLObjectChangeUtils.getSequenceNumber(change2));
            }
            throw new RuntimeException("Two changes that are not the same have the same sequencenumber!");
        }
    }
}

