/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.coobra.remote.lightweight;

import de.tu_bs.coobra.remote.lightweight.LightWeightServerImpl;
import de.tu_bs.coobra.util.Password;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class LightWeightServerImplWithAuthentication
extends LightWeightServerImpl {
    public static final String COMMAND_LOGIN = "LOGIN";
    private String authFileName;
    private Map users = new TreeMap();
    public static final String ERROR_AUTH = "authentication failed";
    public static final String ERROR_DENIED_PREFIX = "access to repository denied for user ";
    long authLastRead = -1L;
    public static final String PREFIX_USER = "user ";
    public static final String PREFIX_PASSWORD = "pass ";
    public static final String PREFIX_ALLOW = "allow ";
    public static final String PREFIX_ADMIN = "admin";
    private static LightWeightServerImpl.ServerFactory serverFactory;

    public LightWeightServerImplWithAuthentication(int port, String repositoryName, String authFileName) throws IOException {
        super(port, repositoryName);
        this.authFileName = authFileName;
    }

    protected void process(Socket socket) {
        new AuthClientSocketProcessor(socket).start();
    }

    private synchronized void restore() throws IOException {
        File file = new File(this.authFileName);
        if (file.exists() && file.lastModified() > this.authLastRead) {
            String line;
            this.authLastRead = file.lastModified();
            FileInputStream fileStream = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fileStream));
            String user = null;
            String password = null;
            TreeSet<String> allowed = null;
            boolean admin = false;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith(PREFIX_USER)) {
                    this.addUserInfo(user, password, allowed, admin);
                    allowed = new TreeSet<String>();
                    user = line.substring(PREFIX_USER.length());
                    password = null;
                    admin = false;
                    continue;
                }
                if (line.startsWith(PREFIX_PASSWORD)) {
                    password = line.substring(PREFIX_PASSWORD.length());
                    continue;
                }
                if (line.startsWith(PREFIX_ALLOW) && allowed != null) {
                    allowed.add(line.substring(PREFIX_ALLOW.length()));
                    continue;
                }
                if (!line.startsWith(PREFIX_ADMIN)) continue;
                admin = true;
            }
            this.addUserInfo(user, password, allowed, admin);
            reader.close();
        }
    }

    private void addUserInfo(String user, String password, Set allowed, boolean admin) {
        if (user != null) {
            if (password == null) {
                LightWeightServerImplWithAuthentication.log("adding user '" + user + "' without password");
                password = "";
            }
            if (!password.startsWith("#")) {
                password = Password.passwordHash(password);
            }
            UserInfo info = new UserInfo(allowed, password.toLowerCase(), admin);
            this.users.put(user, info);
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            LightWeightServerImplWithAuthentication.log("starting auth server with args '" + args[0] + "'");
        }
        LightWeightServerImplWithAuthentication.startServer(LightWeightServerImplWithAuthentication.getServerFactory(), args);
    }

    public static LightWeightServerImpl.ServerFactory getServerFactory() {
        if (serverFactory == null) {
            serverFactory = new AuthServerFactory();
        }
        return serverFactory;
    }

    protected void checkin(BufferedReader reader, LightWeightServerImpl.ClientSocketProcessor processor) throws IOException, LightWeightServerImpl.LockNotAvailableException {
        AuthClientSocketProcessor authClientSocketProcessor;
        if (processor instanceof AuthClientSocketProcessor && ("guest".equals((authClientSocketProcessor = (AuthClientSocketProcessor)processor).getLogin()) || "anonymous".equals(authClientSocketProcessor.getLogin()))) {
            throw new RuntimeException("guest/anonymous is not allowed to check in");
        }
        super.checkin(reader, processor);
    }

    public static class AuthServerFactory
    extends LightWeightServerImpl.ServerFactory {
        public LightWeightServerImpl startServer(int port, String repositoryName) throws IOException {
            return new LightWeightServerImplWithAuthentication(port, repositoryName, "auth.conf");
        }
    }

    protected class AuthClientSocketProcessor
    extends LightWeightServerImpl.ClientSocketProcessor {
        private String login;

        public String getLogin() {
            return this.login;
        }

        public void setLogin(String value) {
            if (this.login != value) {
                this.login = value;
            }
        }

        public AuthClientSocketProcessor(Socket socket) {
            super(socket);
        }

        public void run() {
            try {
                UserInfo info;
                boolean authenticated = false;
                boolean denied = false;
                LightWeightServerImpl.log("reading command:");
                String command = this.getReader().readLine();
                LightWeightServerImpl.log(command);
                String login = "guest";
                String password = "guest";
                if (LightWeightServerImplWithAuthentication.COMMAND_LOGIN.equals(command)) {
                    LightWeightServerImplWithAuthentication.this.restore();
                    login = this.getReader().readLine();
                    password = this.getReader().readLine().toLowerCase();
                    if (!password.startsWith("#")) {
                        password = Password.passwordHash(password);
                    }
                    command = null;
                }
                if ((info = (UserInfo)LightWeightServerImplWithAuthentication.this.users.get(login)) != null && password != null && this.passwordMatches(password, info)) {
                    if (info.getAllowedServices().contains(LightWeightServerImplWithAuthentication.this.getRepositoryName())) {
                        authenticated = true;
                        this.setLogin(login);
                    } else {
                        authenticated = true;
                        if (!info.isAdmin()) {
                            denied = true;
                        }
                    }
                }
                if (authenticated && !denied) {
                    LightWeightServerImpl.log("authenticated user '" + login + "'");
                    if (command != null) {
                        super.execute(command);
                    } else {
                        super.run();
                    }
                } else if (!authenticated) {
                    LightWeightServerImpl.log("authentication failed for user '" + login + "'");
                    this.respond("FAILURE", LightWeightServerImplWithAuthentication.ERROR_AUTH);
                } else {
                    LightWeightServerImpl.log("permission denied for user '" + login + "'");
                    this.respond("FAILURE", LightWeightServerImplWithAuthentication.ERROR_DENIED_PREFIX + login);
                }
                this.closeSocket();
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (!this.socket.isClosed()) {
                        this.socket.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            this.setLogin(null);
        }

        private boolean passwordMatches(String password, UserInfo info) {
            String correctPassword = info.getPassword();
            boolean equals = password.equals(correctPassword);
            int length = password.length();
            if (!equals && (length & 1) == 1 && length == correctPassword.length()) {
                for (int i = 0; i < length - 1; ++i) {
                    char c2;
                    char c1 = password.charAt(i + 1);
                    if (c1 == (c2 = correctPassword.charAt((i ^ 1) + 1))) continue;
                    return false;
                }
                return true;
            }
            return equals;
        }

        protected String getConnectionInfo() {
            return this.getLogin() + " " + super.getConnectionInfo();
        }
    }

    private static class UserInfo {
        private String password;
        private Set allowedServices;
        private boolean admin = false;

        public Set getAllowedServices() {
            return this.allowedServices;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean isAdmin() {
            return this.admin;
        }

        public UserInfo(Set allowedServices, String password, boolean admin) {
            this.allowedServices = allowedServices;
            this.password = password;
            this.admin = admin;
        }
    }
}

