/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.coobra;

import de.tu_bs.coobra.errors.RemoteException;
import de.tu_bs.coobra.remote.RemoteRepository;
import de.tu_bs.coobra.remote.ServerRepository;
import de.tu_bs.coobra.remote.ServerRepositoryHelper;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;

public class RemoteRepositoryManager {
    private ORB orb;
    private NamingContextExt ncRef;

    public RemoteRepositoryManager(String nameServer, String nameServerPort, String[] orbArgs) {
        try {
            Properties props = new Properties();
            if (nameServer == null) {
                nameServer = "localhost";
            }
            if (nameServerPort != null) {
                props.put("org.omg.CORBA.ORBInitRef", "NameService=corbaloc::" + nameServer + ":" + nameServerPort);
            }
            this.orb = ORB.init((String[])orbArgs, (Properties)props);
        }
        catch (SystemException e) {
            throw new RemoteException(e, false);
        }
        catch (Exception e) {
            throw new RemoteException(e, true);
        }
    }

    public RemoteRepositoryManager(String[] orbArgs) {
        try {
            this.orb = ORB.init((String[])orbArgs, null);
        }
        catch (SystemException e) {
            throw new RemoteException(e, false);
        }
        catch (Exception e) {
            throw new RemoteException(e, true);
        }
    }

    public RemoteRepository connectByName(String repositoryName) {
        try {
            if (this.ncRef == null) {
                Object objRef = this.orb.resolve_initial_references("NameService");
                this.ncRef = NamingContextExtHelper.narrow((Object)objRef);
            }
            ServerRepository repo = ServerRepositoryHelper.narrow(this.ncRef.resolve_str(repositoryName));
            return new RemoteRepository(repo);
        }
        catch (SystemException e) {
            throw new RemoteException(e, false);
        }
        catch (Exception e) {
            throw new RemoteException(e, true);
        }
    }

    public RemoteRepository connectByIOR(String repositoryIOR) {
        try {
            Object obj_ref = this.orb.string_to_object(repositoryIOR);
            ServerRepository repo = ServerRepositoryHelper.narrow(obj_ref);
            return new RemoteRepository(repo);
        }
        catch (SystemException e) {
            throw new RemoteException(e, false);
        }
        catch (Exception e) {
            throw new RemoteException(e, true);
        }
    }

    public static void main(String[] args) {
        try {
            new RemoteRepositoryManager(args).connectByName("ServerRepository").checkin("<changes />", "-1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

