/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.coobra;

import de.tu_bs.coobra.LocalRepository;
import de.tu_bs.coobra.ObjectChange;
import de.tu_bs.coobra.ObjectChangeAware;
import de.tu_bs.coobra.ObjectChangeCause;
import de.tu_bs.coobra.ObjectChangeUtils;
import de.tu_bs.coobra.errors.UndoRedoException;
import de.tu_bs.xmlreflect.util.AccessorMethodsUtilizer;
import de.tu_bs.xmlreflect.util.errors.AccessorException;
import de.tu_bs.xmlreflect.util.errors.AccessorInvocationException;
import de.upb.tools.fca.FHashMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;

public class ObjectChangeAwareHelper {
    public static final UndoRedoCause CAUSE_UNDOREDO = new UndoRedoCause();
    private static boolean relaxed = false;

    private ObjectChangeAwareHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void undo(ObjectChange change) {
        ObjectChange.pushCause(CAUSE_UNDOREDO);
        try {
            switch (change.getTypeOfChange()) {
                case 12: {
                    if (!ObjectChangeAwareHelper.isRelaxed()) {
                        Object currentValue;
                        if (change.getKey() == null) {
                            currentValue = AccessorMethodsUtilizer.getField((Object)change.getAffectedObject(), (String)change.getFieldName());
                        } else {
                            try {
                                currentValue = AccessorMethodsUtilizer.getField((Object)change.getAffectedObject(), (String)change.getFieldName());
                            }
                            catch (AccessorException e) {
                                currentValue = AccessorMethodsUtilizer.getQualifiedField((Object)change.getAffectedObject(), (String)change.getFieldName(), (Object)change.getKey());
                            }
                        }
                        if (!ObjectChangeUtils.get().valuesEqual(currentValue, change.getNewValue()) && !ObjectChangeUtils.get().valuesEqual(currentValue, change.getOldValue())) {
                            new UndoRedoException("Current field value does not match to undo change (was " + currentValue + "): " + change, false, change).printStackTrace();
                        }
                    }
                    try {
                        if (change.getKey() == null) {
                            AccessorMethodsUtilizer.setField((Object)change.getAffectedObject(), (String)change.getFieldName(), (Object)change.getOldValue());
                            return;
                        }
                        AccessorMethodsUtilizer.addToQualifiedField((Object)change.getAffectedObject(), (String)change.getFieldName(), (Object)change.getKey(), (Object)change.getOldValue());
                        return;
                    }
                    catch (AccessorException e) {
                        new UndoRedoException(e, true, change).printStackTrace();
                        return;
                    }
                }
                case 4: {
                    try {
                        if (change.getKey() == null) {
                            ObjectChangeAwareHelper.removeFromField(change.getAffectedObject(), change.getFieldName(), change.getNewValue());
                            return;
                        }
                        ObjectChangeAwareHelper.removeFromQualifiedField(change.getAffectedObject(), change.getFieldName(), change.getKey(), change.getNewValue());
                        return;
                    }
                    catch (AccessorException e) {
                        new UndoRedoException(e, true, change).printStackTrace();
                        return;
                    }
                }
                case 8: {
                    try {
                        if (change.getKey() == null) {
                            AccessorMethodsUtilizer.addToField((Object)change.getAffectedObject(), (String)change.getFieldName(), (Object)change.getOldValue());
                            return;
                        }
                        AccessorMethodsUtilizer.addToQualifiedField((Object)change.getAffectedObject(), (String)change.getFieldName(), (Object)change.getKey(), (Object)change.getOldValue());
                        return;
                    }
                    catch (AccessorException e) {
                        new UndoRedoException(e, true, change).printStackTrace();
                        return;
                    }
                }
                case 64: {
                    return;
                }
                default: {
                    throw new UndoRedoException("Do not know how to undo " + change, false, change);
                }
            }
        }
        finally {
            ObjectChange.popCause(CAUSE_UNDOREDO);
        }
    }

    public static void setRelaxed(boolean relaxed) {
        ObjectChangeAwareHelper.relaxed = relaxed;
    }

    public static boolean isRelaxed() {
        return relaxed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void redo(ObjectChange change, boolean checkOnly) {
        ObjectChange.pushCause(CAUSE_UNDOREDO);
        try {
            switch (change.getTypeOfChange()) {
                case 12: {
                    if (!ObjectChangeAwareHelper.isRelaxed() || checkOnly) {
                        Object currentValue;
                        try {
                            if (change.getKey() == null) {
                                currentValue = AccessorMethodsUtilizer.getField((Object)change.getAffectedObject(), (String)change.getFieldName());
                            } else {
                                try {
                                    currentValue = AccessorMethodsUtilizer.getField((Object)change.getAffectedObject(), (String)change.getFieldName());
                                }
                                catch (AccessorException e) {
                                    currentValue = AccessorMethodsUtilizer.getQualifiedField((Object)change.getAffectedObject(), (String)change.getFieldName(), (Object)change.getKey());
                                }
                            }
                        }
                        catch (AccessorException e) {
                            throw new UndoRedoException(e, false, change);
                        }
                        catch (Exception e) {
                            throw new UndoRedoException(e, false, change);
                        }
                        if (!ObjectChangeUtils.get().valuesEqual(currentValue, change.getNewValue()) && !ObjectChangeUtils.get().valuesEqual(currentValue, change.getOldValue())) {
                            UndoRedoException exception = new UndoRedoException("Current field value does not match to redo change: " + change + "(value: " + currentValue + ")", false, change);
                            if (checkOnly) {
                                throw exception;
                            }
                            System.err.println(exception.getMessage());
                        }
                    }
                    if (checkOnly) return;
                    try {
                        if (change.getKey() == null) {
                            AccessorMethodsUtilizer.setField((Object)change.getAffectedObject(), (String)change.getFieldName(), (Object)change.getNewValue());
                            return;
                        } else {
                            AccessorMethodsUtilizer.addToQualifiedField((Object)change.getAffectedObject(), (String)change.getFieldName(), (Object)change.getKey(), (Object)change.getNewValue());
                            return;
                        }
                    }
                    catch (AccessorException e) {
                        throw new UndoRedoException(e, true, change);
                    }
                    catch (Exception e) {
                        throw new UndoRedoException(e, true, change);
                    }
                }
                case 4: {
                    if (checkOnly) return;
                    try {
                        if (change.getKey() == null) {
                            try {
                                AccessorMethodsUtilizer.addToField((Object)change.getAffectedObject(), (String)change.getFieldName(), (Object)change.getNewValue());
                                return;
                            }
                            catch (AccessorException e1) {
                                try {
                                    AccessorMethodsUtilizer.addToQualifiedField((Object)change.getAffectedObject(), (String)change.getFieldName(), (Object)change.getKey(), (Object)change.getNewValue());
                                    return;
                                }
                                catch (AccessorException e2) {
                                    throw e1;
                                }
                            }
                        }
                        AccessorMethodsUtilizer.addToQualifiedField((Object)change.getAffectedObject(), (String)change.getFieldName(), (Object)change.getKey(), (Object)change.getNewValue());
                        return;
                    }
                    catch (AccessorException e) {
                        throw new UndoRedoException(e, true, change);
                    }
                    catch (Exception e) {
                        throw new UndoRedoException(e, true, change);
                    }
                }
                case 8: {
                    if (checkOnly) return;
                    try {
                        if (change.getKey() == null) {
                            ObjectChangeAwareHelper.removeFromField(change.getAffectedObject(), change.getFieldName(), change.getOldValue());
                            return;
                        } else {
                            ObjectChangeAwareHelper.removeFromQualifiedField(change.getAffectedObject(), change.getFieldName(), change.getKey(), change.getOldValue());
                            return;
                        }
                    }
                    catch (AccessorException e) {
                        throw new UndoRedoException(e, true, change);
                    }
                    catch (Exception e) {
                        throw new UndoRedoException(e, true, change);
                    }
                }
                case 64: {
                    return;
                }
                default: {
                    throw new UndoRedoException("Do not know how to undo " + change, false, change);
                }
            }
        }
        finally {
            ObjectChange.popCause(CAUSE_UNDOREDO);
        }
    }

    protected static void removeFromField(Object object, String fieldName, Object oldValue) {
        if (object != null && oldValue != null) {
            try {
                String suffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                String removeName = "removeFrom" + suffix;
                Class<?> cls = object.getClass();
                Method removeMethod = null;
                Method[] methods = cls.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Class<?>[] paramTypes;
                    Method method = methods[i];
                    if (!method.getName().equals(removeName) || (paramTypes = method.getParameterTypes()).length != 1 || !paramTypes[0].isAssignableFrom(oldValue.getClass())) continue;
                    removeMethod = method;
                }
                if (removeMethod == null) {
                    throw new AccessorException("Could not find remove method for field " + fieldName, null);
                }
                Object[] args = new Object[]{oldValue};
                removeMethod.invoke(object, args);
            }
            catch (IllegalAccessException e) {
                throw new AccessorException("Could not access add method for field " + fieldName, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new AccessorInvocationException("Could not invoke add method for field " + fieldName, e.getCause());
            }
        }
    }

    protected static void removeFromQualifiedField(Object object, String fieldName, Object key, Object value) {
        block14: {
            if (object != null && key != null) {
                try {
                    String suffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    String removeName = "removeFrom" + suffix;
                    String removeKeyName = "removeKeyFrom" + suffix;
                    String setName = "set" + suffix;
                    Class<?> cls = object.getClass();
                    Method removeMethod = null;
                    Method[] methods = cls.getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        Class<?>[] paramTypes;
                        Method method = methods[i];
                        if (method.getName().equals(removeName) || method.getName().equals(setName)) {
                            paramTypes = method.getParameterTypes();
                            if (paramTypes.length == 2) {
                                if (!paramTypes[0].isInstance(key) || value != null && !paramTypes[1].isInstance(value)) continue;
                                removeMethod = method;
                                continue;
                            }
                            if (paramTypes.length != 1 || !method.getName().equals(removeName) || value != null && !paramTypes[0].isInstance(value)) continue;
                            removeMethod = method;
                            continue;
                        }
                        if (!method.getName().equals(removeKeyName) || (paramTypes = method.getParameterTypes()).length != 1 || !paramTypes[0].isAssignableFrom(key.getClass())) continue;
                        removeMethod = method;
                    }
                    if (removeMethod != null) {
                        if (removeMethod.getName().equals(removeKeyName)) {
                            Object[] args = new Object[]{key};
                            removeMethod.invoke(object, args);
                        } else if (removeMethod.getName().equals(setName)) {
                            Object[] args = new Object[]{key, null};
                            removeMethod.invoke(object, args);
                        } else if (removeMethod.getParameterTypes().length == 2) {
                            Object[] args = new Object[]{key, value};
                            removeMethod.invoke(object, args);
                        } else {
                            Object[] args = new Object[]{value};
                            removeMethod.invoke(object, args);
                        }
                        break block14;
                    }
                    throw new AccessorException("Could not find remove method for qualified field " + fieldName, null);
                }
                catch (IllegalAccessException e) {
                    throw new AccessorException("Could not access add method for qualified field " + fieldName, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new AccessorInvocationException("Could not invoke add method for qualified field " + fieldName, e.getCause());
                }
            }
        }
    }

    public static ObjectChange fireChange(ObjectChangeAware object, String fieldName, int changeType, Object oldValue, Object newValue, Object key) {
        LocalRepository repository = object.getRepository();
        ObjectChangeCause cause = ObjectChange.peekCause();
        if (LocalRepository.isValid(repository, object)) {
            ObjectChange change = repository.createObjectChange(cause, object, fieldName, changeType, oldValue, newValue, key);
            if (change.getCause() == null || !change.getCause().isUndoRedo()) {
                object.getRepository().addToChanges(change);
            }
            return change;
        }
        if (cause instanceof ObjectChange && ((ObjectChange)ObjectChange.peekCause()).getSequenceNumber().compareTo(BigInteger.ZERO) >= 0) {
            cause = null;
        }
        return new ObjectChange(cause, object, fieldName, changeType, oldValue, newValue, null, key);
    }

    public static ObjectChange preSetter(ObjectChangeAware object, String fieldName, int changeType, Object oldValue, Object newValue, Object key) {
        ObjectChange change = ObjectChangeAwareHelper.fireChange(object, fieldName, changeType, oldValue, newValue, key);
        ObjectChange.pushCause(change);
        return change;
    }

    public static ObjectChange preSetter(ObjectChangeAware object, String fieldName, int changeType, Object oldValue, Object newValue) {
        return ObjectChangeAwareHelper.preSetter(object, fieldName, changeType, oldValue, newValue, null);
    }

    public static void postSetter(ObjectChange resultOfPreSetter) {
        if (resultOfPreSetter != null) {
            ObjectChange.popCause(resultOfPreSetter);
            if (resultOfPreSetter.getAffectedObject() != null) {
                resultOfPreSetter.getAffectedObject().acknowledgeChange(resultOfPreSetter);
            }
        } else {
            throw new NullPointerException("Result of preSetter() delivered to postSetter() must not be null!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void undo(ObjectChange change, LocalRepository repository) {
        ObjectChangeAwareHelper.CAUSE_UNDOREDO.setUndoneOrRedoneChange(change);
        try {
            switch (change.getTypeOfChange()) {
                case 2: {
                    ObjectChange.pushCause(CAUSE_UNDOREDO);
                    try {
                        change.getAffectedObject().setRepository(repository);
                        return;
                    }
                    finally {
                        ObjectChange.popCause(CAUSE_UNDOREDO);
                    }
                }
                case 1: {
                    ObjectChange.pushCause(CAUSE_UNDOREDO);
                    try {
                        change.getAffectedObject().setRepository(null);
                        return;
                    }
                    finally {
                        ObjectChange.popCause(CAUSE_UNDOREDO);
                    }
                }
                default: {
                    if (change.getAffectedObject() != null) {
                        ObjectChangeAwareHelper.undo(change);
                        return;
                    } else {
                        LocalRepository.getErrorHandler().handle(new UndoRedoException("Do not know how to undo: " + change, false, change));
                    }
                    return;
                }
            }
        }
        finally {
            ObjectChangeAwareHelper.CAUSE_UNDOREDO.setUndoneOrRedoneChange(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void redo(ObjectChange change, boolean checkOnly, LocalRepository repository) {
        if (checkOnly && repository.undoredoCheckRepositories == null) {
            repository.undoredoCheckRepositories = new FHashMap();
        }
        ObjectChangeAwareHelper.CAUSE_UNDOREDO.setUndoneOrRedoneChange(change);
        try {
            switch (change.getTypeOfChange()) {
                case 1: {
                    if (!checkOnly) {
                        ObjectChange.pushCause(CAUSE_UNDOREDO);
                        try {
                            change.getAffectedObject().setRepository(repository);
                            return;
                        }
                        finally {
                            ObjectChange.popCause(CAUSE_UNDOREDO);
                        }
                    }
                    repository.undoredoCheckRepositories.put(change.getAffectedObject(), repository);
                    return;
                }
                case 2: {
                    if (!checkOnly) {
                        ObjectChange.pushCause(CAUSE_UNDOREDO);
                        try {
                            change.getAffectedObject().setRepository(null);
                            if (change.getAffectedObject() == null) return;
                            try {
                                Method removeYouMethod = change.getAffectedObject().getClass().getMethod("removeYou", null);
                                try {
                                    removeYouMethod.invoke((Object)change.getAffectedObject(), null);
                                    return;
                                }
                                catch (IllegalAccessException e) {
                                    e.printStackTrace();
                                    return;
                                }
                                catch (InvocationTargetException e) {
                                    e.printStackTrace();
                                    return;
                                }
                            }
                            catch (NoSuchMethodException e) {
                                // empty catch block
                            }
                            return;
                        }
                        finally {
                            ObjectChange.popCause(CAUSE_UNDOREDO);
                        }
                    }
                    repository.undoredoCheckRepositories.put(change.getAffectedObject(), null);
                    return;
                }
                default: {
                    if (change.getAffectedObject() != null) {
                        LocalRepository objectRepository = change.getAffectedObject().getRepository();
                        if (!(objectRepository == repository || objectRepository == null || checkOnly && repository.undoredoCheckRepositories.get(change.getAffectedObject()) == repository)) {
                            if (!LocalRepository.IGNORE_CHANGES_TO_REMOVED_OBJECTS) throw new UndoRedoException((checkOnly ? "check: " : "") + "The affected object is not " + "in this repository any more. Cannot redo change: " + change, false, change);
                            return;
                        } else {
                            ObjectChangeAware referencedObject;
                            LocalRepository valueRepository;
                            if (!(!(change.getNewValue() instanceof ObjectChangeAware) || (valueRepository = (referencedObject = (ObjectChangeAware)change.getNewValue()).getRepository()) == repository || valueRepository == null || referencedObject.getCoObRAId() == null || referencedObject.getCoObRAId().startsWith("singleton#") || checkOnly && repository.undoredoCheckRepositories.get(referencedObject) == repository)) {
                                throw new UndoRedoException("A referenced object is not in this repository any more. Cannot redo change: " + change, false, change);
                            }
                            ObjectChangeAwareHelper.redo(change, checkOnly);
                            return;
                        }
                    } else {
                        LocalRepository.getErrorHandler().handle(new UndoRedoException("Do not know how to redo: " + change, false, change));
                    }
                    return;
                }
            }
        }
        finally {
            ObjectChangeAwareHelper.CAUSE_UNDOREDO.setUndoneOrRedoneChange(null);
        }
    }

    static class UndoRedoCause
    extends ObjectChangeCause {
        private ObjectChange undoneOrRedoneChange;

        private UndoRedoCause() {
            super(true, null);
        }

        public ObjectChange getUndoneOrRedoneChange() {
            return this.undoneOrRedoneChange;
        }

        private void setUndoneOrRedoneChange(ObjectChange undoneOrRedoneChange) {
            this.undoneOrRedoneChange = undoneOrRedoneChange;
        }
    }
}

