/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.coobra;

import de.tu_bs.coobra.ObjectChange;
import de.tu_bs.coobra.ObjectChangeAware;

public class MutableObjectChange {
    private ObjectChangeAware affectedObject = null;
    private String fieldName = null;
    private Object key;
    private int typeOfChange = 0;
    private Object oldValue = null;
    private Object newValue = null;

    public MutableObjectChange(ObjectChangeAware affectedObject, String fieldName, int typeOfChange, Object oldValue, Object newValue) {
        this(affectedObject, fieldName, typeOfChange, oldValue, newValue, null);
    }

    public MutableObjectChange(ObjectChangeAware affectedObject, String fieldName, int typeOfChange, Object oldValue, Object newValue, Object key) {
        this.affectedObject = affectedObject;
        this.fieldName = fieldName;
        this.key = key;
        this.typeOfChange = typeOfChange;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public MutableObjectChange(ObjectChange change) {
        this(change.getAffectedObject(), change.getFieldName(), change.getTypeOfChange(), change.getOldValue(), change.getNewValue(), change.getKey());
    }

    public void removeYou() {
        this.affectedObject = null;
        this.fieldName = null;
        this.oldValue = null;
        this.newValue = null;
    }

    public Object getKey() {
        return this.key;
    }

    public ObjectChangeAware getAffectedObject() {
        return this.affectedObject;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getTypeOfChange() {
        return this.typeOfChange;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (otherObject instanceof MutableObjectChange) {
            MutableObjectChange otherChange = (MutableObjectChange)otherObject;
            if (this.getTypeOfChange() != otherChange.getTypeOfChange()) {
                return false;
            }
            if (this.getAffectedObject() != otherChange.getAffectedObject()) {
                return false;
            }
            if (this.getFieldName() != null ? !this.getFieldName().equals(otherChange.getFieldName()) : otherChange.getFieldName() != null) {
                return false;
            }
            if (this.getNewValue() != null ? (this.getNewValue() instanceof ObjectChangeAware ? this.getNewValue() != otherChange.getNewValue() : !this.getNewValue().equals(otherChange.getNewValue())) : otherChange.getNewValue() != null) {
                return false;
            }
            return !(this.getOldValue() != null ? (this.getOldValue() instanceof ObjectChangeAware ? this.getOldValue() != otherChange.getOldValue() : !this.getOldValue().equals(otherChange.getOldValue())) : otherChange.getOldValue() != null);
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        String text = "Change";
        text = text + "(";
        text = this.getAffectedObject() != null ? text + this.getAffectedObject().getClass().getName() + "(" + this.getAffectedObject().getCoObRAId() + ": " + this.getAffectedObject().toString() + ")" : text + "null";
        switch (this.getTypeOfChange()) {
            case 12: {
                String oldV = "" + this.getOldValue();
                String newV = "" + this.getNewValue();
                if (oldV.length() > 30) {
                    oldV = oldV.substring(0, 30) + "...";
                }
                if (newV.length() > 30) {
                    newV = newV.substring(0, 30) + "...";
                }
                text = text + "." + this.getFieldName() + (this.key != null ? "[" + this.key + "]" : "") + " from '" + oldV + "' to '" + newV + "'";
                break;
            }
            case 4: {
                text = text + "." + this.getFieldName() + (this.key != null ? "[" + this.key + "]" : "") + " add '" + this.getNewValue() + "'";
                break;
            }
            case 8: {
                text = text + "." + this.getFieldName() + (this.key != null ? "[" + this.key + "]" : "") + " remove '" + this.getOldValue() + "'";
                break;
            }
            case 1: {
                text = text + " added";
                break;
            }
            case 2: {
                text = text + " removed";
                break;
            }
            default: {
                text = text + " unknown change";
            }
        }
        return text + ")";
    }

    public void setAffectedObject(ObjectChangeAware affectedObject) {
        this.affectedObject = affectedObject;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public void setTypeOfChange(int typeOfChange) {
        this.typeOfChange = typeOfChange;
    }
}

