/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.coobra;

import de.tu_bs.coobra.ObjectChange;
import de.tu_bs.coobra.ObjectChangeAware;
import de.tu_bs.coobra.ObjectChangeAwareHelper;
import de.tu_bs.coobra.ObjectChangeCause;
import de.tu_bs.coobra.ObjectChangeUtils;
import de.tu_bs.coobra.ServerObjectChange;
import de.tu_bs.coobra.errors.ErrorHandlerAdapter;
import de.tu_bs.coobra.errors.ErrorHandlerInterface;
import de.tu_bs.coobra.errors.InterferingRepositoriesException;
import de.tu_bs.coobra.errors.NotConnectedException;
import de.tu_bs.coobra.errors.RemoteException;
import de.tu_bs.coobra.errors.ServerIdentifierChangedException;
import de.tu_bs.coobra.errors.SomeChangesFailedException;
import de.tu_bs.coobra.errors.UndoRedoException;
import de.tu_bs.coobra.remote.RemoteRepository;
import de.tu_bs.coobra.remote.errors.GeneralException;
import de.tu_bs.coobra.remote.lightweight.LightWeightServer;
import de.tu_bs.coobra.util.EmptyIterator;
import de.tu_bs.coobra.util.IteratorWORemove;
import de.tu_bs.xmlreflect.Link;
import de.tu_bs.xmlreflect.LinkFactory;
import de.tu_bs.xmlreflect.XMLReflect;
import de.tu_bs.xmlreflect.util.SAXHandlerStack;
import de.tu_bs.xmlreflect.util.errors.AccessorInvocationException;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.fca.FTreeSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.GZIPOutputStream;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.input.SAXHandler;
import org.jdom.output.XMLOutputter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LocalRepository {
    public static boolean IGNORE_CHANGES_TO_REMOVED_OBJECTS = false;
    private XMLOutputter xmlOutputter;
    private SAXHandlerStack handlerStack;
    private boolean containingFilteredServerChanges;
    private boolean wasContainingFilteredServerChanges;
    private UpdateFilter updateFilter;
    private SortedSet changesBase;
    private SortedSet changes;
    protected BigInteger nextSequenceNumber;
    private static final BigInteger MONE = BigInteger.ZERO.subtract(BigInteger.ONE);
    protected BigInteger nextObjectId;
    public static final String ID_PREFIX_LOCAL = "local#";
    public static final String ID_PREFIX_SERVER = "server#";
    public static final String ID_PREFIX_SINGLETON = "singleton#";
    Map knownIds;
    private LinkedList undone;
    Map undoredoCheckRepositories;
    private ClassLoader classLoader;
    private boolean restoring;
    ObjectChangeAware rootObject;
    public static final int UNDO_REDO_INIFITE = -1;
    public static final int UNDO_REDO_INIFITE_NOCHECK = -2;
    private RemoteRepository server;
    private String serverIdentifier;
    private BigInteger lastKnownServerSequenceNumber;
    private BigInteger lastReadServerSequenceNumber;
    private ObjectChangeCause UPDATE_CAUSE;
    private boolean inCheckin;
    private boolean writeProtected;
    public static final ObjectChangeCause CAUSE_WRITEPROTECTIONOVERRIDE = new ObjectChangeCause(true, null);
    private Set newObjectListeners;
    private static ErrorHandlerInterface errorHandler;
    private Writer immediateStore;
    private CoObRAsXMLReflect immediateStoreXR;
    static /* synthetic */ Class class$java$awt$Point;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$awt$Dimension;
    static /* synthetic */ Class class$java$awt$Rectangle;
    static /* synthetic */ Class class$de$tu_bs$coobra$ObjectChangeAware;
    static /* synthetic */ Class class$de$tu_bs$coobra$ObjectChangeCause;
    static /* synthetic */ Class class$de$tu_bs$coobra$LocalRepository;
    static /* synthetic */ Class class$de$tu_bs$coobra$ObjectChange;
    static /* synthetic */ Class class$de$tu_bs$xmlreflect$Link;

    protected XMLOutputter getXMLOutputter() {
        if (this.xmlOutputter == null) {
            this.xmlOutputter = new XMLOutputter();
            this.xmlOutputter.setEncoding("UTF-8");
            this.xmlOutputter.setNewlines(false);
            this.xmlOutputter.setIndent(null);
        }
        return this.xmlOutputter;
    }

    public boolean isContainingFilteredServerChanges() {
        return this.containingFilteredServerChanges;
    }

    public ObjectChange getLastChange(ObjectChangeAware object, String fieldName) {
        if (this.changes != null) {
            Iterator it = this.changes.iterator();
            while (it.hasNext()) {
                ObjectChange objectChange = (ObjectChange)it.next();
                if (object != objectChange.getAffectedObject() || fieldName != null && !fieldName.equals(objectChange.getFieldName())) continue;
                return objectChange;
            }
        }
        ObjectChange foundChange = null;
        if (this.changesBase != null) {
            Iterator it = this.changesBase.iterator();
            while (it.hasNext()) {
                ObjectChange objectChange = (ObjectChange)it.next();
                if (object != objectChange.getAffectedObject() || fieldName != null && !fieldName.equals(objectChange.getFieldName())) continue;
                foundChange = objectChange;
            }
        }
        return foundChange;
    }

    public UpdateFilter getUpdateFilter() {
        return this.updateFilter;
    }

    public void setUpdateFilter(UpdateFilter updateFilter) {
        this.updateFilter = updateFilter;
    }

    public LocalRepository() {
        this.changesBase = new TreeSet(ObjectChangeUtils.get().reverseComparator);
        this.nextSequenceNumber = BigInteger.ZERO;
        this.nextObjectId = BigInteger.ZERO;
        this.lastKnownServerSequenceNumber = BigInteger.ZERO.subtract(BigInteger.ONE);
        this.lastReadServerSequenceNumber = BigInteger.ZERO.subtract(BigInteger.ONE);
        this.UPDATE_CAUSE = new ObjectChangeCause(true, null);
        this.inCheckin = false;
    }

    protected BigInteger getNewSequenceNumber() {
        BigInteger result = this.nextSequenceNumber;
        this.nextSequenceNumber = this.nextSequenceNumber.add(BigInteger.ONE);
        return result;
    }

    public synchronized ObjectChange createObjectChange(ObjectChange change) {
        return new ObjectChange(change.getCause(), change.getAffectedObject(), change.getFieldName(), change.getTypeOfChange(), change.getOldValue(), change.getNewValue(), this.getNewSequenceNumber(), change.getKey());
    }

    public synchronized ObjectChange createObjectChange(ObjectChangeCause cause, ObjectChangeAware affectedObject, String fieldName, int typeOfChange, Object oldValue, Object newValue, Object key) {
        ObjectChangeAwareHelper.UndoRedoCause undoRedoCause;
        BigInteger sn;
        boolean isUndoRedo;
        boolean bl = isUndoRedo = ObjectChange.peekCause() != null && ObjectChange.peekCause().isUndoRedo();
        if (cause instanceof ObjectChange && !isUndoRedo && ((ObjectChange)cause).getSequenceNumber().compareTo(BigInteger.ZERO) < 0) {
            new InterferingRepositoriesException("Cannot generate persistent changes caused by transient ones!");
        }
        if (this.isWriteProtected() && !isUndoRedo) {
            String message = "The repository is write protected!";
            LocalRepository.getErrorHandler().handle(message);
            throw new RuntimeException(message);
        }
        BigInteger bigInteger = sn = isUndoRedo ? MONE : this.getNewSequenceNumber();
        if (isUndoRedo && typeOfChange == 1 && ObjectChange.peekCause() instanceof ObjectChangeAwareHelper.UndoRedoCause && (undoRedoCause = (ObjectChangeAwareHelper.UndoRedoCause)ObjectChange.peekCause()).getUndoneOrRedoneChange() != null && undoRedoCause.getUndoneOrRedoneChange().getTypeOfChange() != 1 && undoRedoCause.getUndoneOrRedoneChange().getTypeOfChange() != 2) {
            LocalRepository.getErrorHandler().handle(new RuntimeException("Creating an object in redo of another change - this may cause serious problems!"));
        }
        ObjectChange change = new ObjectChange(cause, affectedObject, fieldName, typeOfChange, oldValue, newValue, sn, key);
        return change;
    }

    public boolean addToChanges_internal(ObjectChange value) {
        if (this.changes == null) {
            this.changes = new TreeSet();
        }
        return this.changes.add(value);
    }

    public boolean addToChanges(ObjectChange value) {
        return this.addToChanges(value, false);
    }

    private boolean addToChanges(ObjectChange value, boolean isRedone) {
        if (!isRedone) {
            this.removeAllFromUndone();
        }
        if (value != null) {
            ObjectChangeAware object;
            String xml;
            if (this.getImmediateStore() != null && (xml = this.changeToXML(value, this.immediateStoreXR, false)) != null) {
                this.writeImmediate(xml);
                this.writeImmediate("\n");
            }
            boolean added = this.addToChanges_internal(value);
            if (value.getTypeOfChange() == 1 && (object = value.getAffectedObject()) != null && object.getRepository() == this) {
                Iterator it = this.iteratorOfNewObjectListeners();
                while (it.hasNext()) {
                    NewObjectListener listener = (NewObjectListener)it.next();
                    listener.newObjectNotify(object);
                }
            }
            return added;
        }
        return false;
    }

    public boolean removeFromChanges_internal(ObjectChange value) {
        if (this.changes != null) {
            return this.changes.remove(value);
        }
        return false;
    }

    public boolean removeFromChanges(ObjectChange value) {
        if (value != null) {
            this.writeImmediate("<remove number=\"" + value.getSequenceNumber() + "\"/>\n");
            return this.removeFromChanges_internal(value);
        }
        return false;
    }

    public Iterator iteratorOfChanges() {
        if (this.changes != null) {
            return new IteratorWORemove(this.changes.iterator());
        }
        return EmptyIterator.get();
    }

    private Iterator iteratorOfChangesWithRemove() {
        if (this.changes != null) {
            return this.changes.iterator();
        }
        return EmptyIterator.get();
    }

    public Iterator iteratorOfUndone() {
        if (this.undone != null) {
            return new IteratorWORemove(this.undone.iterator());
        }
        return EmptyIterator.get();
    }

    public Iterator iteratorOfChanges(BigInteger fromSeqNr) {
        if (fromSeqNr == null) {
            return this.iteratorOfChanges();
        }
        if (this.changes != null) {
            ObjectChange to = new ObjectChange(null, null, null, 0, null, null, fromSeqNr.subtract(BigInteger.ONE));
            ObjectChange from = new ObjectChange(null, null, null, 0, null, null, this.nextSequenceNumber.subtract(BigInteger.ONE));
            return new IteratorWORemove(this.changes.subSet(from, to).iterator());
        }
        return EmptyIterator.get();
    }

    public Iterator iteratorOfChangesBase() {
        if (this.changesBase != null) {
            return new IteratorWORemove(this.changesBase.iterator());
        }
        return EmptyIterator.get();
    }

    public ObjectChange getFirstFromChanges() {
        if (this.changes != null) {
            return this.changes.isEmpty() ? null : (ObjectChange)this.changes.first();
        }
        return null;
    }

    public static boolean isValid(LocalRepository repository, ObjectChangeAware forObject) {
        if (repository != null) {
            return forObject == null || forObject.getRepository() == repository;
        }
        return false;
    }

    public String getIdForObject(ObjectChangeAware value) {
        if (value.getCoObRAId() == null) {
            if (XMLReflect.getFromSingletons(value.getClass()) != null) {
                this.addToKnownIds(LocalRepository.getSingletonID(value.getClass()), value);
            } else if (this.inCheckin && this.server != null) {
                this.addToKnownIds(this.server.getNewObjectId(), value);
            } else {
                this.addToKnownIds(this.getNewObjectId(), value);
            }
        }
        return value.getCoObRAId();
    }

    protected String getNewObjectId() {
        String id = ID_PREFIX_LOCAL + this.nextObjectId;
        this.nextObjectId = this.nextObjectId.add(BigInteger.ONE);
        this.writeImmediate("<repository nextObjectId=\"" + this.nextObjectId.toString() + "\"/>\n");
        return id;
    }

    public Iterator iteratorOfKnownObjects() {
        return this.knownIds != null ? this.knownIds.values().iterator() : EmptyIterator.get();
    }

    public Iterator iteratorOfKnownIds() {
        return this.knownIds != null ? this.knownIds.keySet().iterator() : EmptyIterator.get();
    }

    public ObjectChangeAware getObjectFromId(String value) {
        if (value != null) {
            if (value.startsWith(ID_PREFIX_SINGLETON)) {
                String className = value.substring(ID_PREFIX_SINGLETON.length(), value.length());
                return (ObjectChangeAware)XMLReflect.getFromSingletons((Class)XMLReflect.getClassForStoredName((String)className, (ClassLoader)this.getClassLoader()));
            }
            if (this.knownIds != null) {
                ObjectChangeAware object = (ObjectChangeAware)this.knownIds.get(value);
                return object;
            }
        }
        return null;
    }

    public synchronized boolean addToKnownIds(String value, ObjectChangeAware object) {
        boolean changed = false;
        if (value != null) {
            if (this.knownIds == null) {
                this.knownIds = new HashMap();
            }
            if (LocalRepository.isValid(this, object) || value.startsWith(ID_PREFIX_SINGLETON)) {
                ObjectChangeAware oldValue = this.knownIds.put(value, object);
                if (oldValue instanceof Reference) {
                    oldValue = ((Reference)((Object)oldValue)).get();
                }
                if (oldValue != null && oldValue != object) {
                    LocalRepository.getErrorHandler().warn("id " + value + " was already assigned!");
                }
                boolean bl = changed = oldValue != object;
                if (changed && object != null) {
                    object.setCoObRAId(value);
                }
            } else {
                if (!IGNORE_CHANGES_TO_REMOVED_OBJECTS) {
                    throw new RuntimeException("Cannot use ids for objects that are not in this repository: " + object + "(" + object.getClass() + ")");
                }
                LocalRepository.getErrorHandler().info("Cannot use ids for objects that are not in this repository: " + object + "(" + object.getClass() + ")");
            }
        }
        return changed;
    }

    public boolean hasInKnownIds(String value) {
        return this.knownIds != null && this.knownIds.containsKey(value);
    }

    public synchronized boolean removeFromKnownIds(String value) {
        boolean changed = false;
        if (this.knownIds != null && value != null) {
            this.knownIds.remove(value);
        }
        return changed;
    }

    protected boolean addToUndone(ObjectChange change, boolean atBeginning) {
        if (change != null) {
            if (this.undone == null) {
                this.undone = new LinkedList();
            }
            if (atBeginning) {
                this.undone.add(0, change);
            } else {
                this.undone.add(change);
            }
            return true;
        }
        return false;
    }

    public ObjectChange getFirstFromUndone() {
        if (this.undone != null) {
            return this.undone.isEmpty() ? null : (ObjectChange)this.undone.get(0);
        }
        return null;
    }

    protected ObjectChange removeFirstFromUndone() {
        if (this.undone != null) {
            return this.undone.isEmpty() ? null : (ObjectChange)this.undone.remove(0);
        }
        return null;
    }

    private void addChangeAndConsequences(ObjectChangeCause cause, Set set) {
        if (cause != null) {
            if (cause instanceof ObjectChange) {
                set.add(cause);
            }
            Iterator it = cause.iteratorOfConsequences();
            while (it.hasNext()) {
                this.addChangeAndConsequences((ObjectChangeCause)it.next(), set);
            }
        }
    }

    private Set getAllDependentChanges(ObjectChange change) {
        ObjectChangeCause cause = change;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        FTreeSet dependentChanges = new FTreeSet();
        dependentChanges.add(change);
        this.addChangeAndConsequences(cause, (Set)dependentChanges);
        return dependentChanges;
    }

    public synchronized void undo(ObjectChangeCause cause) throws UndoRedoException {
        if (cause.getCause() != null) {
            System.err.println("cause is not top level - more changes will be undone!");
        }
        ObjectChangeCause firstChange = cause;
        if ((firstChange = this.findFirstChangeOf(firstChange)) != null) {
            if (this.changes.contains(firstChange)) {
                do {
                    this.undo(1);
                } while (this.changes.contains(firstChange));
            } else {
                throw new UndoRedoException("changes in the cause are already undone or do not belong to this repository", false, null);
            }
        }
    }

    public synchronized void redo(ObjectChangeCause cause) throws UndoRedoException {
        if (cause.getCause() != null) {
            System.err.println("cause is not top level - more changes will be undone!");
        }
        ObjectChangeCause firstChange = cause;
        if ((firstChange = this.findFirstChangeOf(firstChange)) != null) {
            if (this.undone.contains(firstChange)) {
                do {
                    this.redo(1);
                } while (this.undone.contains(firstChange));
            } else {
                throw new UndoRedoException("changes in the cause are already redone or do not belong to this repository", false, null);
            }
        }
    }

    private ObjectChangeCause findFirstChangeOf(ObjectChangeCause firstChange) {
        while (!(firstChange instanceof ObjectChange)) {
            Iterator it = firstChange.iteratorOfConsequences();
            if (it.hasNext()) {
                firstChange = (ObjectChangeCause)it.next();
                continue;
            }
            firstChange = null;
            break;
        }
        return firstChange;
    }

    public synchronized void undo(int numberOfChunks) {
        while ((numberOfChunks > 0 || numberOfChunks < 0) && this.getFirstFromChanges() != null) {
            ObjectChange change = this.getFirstFromChanges();
            Set dependentChanges = this.getAllDependentChanges(change);
            Iterator it = dependentChanges.iterator();
            while (it.hasNext()) {
                change = (ObjectChange)it.next();
                if (change.getSequenceNumber().compareTo(BigInteger.ZERO) < 0 || !this.removeFromChanges(change) || change.getAffectedObject() == null || change.hadKey() || change.hadOldValue()) continue;
                ObjectChangeAwareHelper.undo(change, this);
                if (this.addToUndone(change, true)) continue;
                new UndoRedoException("The " + change + " was undone, but was already contained in the undone list" + " - application data is corrupted!", true, change).printStackTrace();
            }
            if (numberOfChunks <= 0) continue;
            --numberOfChunks;
        }
    }

    public void clearCheckData() {
        if (this.undoredoCheckRepositories != null) {
            this.undoredoCheckRepositories.clear();
        }
    }

    protected void redo(ObjectChange change, boolean checkOnly) {
        if (change.getAffectedObject() != null && !change.hadKey() && !change.hadNewValue()) {
            ObjectChangeAwareHelper.redo(change, checkOnly, this);
        }
    }

    protected synchronized void redo(int numberOfChunks, boolean newSequenceNumbers, Map failedChanges) {
        while ((numberOfChunks > 0 || numberOfChunks < 0) && this.getFirstFromUndone() != null) {
            Object[] dependentChanges;
            ObjectChange change = this.getFirstFromUndone();
            if (numberOfChunks > 0) {
                Set dependentChangesSet = this.getAllDependentChanges(change);
                dependentChanges = dependentChangesSet.toArray();
            } else {
                dependentChanges = new Object[]{change};
            }
            boolean alreadyApplying = false;
            try {
                int checkOnly;
                boolean checkFirst = numberOfChunks == -1;
                int n = checkOnly = checkFirst ? 1 : 0;
                while (checkOnly >= 0) {
                    for (int i = dependentChanges.length - 1; i >= 0; --i) {
                        change = (ObjectChange)dependentChanges[i];
                        if (change.getSequenceNumber().compareTo(BigInteger.ZERO) < 0) continue;
                        if (this.getFirstFromUndone() != change) {
                            LocalRepository.getErrorHandler().warn("undo of " + change + " ignored (was not on top of the undone list)");
                            continue;
                        }
                        if (checkOnly == 0) {
                            alreadyApplying = true;
                        }
                        try {
                            ObjectChangeAwareHelper.redo(change, checkOnly == 1, this);
                        }
                        catch (UndoRedoException e) {
                            if (failedChanges == null) {
                                LocalRepository.getErrorHandler().handle(e);
                            }
                            throw e;
                        }
                        if (checkOnly != 0) continue;
                        ObjectChange removed = this.removeFirstFromUndone();
                        if (removed != change) {
                            new UndoRedoException("The " + change + " was redone, but was not on top of the undone list" + " - application data is corrupted! (found: " + null + ")", true, change).printStackTrace();
                        }
                        if (change.getAffectedObject().getRepository() == this) {
                            if (newSequenceNumbers) {
                                ObjectChange oldChange = change;
                                change = this.createObjectChange(change);
                                oldChange.removeYou();
                            }
                            if (this.addToChanges(change, true)) continue;
                            new UndoRedoException("The " + change + " was redone, but was already contained in the " + "changes list - application data is corrupted!", true, change).printStackTrace();
                            continue;
                        }
                        change.removeYou();
                    }
                    this.clearCheckData();
                    --checkOnly;
                }
            }
            catch (UndoRedoException e) {
                if (alreadyApplying || e.isDataModified() || failedChanges == null) {
                    LocalRepository.getErrorHandler().handle(e);
                    this.removeFirstFromUndone();
                }
                for (int i = dependentChanges.length - 1; i >= 0; --i) {
                    failedChanges.put(dependentChanges[i], e);
                    ObjectChange removed = this.removeFirstFromUndone();
                    if (removed != change) {
                        new UndoRedoException("The " + change + " should be redone, but was not on top of the undone list - application data is corrupted!" + " (was: " + removed + ")", true, change).printStackTrace();
                    }
                    removed.removeYou();
                }
            }
            if (numberOfChunks <= 0) continue;
            --numberOfChunks;
        }
    }

    public synchronized void redo(int numberOfChunks) {
        if (numberOfChunks < 0) {
            numberOfChunks = -2;
        }
        this.redo(numberOfChunks, false, null);
    }

    public void store(String fileName) throws FileNotFoundException, IOException {
        this.store(fileName, false);
    }

    public void store(String fileName, boolean gzipped) throws FileNotFoundException, IOException {
        OutputStream outstream = new FileOutputStream(fileName);
        if (gzipped) {
            outstream = new GZIPOutputStream(outstream);
        }
        BufferedOutputStream fout = new BufferedOutputStream(outstream);
        this.store(fout);
        fout.close();
    }

    protected void changesToXML(Writer writer, Iterator iteratorOfChanges, CoObRAsXMLReflect xmlReflectForValues, boolean omitCauses, ProgressHandler handler) throws IOException {
        FTreeSet set = new FTreeSet(ObjectChangeUtils.get().reverseComparator);
        while (iteratorOfChanges.hasNext()) {
            set.add(iteratorOfChanges.next());
        }
        iteratorOfChanges = set.iterator();
        while (iteratorOfChanges.hasNext()) {
            ObjectChange change = (ObjectChange)iteratorOfChanges.next();
            String xml = this.changeToXML(change, xmlReflectForValues, omitCauses);
            if (handler != null) {
                handler.processedChange();
            }
            if (xml == null) continue;
            writer.write(xml);
            writer.write("\n");
        }
    }

    protected String changeToXML(ObjectChange change, CoObRAsXMLReflect xmlReflectForValues, boolean omitCauses) {
        if (change.getAffectedObject() != null) {
            Element valueXml;
            String id;
            Element xml = new Element("change");
            xml.setAttribute("number", change.getSequenceNumber().toString());
            if (change.getTimestamp() != 0L) {
                xml.setAttribute("timestamp", String.valueOf(change.getTimestamp()));
            }
            if ((id = this.getIdForObject(change.getAffectedObject())) == null) {
                return "";
            }
            xml.setAttribute("object", id);
            if (change.getAffectedObject() == this.getRootObject()) {
                xml.setAttribute("root", "1");
            }
            if (this.getIdForObject(change.getAffectedObject()) == null) {
                return null;
            }
            if (this.inCheckin && id.startsWith(ID_PREFIX_LOCAL) && (this.knownIds == null || this.knownIds.get(id) == null)) {
                System.err.println("unknown id: " + id + " - change omitted: " + change);
                return null;
            }
            if (!omitCauses && change.getCause() != null) {
                Element causeXml;
                if (change.getCause() instanceof ObjectChange) {
                    causeXml = new Element("cause");
                    causeXml.setAttribute("change", "" + ((ObjectChange)change.getCause()).getSequenceNumber());
                } else {
                    causeXml = xmlReflectForValues.reflectField("cause", change.getCause(), Object.class, null, -1);
                }
                xml.addContent(causeXml);
            }
            if (change.getFieldName() != null) {
                xml.setAttribute("field", change.getFieldName());
            }
            if (change.getKey() != null) {
                if (change.getKey() instanceof ObjectChangeAware) {
                    valueXml = new Element("key");
                    String keyId = this.getIdForObject((ObjectChangeAware)change.getKey());
                    if (keyId != null) {
                        valueXml.setAttribute("object", keyId);
                    }
                } else {
                    valueXml = xmlReflectForValues.reflectField("key", change.getKey(), Object.class, null, -1);
                }
                xml.addContent(valueXml);
            }
            if (change.getNewValue() != null) {
                if (change.getNewValue() instanceof ObjectChangeAware) {
                    valueXml = new Element("newValue");
                    String newValueId = this.getIdForObject((ObjectChangeAware)change.getNewValue());
                    if (newValueId != null) {
                        if (this.inCheckin && newValueId.startsWith(ID_PREFIX_LOCAL) && (this.knownIds == null || this.knownIds.get(newValueId) == null)) {
                            System.err.println("unknown id: " + newValueId + " - change omitted: " + change);
                            return null;
                        }
                        valueXml.setAttribute("object", newValueId);
                    }
                } else {
                    valueXml = xmlReflectForValues.reflectField("newValue", change.getNewValue(), Object.class, null, -1);
                }
                xml.addContent(valueXml);
            }
            if (change.getOldValue() != null) {
                if (change.getOldValue() instanceof ObjectChangeAware) {
                    valueXml = new Element("oldValue");
                    String oldValueId = this.getIdForObject((ObjectChangeAware)change.getOldValue());
                    if (oldValueId != null) {
                        if (this.inCheckin && oldValueId.startsWith(ID_PREFIX_LOCAL) && (this.knownIds == null || this.knownIds.get(oldValueId) == null)) {
                            System.err.println("unknown id: " + oldValueId + " - change omitted: " + change);
                            return null;
                        }
                        valueXml.setAttribute("object", oldValueId);
                    }
                } else {
                    valueXml = xmlReflectForValues.reflectField("oldValue", change.getOldValue(), Object.class, null, -1);
                }
                xml.addContent(valueXml);
            }
            if (change.getTypeOfChange() != 0) {
                xml.setAttribute("type", "" + change.getTypeOfChange());
            }
            String xmlString = this.getXMLOutputter().outputString(xml);
            return xmlString;
        }
        return null;
    }

    public String escapeNewLineCharacters(String str) {
        StringBuffer buffer = null;
        for (int i = 0; i < str.length(); ++i) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '\n': {
                    entity = "&#10;&#13;";
                    break;
                }
                default: {
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuffer(str.length() + 20);
                buffer.append(str.substring(0, i));
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    public void store(OutputStream stream) throws IOException {
        this.store(stream, false);
    }

    protected Writer makeWriter(OutputStream out) throws UnsupportedEncodingException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), "UTF-8"));
        return writer;
    }

    public void store(OutputStream stream, boolean immediateMode) throws IOException {
        this.store(stream, immediateMode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(OutputStream stream, boolean immediateMode, ProgressCallback progressCallback) throws IOException {
        ProgressHandler progressHandler;
        int totalChanges = (this.changesBase == null ? 0 : this.changesBase.size()) + (this.changes == null ? 0 : this.changes.size());
        ProgressHandler progressHandler2 = progressHandler = progressCallback == null ? null : new ProgressHandler(progressCallback, totalChanges);
        if (!immediateMode) {
            CoObRAsXMLReflect xr = new CoObRAsXMLReflect();
            Writer writer = this.makeWriter(stream);
            writer.write("<repository ");
            if (this.getServerIdentifier() != null) {
                writer.write(" server=\"" + this.getServerIdentifier() + "\"");
            }
            if (this.lastKnownServerSequenceNumber != null) {
                writer.write(" lastKnownServerSequenceNumber=\"" + this.lastKnownServerSequenceNumber + "\"");
            }
            writer.write(" nextSequenceNumber=\"" + this.nextSequenceNumber + "\"");
            writer.write(">");
            ObjectChange.pushCause(ObjectChangeAwareHelper.CAUSE_UNDOREDO);
            try {
                writer.write("<base last=\"" + this.nextSequenceNumber.subtract(BigInteger.ONE) + "\">\n");
                this.changesToXML(writer, this.iteratorOfChangesBase(), xr, false, progressHandler);
                writer.write("</base>\n");
                writer.write("<changes last=\"" + this.nextSequenceNumber.subtract(BigInteger.ONE) + "\">\n");
                this.changesToXML(writer, this.iteratorOfChanges(), xr, false, progressHandler);
                writer.write("<repository nextObjectId=\"" + this.nextObjectId + "\"/>");
                writer.write("</changes>\n");
                xr.removeYou();
            }
            finally {
                ObjectChange.popCause(ObjectChangeAwareHelper.CAUSE_UNDOREDO);
            }
            writer.write("</repository>");
            writer.close();
        } else {
            this.setImmediateStore(this.makeWriter(stream));
            this.immediateStoreXR = new CoObRAsXMLReflect();
            this.getImmediateStore().write("<repository");
            if (this.getServerIdentifier() != null) {
                this.getImmediateStore().write(" server=\"" + this.getServerIdentifier() + "\"");
            }
            this.getImmediateStore().write(">");
            ObjectChange.pushCause(ObjectChangeAwareHelper.CAUSE_UNDOREDO);
            try {
                this.getImmediateStore().write("<base>");
                this.changesToXML(this.getImmediateStore(), this.iteratorOfChangesBase(), this.immediateStoreXR, true, progressHandler);
                this.getImmediateStore().write("</base>");
                this.getImmediateStore().write("<changes>");
                this.changesToXML(this.getImmediateStore(), this.iteratorOfChanges(), this.immediateStoreXR, false, progressHandler);
            }
            finally {
                ObjectChange.popCause(ObjectChangeAwareHelper.CAUSE_UNDOREDO);
            }
            if (this.lastKnownServerSequenceNumber != null) {
                this.getImmediateStore().write("<repository lastKnownServerSequenceNumber=\"" + this.lastKnownServerSequenceNumber.toString() + "\"/>");
            }
            this.getImmediateStore().write("<repository nextObjectId=\"" + this.nextObjectId.toString() + "\"/>");
        }
    }

    public LocalRepository(String fileName) throws FileNotFoundException, IOException, JDOMException {
        this(new BufferedInputStream(new FileInputStream(fileName)));
    }

    protected ObjectChangeAware createObjectInstance(Class objectClass, String id, CoObRAsXMLReflect xmlReflectForValues) {
        try {
            return (ObjectChangeAware)xmlReflectForValues.createObjectInstance(objectClass);
        }
        catch (Exception e) {
            LocalRepository.getErrorHandler().handle((RuntimeException)new AccessorInvocationException("Failed to create object!", (Throwable)e));
            return null;
        }
    }

    protected BigInteger getSequenceNumberForStoredChange(String numberString) {
        BigInteger number;
        if (ObjectChange.peekCause() == this.UPDATE_CAUSE) {
            BigInteger number2;
            if (numberString != null && this.lastReadServerSequenceNumber.compareTo(number2 = new BigInteger(numberString)) < 0) {
                this.lastReadServerSequenceNumber = number2;
            }
            number2 = this.getNewSequenceNumber();
            return number2;
        }
        BigInteger bigInteger = number = numberString != null ? new BigInteger(numberString) : null;
        if (number != null && number.compareTo(this.nextSequenceNumber) > 0) {
            this.nextSequenceNumber = number.add(BigInteger.ONE);
        }
        return number;
    }

    protected ObjectChangeCause getCauseForStoredChange(Element causeXml, CoObRAsXMLReflect xmlReflectForValues) {
        if (causeXml != null) {
            String causeString = causeXml.getAttributeValue("change");
            if (causeString != null) {
                return (ObjectChangeCause)xmlReflectForValues.getLinkFactory().getLinkTo(causeString, null).getTarget();
            }
            Object value = xmlReflectForValues.reflectXMLField(causeXml, Object.class, null);
            xmlReflectForValues.clear(false);
            return (ObjectChangeCause)value;
        }
        return null;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isRestoring() {
        return this.restoring;
    }

    public LocalRepository(InputStream stream) throws IOException, JDOMException {
        this();
        this.restore(stream);
    }

    public void restore(InputStream stream) throws IOException, JDOMException {
        this.restore(stream, false);
    }

    public static XMLReader createXMLReader() {
        try {
            return new MySAXBuilder().createParser();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectChangeAware getRootObject() {
        return this.rootObject;
    }

    public void setRootObject(ObjectChangeAware rootObject) {
        if (this.rootObject != rootObject) {
            this.rootObject = rootObject;
        }
    }

    public void restore(InputStream stream, boolean immediateMode) throws IOException, JDOMException {
        this.restore(stream, immediateMode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(InputStream stream, boolean immediateMode, ProgressCallback callback) throws IOException, JDOMException {
        this.restoring = true;
        try {
            if (immediateMode) {
                byte[] endTag = "</changes></repository>".getBytes();
                ByteArrayInputStream endStream = new ByteArrayInputStream(endTag);
                stream = new SequenceInputStream(stream, endStream);
            }
            XMLReader xmlReader = LocalRepository.createXMLReader();
            this.handlerStack = new SAXHandlerStack();
            xmlReader.setContentHandler((ContentHandler)this.handlerStack);
            xmlReader.setErrorHandler((ErrorHandler)this.handlerStack);
            xmlReader.setEntityResolver((EntityResolver)this.handlerStack);
            this.handlerStack.setHandlerForNextElements((DefaultHandler)new SAXHandlerRepository(callback));
            ObjectChange.pushCause(ObjectChangeAwareHelper.CAUSE_UNDOREDO);
            try {
                xmlReader.parse(new InputSource(new InputStreamReader(stream, "UTF-8")));
            }
            finally {
                ObjectChange.popCause(ObjectChangeAwareHelper.CAUSE_UNDOREDO);
            }
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.restoring = false;
            this.handlerStack = null;
        }
    }

    private synchronized void completeRedo(ProgressCallback callback) {
        Iterator it;
        int totalChanges = (this.changesBase != null ? this.changesBase.size() : 0) + (this.changes != null ? this.changes.size() : 0);
        int processedChanges = 0;
        if (this.changesBase != null) {
            it = this.changesBase.iterator();
            while (it.hasNext()) {
                try {
                    ObjectChangeAwareHelper.redo((ObjectChange)it.next(), false, this);
                    this.progress(callback, 50 + ++processedChanges * 50 / totalChanges);
                }
                catch (UndoRedoException e) {
                    LocalRepository.getErrorHandler().handle(e);
                }
            }
        }
        if (this.changes != null) {
            if (this.undone != null) {
                this.undone.clear();
            } else {
                this.undone = new LinkedList();
            }
            it = this.changes.iterator();
            while (it.hasNext()) {
                try {
                    this.undone.addFirst(it.next());
                }
                catch (UndoRedoException e) {
                    LocalRepository.getErrorHandler().handle(e);
                }
            }
            it = this.undone.iterator();
            while (it.hasNext()) {
                try {
                    ObjectChangeAwareHelper.redo((ObjectChange)it.next(), false, this);
                    this.progress(callback, 50 + ++processedChanges * 50 / totalChanges);
                }
                catch (UndoRedoException e) {
                    LocalRepository.getErrorHandler().handle(e);
                }
            }
            this.undone.clear();
        }
    }

    public void removeYou() {
        this.disconnect();
        this.setWriteProtected(false);
        this.removeAllFromChanges();
        this.removeAllFromUndone();
        this.removeAllFromChangesBase();
        this.removeAllFromKnownIds();
    }

    private void removeAllFromKnownIds() {
        if (this.knownIds != null) {
            this.knownIds.clear();
        }
    }

    private void removeAllFromChangesBase() {
        if (this.changesBase != null) {
            this.changesBase.clear();
        }
    }

    void removeAllFromUndone() {
        if (this.undone != null) {
            this.undone.clear();
        }
    }

    private void removeAllFromChanges() {
        if (this.changes != null) {
            this.changes.clear();
        }
    }

    public void compact() {
        ObjectChangeUtils.get().compact(this.changes);
        ObjectChangeUtils.get().compact(this.changesBase);
    }

    public void moveChangesIntoChangesBase() {
        Iterator it = this.iteratorOfChangesWithRemove();
        while (it.hasNext()) {
            ObjectChange change = (ObjectChange)it.next();
            it.remove();
            this.changesBase.add(change);
        }
    }

    public void moveChangesBaseIntoChanges() {
        Iterator it = this.iteratorOfChangesBase();
        while (it.hasNext()) {
            ObjectChange change = (ObjectChange)it.next();
            this.addToChanges_internal(change);
            this.changesBase.remove(change);
        }
    }

    public String getServerIdentifier() {
        return this.serverIdentifier;
    }

    public synchronized void connect(RemoteRepository server) throws ServerIdentifierChangedException {
        this.disconnect();
        String serverIdentifier = server.getServerIdentifier();
        if (this.serverIdentifier != null && !serverIdentifier.equals(this.serverIdentifier)) {
            LocalRepository.getErrorHandler().handle(new ServerIdentifierChangedException("Received: " + serverIdentifier + " Expected: " + this.serverIdentifier));
        }
        this.server = server;
        if (this.getUpdateFilter() == null || !this.getUpdateFilter().isPatch()) {
            this.serverIdentifier = serverIdentifier;
        }
    }

    public synchronized void disconnect() {
        this.server = null;
    }

    public void update() throws NotConnectedException, SomeChangesFailedException {
        this.update(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ProgressCallback callback) throws NotConnectedException, SomeChangesFailedException {
        try {
            this.progress(callback, 0);
            if (!this.inCheckin) {
                LocalRepository localRepository = this;
                synchronized (localRepository) {
                    block41: {
                        if (this.server != null) {
                            this.containingFilteredServerChanges = false;
                            ObjectChange.pushCause(this.UPDATE_CAUSE);
                            try {
                                Iterator<Object> it;
                                boolean isPatch;
                                String changesString;
                                InputSource inputSource;
                                if (this.server.getServerRepository() instanceof LightWeightServer) {
                                    try {
                                        inputSource = new InputSource(((LightWeightServer)this.server.getServerRepository()).updateAsReader(this.lastKnownServerSequenceNumber.toString()));
                                    }
                                    catch (GeneralException e) {
                                        throw new RemoteException((Throwable)((Object)e), false);
                                    }
                                }
                                try {
                                    changesString = this.server.update(this.lastKnownServerSequenceNumber.toString());
                                }
                                catch (GeneralException e) {
                                    throw new RemoteException((Throwable)((Object)e), false);
                                }
                                inputSource = new InputSource(new StringReader(changesString));
                                this.lastReadServerSequenceNumber = this.lastKnownServerSequenceNumber;
                                XMLReader xmlReader = LocalRepository.createXMLReader();
                                this.handlerStack = new SAXHandlerStack();
                                xmlReader.setContentHandler((ContentHandler)this.handlerStack);
                                xmlReader.setErrorHandler((ErrorHandler)this.handlerStack);
                                xmlReader.setEntityResolver((EntityResolver)this.handlerStack);
                                LinkedList serverChanges = new LinkedList();
                                this.handlerStack.setHandlerForNextElements((DefaultHandler)new SAXHandlerChanges(serverChanges, new CoObRAsXMLReflect(), callback));
                                ObjectChange.pushCause(this.UPDATE_CAUSE);
                                try {
                                    xmlReader.parse(inputSource);
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                                catch (SAXException e) {
                                    throw new RuntimeException(e);
                                }
                                finally {
                                    ObjectChange.popCause(this.UPDATE_CAUSE);
                                }
                                System.gc();
                                if (this.getUpdateFilter() != null) {
                                    if (this.getUpdateFilter().receivedChanges(new IteratorWORemove(serverChanges.iterator()))) {
                                        isPatch = this.getUpdateFilter().isPatch();
                                        it = serverChanges.iterator();
                                        while (it.hasNext()) {
                                            ServerObjectChange change = (ServerObjectChange)it.next();
                                            if (!this.getUpdateFilter().accept(change)) {
                                                it.remove();
                                                if (isPatch) continue;
                                                this.containingFilteredServerChanges = true;
                                                this.wasContainingFilteredServerChanges = true;
                                                continue;
                                            }
                                            this.lastReadServerSequenceNumber = change.getServerSequenceNumber();
                                        }
                                    } else {
                                        isPatch = false;
                                    }
                                } else {
                                    isPatch = false;
                                }
                                if (!isPatch) {
                                    this.lastKnownServerSequenceNumber = this.lastReadServerSequenceNumber;
                                }
                                this.writeImmediate("<repository lastKnownServerSequenceNumber=\"" + this.lastKnownServerSequenceNumber.toString() + "\"/>\n");
                                this.undone = null;
                                this.undo(-1);
                                it = serverChanges.iterator();
                                int changeCount = 0;
                                while (it.hasNext()) {
                                    ObjectChange change = (ObjectChange)it.next();
                                    try {
                                        ObjectChangeAwareHelper.redo(change, false, this);
                                        this.progress(callback, 50 + ++changeCount * 50 / serverChanges.size());
                                    }
                                    catch (UndoRedoException e) {
                                        if (e.getCause() instanceof IllegalArgumentException) {
                                            LocalRepository.getErrorHandler().handle("new value discarded due to IllegalArgumentException: " + e.getCause().getMessage());
                                        }
                                        LocalRepository.getErrorHandler().handle(e);
                                    }
                                    if (!isPatch) {
                                        this.changesBase.add(change);
                                        continue;
                                    }
                                    this.addToChanges_internal(change);
                                }
                                TreeMap failedChanges = new TreeMap();
                                System.gc();
                                try {
                                    this.redo(-1, true, failedChanges);
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                    throw new RuntimeException(e);
                                }
                                if (!failedChanges.isEmpty()) {
                                    StringBuffer message = new StringBuffer("failed changes after update:");
                                    int count = 0;
                                    it = failedChanges.keySet().iterator();
                                    while (it.hasNext()) {
                                        ObjectChange change = (ObjectChange)it.next();
                                        message.append("\nfailed:").append(change);
                                        Object reason = failedChanges.get(change);
                                        if (reason != null) {
                                            message.append("\nreason:").append(reason);
                                        }
                                        if (++count <= 500) continue;
                                        message.append("\n ... more ...");
                                        break;
                                    }
                                    throw new SomeChangesFailedException(message.toString(), failedChanges);
                                }
                                break block41;
                            }
                            finally {
                                ObjectChange.popCause(this.UPDATE_CAUSE);
                            }
                        }
                        throw new NotConnectedException();
                    }
                }
            }
            if (callback != null) {
                callback.progress(100);
            }
        }
        catch (IOException e) {
            this.disconnect();
            this.progress(callback, 0);
            throw new NotConnectedException(e);
        }
        catch (RuntimeException e) {
            this.progress(callback, 0);
            throw e;
        }
    }

    private void progress(ProgressCallback callback, int progress) {
        if (callback != null) {
            try {
                callback.progress(progress);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void writeImmediate(String string) {
        if (this.getImmediateStore() != null) {
            try {
                this.getImmediateStore().write(string);
            }
            catch (IOException e) {
                try {
                    LocalRepository.getErrorHandler().handle(e);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    System.err.println("unhandled error while storing in immediate mode - store disabled!");
                    this.setImmediateStore(null);
                }
            }
        }
    }

    private void replaceId(String currentId, String newId) {
        ObjectChangeAware obj = this.getObjectFromId(currentId);
        if (LocalRepository.isValid(this, obj)) {
            this.knownIds.remove(currentId);
            this.knownIds.put(newId, obj);
            obj.setCoObRAId(newId);
        } else {
            if (!IGNORE_CHANGES_TO_REMOVED_OBJECTS) {
                throw new RuntimeException("Cannot use ids for objects that are not in this repository: " + obj + "(" + obj.getClass() + ")");
            }
            LocalRepository.getErrorHandler().handle("Cannot use ids for objects that are not in this repository: " + obj + "(" + obj.getClass() + ")");
        }
    }

    public void checkin() throws NotConnectedException {
        this.checkin(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void checkin(ProgressCallback callback) throws NotConnectedException {
        this.inCheckin = true;
        try {
            try {
                String result;
                if (this.server == null) throw new NotConnectedException();
                if (this.knownIds != null) {
                    String id;
                    LinkedList<String> idsToBeReplaced = new LinkedList<String>();
                    Iterator<Object> ids = this.knownIds.keySet().iterator();
                    while (ids.hasNext()) {
                        id = (String)ids.next();
                        if (!id.startsWith(ID_PREFIX_LOCAL)) continue;
                        idsToBeReplaced.add(id);
                    }
                    ids = idsToBeReplaced.iterator();
                    while (ids.hasNext()) {
                        id = (String)ids.next();
                        this.replaceId(id, this.server.getNewObjectId());
                    }
                }
                CoObRAsXMLReflect xr = new CoObRAsXMLReflect();
                CharArrayWriter writer = new CharArrayWriter();
                try {
                    writer.write("<changes>");
                    if (this.lastKnownServerSequenceNumber.compareTo(BigInteger.ZERO) < 0) {
                        TreeSet base = new TreeSet(this.changesBase);
                        ProgressHandler handler = callback == null ? null : new ProgressHandler(callback, base.size() + (this.changes == null ? 0 : this.changes.size()));
                        this.changesToXML(writer, base.iterator(), xr, false, handler);
                        this.changesToXML(writer, this.iteratorOfChanges(), xr, false, handler);
                    } else {
                        if (!this.iteratorOfChanges().hasNext()) {
                            return;
                        }
                        ProgressHandler handler = callback == null ? null : new ProgressHandler(callback, this.changes.size());
                        this.changesToXML(writer, this.iteratorOfChanges(), xr, false, handler);
                    }
                    writer.write("</changes>");
                    writer.close();
                    xr.removeYou();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                String changesString = writer.toString();
                try {
                    result = this.server.checkin(changesString, this.lastKnownServerSequenceNumber.toString());
                }
                catch (GeneralException e) {
                    throw new RemoteException((Throwable)((Object)e), false);
                }
                if (result == null) return;
                this.lastKnownServerSequenceNumber = new BigInteger(result);
                this.writeImmediate("<repository lastKnownServerSequenceNumber=\"" + this.lastKnownServerSequenceNumber.toString() + "\" checkin=\"1\"/>\n");
                this.moveChangesIntoChangesBase();
                return;
            }
            finally {
                this.inCheckin = false;
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw new NotConnectedException(e);
        }
    }

    public boolean isConnected() {
        return this.server != null;
    }

    public RemoteRepository getRemoteRepository() {
        return this.server;
    }

    public boolean isRedoPossible() {
        return this.undone != null && !this.undone.isEmpty();
    }

    public boolean isUndoPossible() {
        return this.changes != null && !this.changes.isEmpty();
    }

    public boolean isWriteProtected() {
        return this.writeProtected;
    }

    public void setWriteProtected(boolean writeProtected) {
        this.writeProtected = writeProtected;
    }

    public void addToNewObjectListeners(NewObjectListener listener) {
        if (this.newObjectListeners == null) {
            this.newObjectListeners = new FHashSet();
        }
        this.newObjectListeners.add(listener);
    }

    public void removeFromNewObjectListeners(NewObjectListener listener) {
        if (this.newObjectListeners != null) {
            this.newObjectListeners.remove(listener);
        }
    }

    public Iterator iteratorOfNewObjectListeners() {
        return this.newObjectListeners == null ? FEmptyIterator.get() : this.newObjectListeners.iterator();
    }

    public void addToKnownObjects(ObjectChangeAware object) {
    }

    public void removeFromKnownObjects(ObjectChangeAware object) {
    }

    public boolean isServerRepository() {
        return false;
    }

    public static String getSingletonID(Class singletonClass) {
        return ID_PREFIX_SINGLETON + singletonClass.getName();
    }

    public static ErrorHandlerInterface getErrorHandler() {
        if (errorHandler == null) {
            errorHandler = new ErrorHandlerAdapter();
        }
        return errorHandler;
    }

    public static void setErrorHandler(ErrorHandlerInterface errorHandler) {
        LocalRepository.errorHandler = errorHandler;
    }

    public boolean isEmpty() {
        if (this.changes != null && !this.changes.isEmpty()) {
            return false;
        }
        if (this.changesBase != null && !this.changesBase.isEmpty()) {
            return false;
        }
        return this.undone == null || this.undone.isEmpty();
    }

    public void rollBackServer() {
        if (this.isConnected()) {
            try {
                this.server.rollback(this.lastKnownServerSequenceNumber.toString());
            }
            catch (GeneralException e) {
                throw new RuntimeException(e.getMessage(), (Throwable)((Object)e));
            }
        }
    }

    private Writer getImmediateStore() {
        return this.immediateStore;
    }

    private void setImmediateStore(Writer immediateStore) {
        this.immediateStore = immediateStore;
    }

    public int sizeOfKnownObjects() {
        return this.knownIds == null ? 0 : this.knownIds.size();
    }

    public void showStats() {
        TreeMap objectCountByType = new TreeMap();
        int total = 0;
        Iterator it = this.iteratorOfKnownObjects();
        while (it.hasNext()) {
            Object obj = it.next();
            String className = obj.getClass().getName();
            this.count(objectCountByType, className);
            ++total;
        }
        it = objectCountByType.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String classname = (String)entry.getKey();
            if (classname.startsWith("*")) continue;
            Integer nullCount = (Integer)objectCountByType.get("*" + classname);
            System.out.println(entry.getValue() + "\twhere\t" + (nullCount != null ? nullCount : 0) + "\tfloating\t" + classname);
        }
        System.out.println(total + " objects total");
        System.out.println(objectCountByType.size() + " classes total");
    }

    private void count(Map objectCountByType, String className) {
        Integer count = (Integer)objectCountByType.get(className);
        if (count == null) {
            count = new Integer(0);
        }
        objectCountByType.put(className, new Integer(count + 1));
    }

    public static interface NewObjectListener {
        public void newObjectNotify(ObjectChangeAware var1);
    }

    protected static class ProgressHandler {
        private final int total;
        private int done;
        private int lastPercentage;
        private final ProgressCallback callback;

        public ProgressHandler(ProgressCallback callback, int total) {
            this.callback = callback;
            this.total = total;
        }

        public ProgressHandler(ProgressCallback callback, int total, int done) {
            this(callback, total);
            this.done = done;
            this.lastPercentage = this.calculatePercentage();
        }

        private int calculatePercentage() {
            return this.done * 100 / this.total;
        }

        public void processedChange() {
            ++this.done;
            int newPercentage = this.calculatePercentage();
            if (newPercentage != this.lastPercentage) {
                this.lastPercentage = newPercentage;
                if (this.callback != null) {
                    try {
                        this.callback.progress(newPercentage);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    public static interface ProgressCallback {
        public void progress(int var1);
    }

    public static class ConflictReader
    extends Reader {
        Reader in;
        boolean lineIsXML = false;
        boolean lineIsConflictMark = false;
        int linePos = 0;
        char firstChar = '\u0000';
        char secondChar = '\u0000';
        char[] readInAdvance = null;
        static final char[] beginConflict = "server:".toCharArray();
        static final char[] midConflict = "client:".toCharArray();
        static final char[] endConflict = "version".toCharArray();

        public ConflictReader(Reader in) {
            this.in = in;
        }

        public void close() throws IOException {
            this.in.close();
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.readInAdvance != null) {
                char c = this.readInAdvance[0];
                this.process(c);
                cbuf[off] = c;
                this.readInAdvance = null;
                if (this.lineIsConflictMark) {
                    this.processConflict(cbuf, off, 1);
                }
                return 1;
            }
            int read = this.in.read(cbuf, off, len);
            if (read > 0) {
                for (int i = 0; i < read; ++i) {
                    if (this.lineIsConflictMark && cbuf[off + i] == '\n') {
                        this.processConflict(cbuf, off, i);
                    }
                    this.process(cbuf[off + i]);
                }
            }
            if (this.linePos == 0 && read > 0) {
                this.readInAdvance = new char[1];
                this.in.read(this.readInAdvance, 0, 1);
                this.process(this.readInAdvance[0]);
                --this.linePos;
            }
            if (this.lineIsConflictMark) {
                this.processConflict(cbuf, off, read);
            }
            return read;
        }

        private void processConflict(char[] cbuf, int off, int len) {
            block5: for (int i = 0; i < Math.min(7, this.linePos + 1); ++i) {
                switch (this.firstChar) {
                    case '<': {
                        cbuf[off + len - this.linePos + i] = beginConflict[i];
                        continue block5;
                    }
                    case '=': {
                        cbuf[off + len - this.linePos + i] = midConflict[i];
                        continue block5;
                    }
                    case '>': {
                        cbuf[off + len - this.linePos + i] = endConflict[i];
                    }
                }
            }
        }

        private void process(char c) {
            if (c == '\n') {
                this.lineIsXML = false;
                this.lineIsConflictMark = false;
                this.linePos = -1;
            }
            if (this.linePos > 1) {
                if (this.firstChar == '<' && this.secondChar == '<' || this.firstChar == '>' && this.secondChar == '>' || this.firstChar == '=' && this.secondChar == '=') {
                    this.lineIsConflictMark = true;
                } else {
                    this.lineIsXML = true;
                }
            } else if (this.linePos == 0) {
                this.firstChar = c;
            } else if (this.linePos == 1) {
                this.secondChar = c;
            }
            ++this.linePos;
        }
    }

    class SAXHandlerRepository
    extends DefaultHandler {
        private ProgressCallback callback;
        private CoObRAsXMLReflect xr;

        public SAXHandlerRepository(ProgressCallback callback) {
            this.callback = callback;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("repository".equals(qName)) {
                String lastKnownServerSequenceNumberString;
                String serverString;
                String nextObjectIdString;
                String lastSequenceString = attributes.getValue(attributes.getIndex("nextSequenceNumber"));
                if (lastSequenceString != null) {
                    LocalRepository.this.nextSequenceNumber = new BigInteger(lastSequenceString);
                }
                if ((nextObjectIdString = attributes.getValue(attributes.getIndex("nextObjectId"))) != null) {
                    LocalRepository.this.nextObjectId = new BigInteger(nextObjectIdString).add(new BigInteger("1000000"));
                }
                if ((serverString = attributes.getValue(attributes.getIndex("server"))) != null) {
                    LocalRepository.this.serverIdentifier = serverString;
                }
                if ((lastKnownServerSequenceNumberString = attributes.getValue(attributes.getIndex("lastKnownServerSequenceNumber"))) != null) {
                    LocalRepository.this.lastKnownServerSequenceNumber = new BigInteger(lastKnownServerSequenceNumberString);
                }
                this.xr = new CoObRAsXMLReflect();
                this.xr.setRestoringIDs(true);
                LocalRepository.this.handlerStack.setHandlerForNextElements((DefaultHandler)new SAXHandlerChangesLists(this.xr, this.callback));
            } else {
                LocalRepository.getErrorHandler().handle("Stream does not contain a repository.");
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("repository".equals(qName)) {
                this.xr.removeYou();
                LocalRepository.this.completeRedo(this.callback);
            }
        }
    }

    class SAXHandlerChangesLists
    extends DefaultHandler {
        CoObRAsXMLReflect xr;
        ProgressCallback callback;

        public SAXHandlerChangesLists(CoObRAsXMLReflect xr, ProgressCallback callback) {
            this.callback = callback;
            this.xr = xr;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("base".equals(qName)) {
                LocalRepository.this.handlerStack.setHandlerForNextElements((DefaultHandler)new SAXHandlerChanges(LocalRepository.this.changesBase, this.xr, this.callback));
                LocalRepository.this.handlerStack.getHandlerForNextElements().startElement(uri, localName, qName, attributes);
            } else if ("changes".equals(qName)) {
                LocalRepository.this.handlerStack.setHandlerForNextElements((DefaultHandler)new SAXHandlerChanges(null, this.xr, this.callback));
                LocalRepository.this.handlerStack.getHandlerForNextElements().startElement(uri, localName, qName, attributes);
            }
        }
    }

    private static class MySAXBuilder
    extends SAXBuilder {
        private MySAXBuilder() {
        }

        protected XMLReader createParser() throws JDOMException {
            return super.createParser();
        }
    }

    class SAXHandlerChanges
    extends DefaultHandler {
        Set ignoredClasses = new HashSet();
        Set ignoredObjects = new HashSet();
        Collection changes;
        CoObRAsXMLReflect xmlReflectForValues;
        private Object newValue;
        private Object oldValue;
        private ObjectChangeAware affectedObject;
        private Object key;
        private ObjectChangeCause cause;
        private String field;
        private String numberString;
        private BigInteger number;
        private int type;
        private long timestamp;
        private String objectString;
        private SAXHandlerJDOM saxHandlerJDOM;
        private BigInteger lastNumber;
        private ProgressCallback callback;
        private BigInteger lastNumberDiv50;
        private String isRoot;

        SAXHandlerChanges(Collection changes, CoObRAsXMLReflect xmlReflectForValues, ProgressCallback callback) {
            this.changes = changes;
            this.xmlReflectForValues = xmlReflectForValues;
            this.callback = callback;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("change".equals(qName)) {
                this.numberString = attributes.getValue("number");
                if (this.callback != null) {
                    if (this.lastNumberDiv50 != null) {
                        LocalRepository.this.progress(this.callback, new BigInteger(this.numberString).divide(this.lastNumberDiv50).intValue());
                    } else {
                        LocalRepository.this.progress(this.callback, -1);
                    }
                }
                this.number = LocalRepository.this.getSequenceNumberForStoredChange(this.numberString);
                String typeString = attributes.getValue(attributes.getIndex("type"));
                try {
                    this.type = Integer.parseInt(typeString);
                }
                catch (NumberFormatException e) {
                    LocalRepository.getErrorHandler().handle(new RuntimeException("Not a number in type!", e));
                    return;
                }
                int index = attributes.getIndex("timestamp");
                String timestampString = index >= 0 ? attributes.getValue(index) : null;
                try {
                    this.timestamp = timestampString != null ? Long.parseLong(timestampString) : 0L;
                }
                catch (NumberFormatException e) {
                    LocalRepository.getErrorHandler().handle(new RuntimeException("Not a number in timestamp!", e));
                }
                this.field = attributes.getValue(attributes.getIndex("field"));
                this.objectString = attributes.getValue(attributes.getIndex("object"));
                if (this.saxHandlerJDOM == null) {
                    this.saxHandlerJDOM = new SAXHandlerJDOM();
                } else {
                    this.saxHandlerJDOM.reset();
                }
                LocalRepository.this.handlerStack.setHandlerForNextElements((DefaultHandler)this.saxHandlerJDOM);
                this.isRoot = attributes.getValue("root");
                return;
            }
            if ("repository".equals(qName)) {
                String isCheckin;
                String lkssn;
                String nextId = attributes.getValue(attributes.getIndex("nextObjectId"));
                if (nextId != null) {
                    LocalRepository.this.nextObjectId = new BigInteger(nextId);
                }
                if ((lkssn = attributes.getValue(attributes.getIndex("lastKnownServerSequenceNumber"))) != null) {
                    LocalRepository.this.lastKnownServerSequenceNumber = new BigInteger(lkssn);
                }
                if ((isCheckin = attributes.getValue(attributes.getIndex("checkin"))) == null) return;
                LocalRepository.this.moveChangesIntoChangesBase();
                return;
            } else if ("remove".equals(qName)) {
                ObjectChange change;
                BigInteger number = new BigInteger(attributes.getValue(attributes.getIndex("number")));
                if (this.changes != null) {
                    if (this.changes instanceof List) {
                        List changesList = (List)this.changes;
                        change = (ObjectChange)changesList.get(changesList.size() - 1);
                        if (!change.getSequenceNumber().equals(number)) {
                            throw new RuntimeException("Cannot remove change (sqn=" + number + ") that is not on top of the temporary changes list!");
                        }
                        LocalRepository.this.removeFromChanges(change);
                    } else {
                        if (!(this.changes instanceof SortedSet)) throw new RuntimeException("unsupported collection to remove changes");
                        SortedSet changesSet = (SortedSet)this.changes;
                        change = (ObjectChange)changesSet.last();
                        if (!change.getSequenceNumber().equals(number)) {
                            throw new RuntimeException("Cannot remove change (sqn=" + number + ") that is not on top of the temporary changes set!");
                        }
                        LocalRepository.this.removeFromChanges(change);
                    }
                } else {
                    change = LocalRepository.this.getFirstFromChanges();
                    if (!change.getSequenceNumber().equals(number)) {
                        throw new RuntimeException("Cannot remove change (sqn=" + number + ") that is not on top of the changes list!");
                    }
                    LocalRepository.this.removeFromChanges(change);
                }
                if (change.getTypeOfChange() != 1) return;
                LocalRepository.this.removeFromKnownIds(change.getAffectedObject().getCoObRAId());
                return;
            } else if ("changes".equals(qName) || "base".equals(qName)) {
                String last = attributes.getValue("last");
                if (last == null) return;
                this.lastNumber = new BigInteger(last);
                this.lastNumberDiv50 = this.lastNumber.divide(new BigInteger("50"));
                return;
            } else {
                LocalRepository.getErrorHandler().handle("Unhandled xml tag: " + qName);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void endElement(String uri, String localName, String qName) throws SAXException {
            block22: {
                block27: {
                    String objectString;
                    Element valueElem;
                    block26: {
                        block25: {
                            block24: {
                                block23: {
                                    if (!"change".equals(qName)) return;
                                    if (this.saxHandlerJDOM == null) break block22;
                                    this.cause = LocalRepository.this.getCauseForStoredChange(this.saxHandlerJDOM.get("cause"), this.xmlReflectForValues);
                                    valueElem = this.saxHandlerJDOM.get("newValue");
                                    if (valueElem != null) {
                                        objectString = valueElem.getAttributeValue("object");
                                        if (objectString != null) {
                                            this.newValue = LocalRepository.this.getObjectFromId(objectString);
                                            if (this.newValue == null) {
                                                LocalRepository.getErrorHandler().handle("object with id '" + objectString + "' not found (change#" + this.number + ")!");
                                                this.ignoredObjects.add(objectString);
                                                return;
                                            }
                                        } else {
                                            this.newValue = this.xmlReflectForValues.reflectXMLField(valueElem, class$java$lang$Object == null ? (class$java$lang$Object = LocalRepository.class$("java.lang.Object")) : class$java$lang$Object, null);
                                        }
                                    } else {
                                        this.newValue = null;
                                    }
                                    valueElem = this.saxHandlerJDOM.get("oldValue");
                                    if (valueElem == null) break block23;
                                    objectString = valueElem.getAttributeValue("object");
                                    if (objectString != null) {
                                        this.oldValue = LocalRepository.this.getObjectFromId(objectString);
                                        if (this.oldValue == null) {
                                            LocalRepository.getErrorHandler().handle("object with id '" + objectString + "' not found (change#" + this.number + ")!");
                                        }
                                        break block24;
                                    } else {
                                        this.oldValue = this.xmlReflectForValues.reflectXMLField(valueElem, class$java$lang$Object == null ? (class$java$lang$Object = LocalRepository.class$("java.lang.Object")) : class$java$lang$Object, null);
                                    }
                                    break block24;
                                }
                                this.oldValue = null;
                            }
                            if (this.type != 1) break block25;
                            if (this.newValue instanceof Class) {
                                Class cls = (Class)this.newValue;
                                this.affectedObject = LocalRepository.this.wasContainingFilteredServerChanges ? LocalRepository.this.getObjectFromId(this.objectString) : null;
                                if (this.affectedObject == null) {
                                    this.affectedObject = LocalRepository.this.createObjectInstance(cls, this.objectString, this.xmlReflectForValues);
                                    if (this.affectedObject == null) {
                                        return;
                                    }
                                    if (!this.objectString.startsWith(LocalRepository.ID_PREFIX_SINGLETON) && LocalRepository.this.getObjectFromId(this.objectString) != null) {
                                        LocalRepository.getErrorHandler().handle("Dublicate id: " + this.objectString);
                                        return;
                                    }
                                    this.affectedObject.setRepository(LocalRepository.this);
                                    LocalRepository.this.addToKnownIds(this.objectString, this.affectedObject);
                                }
                                break block26;
                            } else {
                                String classText;
                                valueElem = this.saxHandlerJDOM.get("newValue");
                                String string = classText = valueElem != null ? valueElem.getText() : null;
                                if (!this.ignoredClasses.contains(classText)) {
                                    this.ignoredClasses.add(classText);
                                    LocalRepository.getErrorHandler().handle("Objectclass could not be restored for " + classText);
                                }
                                this.ignoredObjects.add(this.objectString);
                                return;
                            }
                        }
                        if (this.ignoredObjects.contains(this.objectString)) {
                            return;
                        }
                        this.affectedObject = LocalRepository.this.getObjectFromId(this.objectString);
                        if (this.affectedObject == null) {
                            LocalRepository.getErrorHandler().handle("Did not find object '" + this.objectString + "' (no add_object so far)!");
                            return;
                        }
                    }
                    valueElem = this.saxHandlerJDOM.get("key");
                    if (valueElem == null) break block27;
                    objectString = valueElem.getAttributeValue("object");
                    if (objectString != null) {
                        this.key = LocalRepository.this.getObjectFromId(objectString);
                        if (this.key == null) {
                            LocalRepository.getErrorHandler().warn("Did not find object '" + objectString + "' for key in change#" + this.numberString + "!");
                        }
                        break block22;
                    } else {
                        this.key = this.xmlReflectForValues.reflectXMLField(valueElem, class$java$lang$Object == null ? (class$java$lang$Object = LocalRepository.class$("java.lang.Object")) : class$java$lang$Object, null);
                    }
                    break block22;
                }
                this.key = null;
            }
            ObjectChange change = ObjectChange.peekCause() == LocalRepository.this.UPDATE_CAUSE ? new ServerObjectChange(this.cause, this.affectedObject, this.field, this.type, this.oldValue, this.newValue, this.number, this.key, new BigInteger(this.numberString)) : new ObjectChange(this.cause, this.affectedObject, this.field, this.type, this.oldValue, this.newValue, this.number, this.key, this.timestamp);
            if ("1".equals(this.isRoot)) {
                LocalRepository.this.setRootObject(this.affectedObject);
            }
            this.xmlReflectForValues.getLinkFactory().createLinkTo((Object)change, "" + change.getSequenceNumber());
            if (this.changes != null) {
                this.changes.add(change);
                return;
            }
            LocalRepository.this.addToChanges(change);
        }
    }

    class SAXHandlerJDOM
    extends DefaultHandler {
        Map elements = new TreeMap();
        private SAXHandler saxHandler;

        SAXHandlerJDOM() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.saxHandler == null) {
                this.saxHandler = new SAXHandler();
            }
            this.saxHandler.startDocument();
            this.saxHandler.startElement(uri, localName, qName, attributes);
            LocalRepository.this.handlerStack.setHandlerForNextElements((DefaultHandler)this.saxHandler);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.saxHandler.endElement(uri, localName, qName);
            this.saxHandler.endDocument();
            Element element = this.saxHandler.getDocument().getRootElement();
            if (!qName.equals(element.getName())) {
                throw new RuntimeException("qName does not match element name!");
            }
            this.elements.put(qName, element);
        }

        public Element get(String name) {
            return (Element)this.elements.get(name);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.saxHandler.characters(ch, start, length);
        }

        public void reset() {
            this.elements.clear();
        }
    }

    public class CoObRAsXMLReflect
    extends XMLReflect {
        CLinkFactory linkFactory = new CLinkFactory();

        public CoObRAsXMLReflect() {
            this.setClassLoader(LocalRepository.this.getClassLoader());
        }

        public boolean isReflectable(Class objClass) {
            if (objClass == null) {
                return false;
            }
            if ((class$java$awt$Point == null ? (class$java$awt$Point = LocalRepository.class$("java.awt.Point")) : class$java$awt$Point).equals(objClass)) {
                return true;
            }
            if ((class$java$util$Date == null ? (class$java$util$Date = LocalRepository.class$("java.util.Date")) : class$java$util$Date).equals(objClass)) {
                return true;
            }
            if ((class$java$awt$Dimension == null ? (class$java$awt$Dimension = LocalRepository.class$("java.awt.Dimension")) : class$java$awt$Dimension).equals(objClass)) {
                return true;
            }
            if ((class$java$awt$Rectangle == null ? (class$java$awt$Rectangle = LocalRepository.class$("java.awt.Rectangle")) : class$java$awt$Rectangle).equals(objClass)) {
                return true;
            }
            if ((class$de$tu_bs$coobra$ObjectChangeAware == null ? (class$de$tu_bs$coobra$ObjectChangeAware = LocalRepository.class$("de.tu_bs.coobra.ObjectChangeAware")) : class$de$tu_bs$coobra$ObjectChangeAware).isAssignableFrom(objClass)) {
                return true;
            }
            if ((class$de$tu_bs$coobra$ObjectChangeCause == null ? (class$de$tu_bs$coobra$ObjectChangeCause = LocalRepository.class$("de.tu_bs.coobra.ObjectChangeCause")) : class$de$tu_bs$coobra$ObjectChangeCause).isAssignableFrom(objClass)) {
                return true;
            }
            if ((class$de$tu_bs$coobra$LocalRepository == null ? (class$de$tu_bs$coobra$LocalRepository = LocalRepository.class$("de.tu_bs.coobra.LocalRepository")) : class$de$tu_bs$coobra$LocalRepository).isAssignableFrom(objClass)) {
                return true;
            }
            return super.isReflectable(objClass);
        }

        protected int getStoreMode(Field field, String part, Object value) {
            if (value != null) {
                if ((class$java$awt$Point == null ? (class$java$awt$Point = LocalRepository.class$("java.awt.Point")) : class$java$awt$Point).equals(value.getClass())) {
                    return 2;
                }
                if ((class$java$awt$Dimension == null ? (class$java$awt$Dimension = LocalRepository.class$("java.awt.Dimension")) : class$java$awt$Dimension).equals(value.getClass())) {
                    return 2;
                }
                if ((class$java$awt$Rectangle == null ? (class$java$awt$Rectangle = LocalRepository.class$("java.awt.Rectangle")) : class$java$awt$Rectangle).equals(value.getClass())) {
                    return 2;
                }
            }
            if (field != null) {
                Class<?> declaringClass = field.getDeclaringClass();
                String fieldName = field.getName();
                if ((class$de$tu_bs$coobra$ObjectChangeAware == null ? (class$de$tu_bs$coobra$ObjectChangeAware = LocalRepository.class$("de.tu_bs.coobra.ObjectChangeAware")) : class$de$tu_bs$coobra$ObjectChangeAware).isAssignableFrom(declaringClass)) {
                    return 3;
                }
                if ((class$de$tu_bs$coobra$LocalRepository == null ? (class$de$tu_bs$coobra$LocalRepository = LocalRepository.class$("de.tu_bs.coobra.LocalRepository")) : class$de$tu_bs$coobra$LocalRepository).isAssignableFrom(declaringClass)) {
                    return 3;
                }
                if ((class$de$tu_bs$coobra$ObjectChangeCause == null ? (class$de$tu_bs$coobra$ObjectChangeCause = LocalRepository.class$("de.tu_bs.coobra.ObjectChangeCause")) : class$de$tu_bs$coobra$ObjectChangeCause).equals(declaringClass) ? "consequences".equals(fieldName) : (class$de$tu_bs$coobra$ObjectChange == null ? (class$de$tu_bs$coobra$ObjectChange = LocalRepository.class$("de.tu_bs.coobra.ObjectChange")) : class$de$tu_bs$coobra$ObjectChange).equals(declaringClass) && ("newValue".equals(fieldName) || "oldValue".equals(fieldName) || "affectedObject".equals(fieldName) ? value instanceof ObjectChangeAware : ("cause".equals(fieldName) ? value instanceof ObjectChange : "repository".equals(fieldName)))) {
                    return 1;
                }
            }
            return super.getStoreMode(field, part, value);
        }

        public String getIDForObject(Object objInstance) {
            if (objInstance instanceof ObjectChangeAware) {
                return LocalRepository.this.getIdForObject((ObjectChangeAware)objInstance);
            }
            if (objInstance instanceof ObjectChange) {
                return "Change#" + ((ObjectChange)objInstance).getSequenceNumber();
            }
            if (objInstance == LocalRepository.this) {
                return "repository";
            }
            return super.getIDForObject(objInstance);
        }

        public void setIDForObject(Object objInstance, String id) {
            if (objInstance instanceof ObjectChangeAware) {
                LocalRepository.this.addToKnownIds(id, (ObjectChangeAware)objInstance);
            } else if (!(objInstance instanceof ObjectChange)) {
                if ("repository".equals(id)) {
                    return;
                }
                if ("storage".equals(id)) {
                    return;
                }
                super.setIDForObject(objInstance, id);
            }
        }

        public LinkFactory getLinkFactory() {
            return this.linkFactory;
        }

        public Object createObjectInstance(Class objClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
            Object instance = CoObRAsXMLReflect.getFromSingletons((Class)objClass);
            if (instance != null) {
                return instance;
            }
            try {
                if ((class$de$tu_bs$coobra$ObjectChangeAware == null ? (class$de$tu_bs$coobra$ObjectChangeAware = LocalRepository.class$("de.tu_bs.coobra.ObjectChangeAware")) : class$de$tu_bs$coobra$ObjectChangeAware).isAssignableFrom(objClass)) {
                    Class[] paramTypes = new Class[]{class$de$tu_bs$coobra$LocalRepository == null ? (class$de$tu_bs$coobra$LocalRepository = LocalRepository.class$("de.tu_bs.coobra.LocalRepository")) : class$de$tu_bs$coobra$LocalRepository};
                    Constructor objConstructor = objClass.getDeclaredConstructor(paramTypes);
                    objConstructor.setAccessible(true);
                    Object[] args = new Object[1];
                    return objConstructor.newInstance(args);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            try {
                if ((class$de$tu_bs$coobra$ObjectChangeAware == null ? (class$de$tu_bs$coobra$ObjectChangeAware = LocalRepository.class$("de.tu_bs.coobra.ObjectChangeAware")) : class$de$tu_bs$coobra$ObjectChangeAware).isAssignableFrom(objClass)) {
                    Class[] paramTypes = new Class[]{};
                    Constructor objConstructor = objClass.getDeclaredConstructor(paramTypes);
                    objConstructor.setAccessible(true);
                    Object[] args = new Object[]{};
                    return objConstructor.newInstance(args);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if ((class$de$tu_bs$coobra$ObjectChangeAware == null ? (class$de$tu_bs$coobra$ObjectChangeAware = LocalRepository.class$("de.tu_bs.coobra.ObjectChangeAware")) : class$de$tu_bs$coobra$ObjectChangeAware).isAssignableFrom(objClass)) {
                Constructor<?>[] ctors = objClass.getDeclaredConstructors();
                for (int i = 0; i < ctors.length; ++i) {
                    Class<?>[] paramTypes = ctors[i].getParameterTypes();
                    if (paramTypes.length != 1 || !(class$de$tu_bs$coobra$ObjectChangeAware == null ? LocalRepository.class$("de.tu_bs.coobra.ObjectChangeAware") : class$de$tu_bs$coobra$ObjectChangeAware).isAssignableFrom(paramTypes[0])) continue;
                    Object[] args = new Object[1];
                    ctors[i].setAccessible(true);
                    return ctors[i].newInstance(args);
                }
            }
            return super.createObjectInstance(objClass);
        }

        class CLinkFactory
        extends LinkFactory {
            CLinkFactory() {
            }

            public Link createLinkTo(Object target, String id) {
                if ("repository".equals(id)) {
                    return this.getLinkTo(id, class$de$tu_bs$xmlreflect$Link == null ? (class$de$tu_bs$xmlreflect$Link = LocalRepository.class$("de.tu_bs.xmlreflect.Link")) : class$de$tu_bs$xmlreflect$Link);
                }
                if (target instanceof ObjectChangeAware) {
                    LocalRepository.this.addToKnownIds(id, (ObjectChangeAware)target);
                    return this.getLinkTo(id, class$de$tu_bs$xmlreflect$Link == null ? (class$de$tu_bs$xmlreflect$Link = LocalRepository.class$("de.tu_bs.xmlreflect.Link")) : class$de$tu_bs$xmlreflect$Link);
                }
                return super.createLinkTo(target, id);
            }

            public Link getLinkTo(String id, Class linkClass) {
                Object object = "repository".equals(id) ? LocalRepository.this : LocalRepository.this.getObjectFromId(id);
                if (object != null) {
                    return new Link(id, object);
                }
                return super.getLinkTo(id, linkClass);
            }
        }
    }

    private static class ReferenceIterator
    implements Iterator {
        Iterator references;

        public ReferenceIterator(Iterator references) {
            this.references = references;
        }

        public boolean hasNext() {
            return this.references.hasNext();
        }

        public Object next() {
            return ((Reference)this.references.next()).get();
        }

        public void remove() {
            this.references.remove();
        }
    }

    public static interface UpdateFilter {
        public boolean receivedChanges(Iterator var1);

        public boolean accept(ServerObjectChange var1);

        public boolean isPatch();
    }
}

