/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2007  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 *********************************************************************/

#include "constants.h"

#ifdef USE_UI_TEXT

#include "ui.h"

#include "../../misc/setting.h"
#include "../../misc/language.h"

namespace UI_TEXT_NS {

  /**
   **
   ** updates all language elements
   **
   ** @param	-
   **
   ** @return	-
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   ** @todo	all
   **
   **/
  void
    UI_Text::language_update()
    {
      DEBUG_CALLING(INFO_UI_TEXT,
		    "UI_Text::language_update()");


      DEBUG_RETURNING(VOID,
		      INFO_UI_TEXT,
		      "UI_Text::language_update()");
    } // void UI_Text::language_update()

  /**
   **
   ** redraw all (of the playfield)
   **
   ** @param	-
   **
   ** @return	-
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   ** @todo	all
   **
   **/
  void
    UI_Text::redraw_all()
    { 
      DEBUG_CALLING(INFO_UI_TEXT,
		    "UI_Text::redraw_all()");

      DEBUG_RETURNING(VOID,
		      INFO_UI_TEXT,
		      "UI_Text::redraw_all()");
    } // void UI_Text::redraw_all()

  /**
   **
   ** update the gametype icon
   **
   ** @param	-
   **
   ** @return	-
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   ** @todo	all
   **
   **/
  void
    UI_Text::gametype_update()
    { 
      DEBUG_CALLING(INFO_UI_TEXT,
		    "UI_Text::gametype_update()");

      DEBUG_RETURNING(VOID,
		      INFO_UI_TEXT,
		      "UI_Text::gametype_update()");
    } // void UI_Text::gametype_udpate()

  /**
   **
   ** update the trick
   **
   ** @param	-
   **
   ** @return	-
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   ** @todo	all
   **
   **/
  void
    UI_Text::trick_update()
    { 
      DEBUG_CALLING(INFO_UI_TEXT,
		    "UI_Text::trick_update()");

      DEBUG_RETURNING(VOID,
		      INFO_UI_TEXT,
		      "UI_Text::trick_update()");
    } // void UI_Text::trick_update()

  /**
   **
   ** update the name of 'player'
   **
   ** @param	player	the player
   **
   ** @return	-
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   ** @todo	all
   **
   **/
  void
    UI_Text::name_update(Player const& player)
    {
      DEBUG_CALLING(INFO_UI_TEXT,
		    "UI_Text::name_update(player)");

      DEBUG_RETURNING(VOID,
		      INFO_UI_TEXT,
		      "UI_Text::name_update(player)");
    } // void UI_Text::name_update(player)

  /**
   **
   ** update the hand of 'player'
   **
   ** @param	player	the player
   **
   ** @return	-
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   ** @todo	all
   **
   **/
  void
    UI_Text::hand_update(Player const& player)
    { 
      DEBUG_CALLING(INFO_UI_TEXT,
		    "UI_Text::hand_update(player)");

      DEBUG_RETURNING(VOID,
		      INFO_UI_TEXT,
		      "UI_Text::hand_update(player)");
    } // void UI_Text::hand_update(player)

  /**
   **
   ** update the trickpile of 'player'
   **
   ** @param	player	the player
   **
   ** @return	-
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   ** @todo	all
   **
   **/
  void
    UI_Text::trick_pile_update(Player const& player)
    { 
      DEBUG_CALLING(INFO_UI_TEXT,
		    "UI_Text::trick_pile_update(player)");

      DEBUG_RETURNING(VOID,
		      INFO_UI_TEXT,
		      "UI_Text::trick_pile_update(player)");
    } // void UI_Text::trick_pile_udpate(player)


  /**
   **
   ** update the team icon of 'player'
   **
   ** @param	player	the player
   **
   ** @return	-
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   ** @todo	all
   **
   **/
  void
    UI_Text::teaminfo_update(Player const& player)
    { 
      DEBUG_CALLING(INFO_UI_TEXT,
		    "UI_Text::teaminfo_update(player)");

      DEBUG_RETURNING(VOID,
		      INFO_UI_TEXT,
		      "UI_Text::teaminfo_update(player)");
    } // void UI_Text::teaminfo_udpate(player)

  /**
   **
   ** update the announcement icon of 'player'
   **
   ** @param	player	the player
   **
   ** @return	-
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   ** @todo	all
   **
   **/
  void
    UI_Text::announcement_update(Player const& player)
    { 
      DEBUG_CALLING(INFO_UI_TEXT,
		    "UI_Text::announcement_update(player)");

      DEBUG_RETURNING(VOID,
		      INFO_UI_TEXT,
		      "UI_Text::announcement_update(player)");
    } // void UI_Text::announcement_udpate(player)

  /**
   **
   ** update the rule
   **
   ** @param	type		the rule, that has changed
   ** @param	old_value	old value
   **
   ** @return	-
   **
   ** @version	0.5.3
   **
   ** @author	Diether Knof
   **
   ** @todo	all
   **
   **/
  void
    UI_Text::rule_update(int const type, void const* const old_value)
    {
      DEBUG_CALLING(INFO_UI_TEXT && INFO_UI_UPDATE,
		    "UI_Text::rule_update(type, old_value)");

      DEBUG_RETURNING(VOID,
		      INFO_UI_TEXT && INFO_UI_UPDATE,
		      "UI_Text::rule_update(type, old_value)");
    } // void UI_Text::rule_update(int const type, void const* const old_value)

  /**
   **
   ** show the update
   **
   ** @param	type		the setting, that has changed
   ** @param	old_value	old value
   **
   ** @return	-
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   **/
  void
    UI_Text::setting_update(int const type, void const* const old_value)
    {
      DEBUG_CALLING(INFO_UI_TEXT && INFO_UI_UPDATE,
		    "UI_Text::setting_update(type)");

      if ((type >= Setting::BOOL_FIRST)
	  && (type <= Setting::BOOL_LAST))
	this->ostr() << ::language("Setting")
	  << ": " << ::language(::name(Setting::TypeBool(type)))
	  << " = " << ::setting(Setting::TypeBool(type))
	  << " (" << *(static_cast<bool const* const>(old_value)) << ")"
	  << '\n';
      else if ((type >= Setting::UNSIGNED_FIRST)
	  && (type <= Setting::UNSIGNED_LAST))
	this->ostr() << ::language("Setting")
	  << ": " << ::language(::name(Setting::TypeUnsigned(type)))
	  << " = " << ::setting(Setting::TypeUnsigned(type))
	  << " (" << *(static_cast<unsigned const* const>(old_value)) << ")"
	  << '\n';
      else if ((type >= Setting::STRING_FIRST)
	       && (type <= Setting::STRING_LAST))
	this->ostr() << ::language("Setting")
	  << ": " << ::language(::name(Setting::TypeString(type)))
	  << " = " << ::setting(Setting::TypeString(type))
	  << " (" << *(static_cast<string const* const>(old_value)) << ")"
	  << '\n';
      else if ((type >= Setting::CARDS_ORDER_FIRST)
	       && (type <= Setting::CARDS_ORDER_LAST))
	this->ostr() << ::language("Setting")
	  << ": " << ::language(::name(Setting::TypeCardsOrder(type)))
	  << " = " << ::setting(Setting::TypeCardsOrder(type))
	  << " (" << *(static_cast<CardsOrder const* const>(old_value)) << ")"
	  << '\n';


      DEBUG_RETURNING(VOID,
		      INFO_UI_TEXT && INFO_UI_UPDATE,
		      "UI_Text::setting_update(type)");
    } // void UI_Text::setting_update(int const type, void const* const old_value)

} // namespace UI_TEXT_NS

#endif // #ifdef USE_UI_TEXT
