#!/bin/bash

# script to convert the Altenburg cardsets into the FreeDoko one

# file with the cards
CARDS_FILE_FRENCH=Altenburg.Karten.french.pdf
CARDS_FILE_GERMAN=311252_DokoDt_VS72.pdf
# height of the destination cards
HEIGHT=138

DESCRIPTION="Verwendung der ASS Altenburger Spielkarten mit Genehmigung der Spielkartenfabrik Altenburg GmbH."

rm -rf png.${HEIGHT}

mkdir png.${HEIGHT}
cd png.${HEIGHT}


# size of Altenburg pdf: 239x330
WIDTH=$((${HEIGHT} * 90 / 138))
MARGIN_Y=$((${HEIGHT} * 15 / 100))
MARGIN_X=$((${WIDTH} * 22 / 100))

# first argument:  source
# second argument: destination
function convert_card {
  composite ../mask.${HEIGHT}.png $1 $2
  mogrify -transparent '#ffff00' $2
} # function convert_card

function convert_french {
echo "converting french cardset"

convert -scale x$((${HEIGHT} + 2 * ${MARGIN_Y})) \
	-crop ${WIDTH}x${HEIGHT}+${MARGIN_X}+${MARGIN_Y} \
	-comment "${DESCRIPTION}" \
	../${CARDS_FILE_FRENCH} \
	card.png

echo "  club"
mkdir -p french/cards/club
convert_card card-1.png  french/cards/club/queen.png
convert_card card-4.png  french/cards/club/jack.png
convert_card card-8.png  french/cards/club/king.png
convert_card card-12.png french/cards/club/ace.png
convert_card card-16.png french/cards/club/nine.png
convert_card card-17.png french/cards/club/ten.png
echo "  spade"
mkdir -p french/cards/spade
convert_card card-2.png  french/cards/spade/queen.png
convert_card card-5.png  french/cards/spade/jack.png
convert_card card-9.png  french/cards/spade/king.png
convert_card card-13.png french/cards/spade/ace.png
convert_card card-18.png french/cards/spade/nine.png
convert_card card-19.png french/cards/spade/ten.png
echo "  heart"
mkdir -p french/cards/heart
convert_card card-0.png  french/cards/heart/queen.png
convert_card card-6.png  french/cards/heart/jack.png
convert_card card-10.png french/cards/heart/king.png
convert_card card-14.png french/cards/heart/ace.png
convert_card card-20.png french/cards/heart/nine.png
convert_card card-21.png french/cards/heart/ten.png
echo "  diamond"
mkdir -p french/cards/diamond
convert_card card-3.png  french/cards/diamond/queen.png
convert_card card-7.png  french/cards/diamond/jack.png
convert_card card-11.png french/cards/diamond/king.png
convert_card card-15.png french/cards/diamond/ace.png
convert_card card-22.png french/cards/diamond/nine.png
convert_card card-23.png french/cards/diamond/ten.png

rm *.png

cd french/
mkdir icons
cd icons
~/Programme/FreeDoko/data/bin/create_icons
cd ../..
} # function convert_french
function convert_german {
echo "converting german cardset"

convert -scale x$((${HEIGHT} + 2 * ${MARGIN_Y})) \
	-crop ${WIDTH}x${HEIGHT}+${MARGIN_X}+${MARGIN_Y} \
	-comment "${DESCRIPTION}" \
	../${CARDS_FILE_GERMAN} \
	card.png

echo "  club"
mkdir -p german/cards/club
convert_card card-1.png  german/cards/club/ace.png
convert_card card-5.png  german/cards/club/king.png
convert_card card-9.png  german/cards/club/queen.png
convert_card card-13.png german/cards/club/jack.png
convert_card card-17.png german/cards/club/ten.png
convert_card card-18.png german/cards/club/nine.png
echo "  spade"
mkdir -p german/cards/spade
convert_card card-2.png  german/cards/spade/ace.png
convert_card card-6.png  german/cards/spade/king.png
convert_card card-10.png german/cards/spade/queen.png
convert_card card-14.png german/cards/spade/jack.png
convert_card card-19.png german/cards/spade/ten.png
convert_card card-20.png german/cards/spade/nine.png
echo "  heart"
mkdir -p german/cards/heart
convert_card card-3.png  german/cards/heart/ace.png
convert_card card-7.png  german/cards/heart/king.png
convert_card card-11.png german/cards/heart/queen.png
convert_card card-15.png german/cards/heart/jack.png
convert_card card-21.png german/cards/heart/ten.png
convert_card card-22.png german/cards/heart/nine.png
echo "  diamond"
mkdir -p german/cards/diamond
convert_card card-4.png  german/cards/diamond/ace.png
convert_card card-8.png  german/cards/diamond/king.png
convert_card card-12.png german/cards/diamond/queen.png
convert_card card-16.png german/cards/diamond/jack.png
convert_card card-23.png german/cards/diamond/ten.png
convert_card card-24.png german/cards/diamond/nine.png

rm *.png

cd german/
mkdir icons
cd icons
~/Programme/FreeDoko/data/bin/create_icons
cd ../..
} # function convert_german


convert_french
convert_german

cp ../copyright.Altenburg License
pngcrushmin */*/*/*.png
