/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.war.dto;

import javax.xml.bind.annotation.XmlRootElement;
import java.math.BigDecimal;

/**
 * @author Yaroslav.Kovalchyk
 * @version $Id: RangeValidationRule.java 22821 2012-03-27 13:50:39Z ykovalchyk $
 */
@XmlRootElement
public class RangeValidationRule extends ValidationRule{
    private BigDecimal maxValue;
    private BigDecimal minValue;
    private Boolean includeMaxValue = false;
    private Boolean includeMinValue = false;

    public BigDecimal getMaxValue() {
        return maxValue;
    }

    public void setMaxValue(BigDecimal maxValue) {
        this.maxValue = maxValue;
    }

    public BigDecimal getMinValue() {
        return minValue;
    }

    public void setMinValue(BigDecimal minValue) {
        this.minValue = minValue;
    }

    public Boolean isIncludeMaxValue() {
        return includeMaxValue;
    }

    public void setIncludeMaxValue(Boolean includeMaxValue) {
        this.includeMaxValue = includeMaxValue;
    }

    public Boolean isIncludeMinValue() {
        return includeMinValue;
    }

    public void setIncludeMinValue(Boolean includeMinValue) {
        this.includeMinValue = includeMinValue;
    }
}
