/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.war.common;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import com.jaspersoft.jasperserver.api.common.util.LocaleHelper;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: LocalesListImpl.java 23733 2012-05-14 13:27:47Z ztomchenco $
 */
public class LocalesListImpl implements LocalesList {
	
	private final LocaleHelper localeHelper;
	private List locales;
	
	public LocalesListImpl() {
		localeHelper = LocaleHelper.getInstance();
	}

	public List getLocales() {
		return locales;
	}

	public void setLocales(List locales) {
		this.locales = locales;
	}

	public UserLocale[] getUserLocales(Locale displayLocale) {
        UserLocale[] result;
        if (locales == null){
            result = new UserLocale[1];
            result[0] = getUserLocale(displayLocale,displayLocale);
        }
        else{
            if (locales.contains(displayLocale)){
                locales.remove(displayLocale);
                locales.add(0,displayLocale);
            }
            result = new UserLocale[locales.size()];
            for (int i = 0; i<result.length; i++){
                result[i] = getUserLocale((Locale)locales.get(i),displayLocale);
            }
        }
        return result;
	}

	protected UserLocale getUserLocale(Locale locale, Locale displayLocale) {
		String code = localeHelper.getCode(locale);
		String name = locale.getDisplayName(displayLocale);
		return new UserLocale(code, name);
	}

}
