package com.jaspersoft.jasperserver.war.cascade.handlers.converters;

import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlInformation;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;

/**
 * @author Anton Fomin
 * @version $Id: InputControlValueClassResolver.java 24202 2012-06-21 13:10:48Z afomin $
 */
public class InputControlValueClassResolver {

    public static Class<?> getValueClass(DataType dataType, ReportInputControlInformation info, boolean returnNestedType) {
        Class<?> valueClass = getInputControlValueClass(info, returnNestedType);
        if (valueClass == null && dataType != null) {
            switch (dataType.getType()) {
                case DataType.TYPE_TEXT:
                    valueClass = String.class;
                    break;
                case DataType.TYPE_NUMBER:
                    valueClass = BigDecimal.class;
                    break;
                case DataType.TYPE_DATE:
                    valueClass = Date.class;
                    break;
                case DataType.TYPE_DATE_TIME:
                    valueClass = Timestamp.class;
                    break;
            }
        }
        if (valueClass == null)
            valueClass = String.class;
        return valueClass;
    }

    public static Class<?> getValueClass(DataType dataType, ReportInputControlInformation info) {
        return getValueClass(dataType, info, true);
    }

    private static Class<?> getInputControlValueClass(ReportInputControlInformation info, boolean returnNestedType) {
        Class<?> parameterType = null;
        if (info != null && info.getValueType() != null) {
            if (Collection.class.isAssignableFrom(info.getValueType())) {
                if (!returnNestedType) {
                    parameterType = info.getValueType();
                } else if (info.getNestedType() != null) {
                    parameterType = info.getNestedType();
                }
            } else {
                parameterType = info.getValueType();
            }
        }
        return parameterType;
    }
}
