/*
 * JasperReports - Free Java Reporting Library.
 * Copyright (C) 2001 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of JasperReports.
 *
 * JasperReports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JasperReports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with JasperReports. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.war.action;

import java.util.HashMap;
import java.util.Map;

import org.springframework.binding.collection.MapAdaptable;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.RequestContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.web.WebReportContext;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * @author Teodor Danciu (teodord@users.sourceforge.net)
 * @version $Id: BaseHttpServlet.java 4336 2011-05-24 13:30:34Z teodord $
 */
public class WebflowReportContext implements ReportContext
{
	/**
	 *
	 */
	private static final String SESSION_ATTRIBUTE_REPORT_CONTEXT_ID_PREFIX = "net.sf.jasperreports.web.report.context_";
	public static final String PARAMETER_FLOW_REPORT_CONTEXT = "rptCtx";//"jr.ctxid";
    public static final String REQUEST_PARAMETER_REPORT_CONTEXT_ID = WebReportContext.REQUEST_PARAMETER_REPORT_CONTEXT_ID;

	public static final String REPORT_CONTEXT_PARAMETER_JASPER_PRINT = "net.sf.jasperreports.web.jasper_print";
	public static final String REPORT_CONTEXT_PARAMETER_JASPER_REPORT = "net.sf.jasperreports.web.jasper_report";
	
	/**
	 *
	 */
	//private ThreadLocal<RequestContext> threadLocalRequest = new ThreadLocal<RequestContext>();
	private Map<String, Object> requestParameters;
	private Map<String, Object> requestAttributes;
	private Map<String, Object> flowAttributes;
	
	private Map<String, Object> parameterValues;
	private Map flowValues;
	private String id;
	
	/**
	 *
	 */
	public static final WebflowReportContext getInstance(RequestContext requestContext)
	{
		return getInstance(requestContext, true);
	}

	/**
	 *
	 */
	public static final WebflowReportContext getInstance(Map flowValues)
	{
		WebflowReportContext webflowReportContext = new WebflowReportContext();
		webflowReportContext.setFlowValues(flowValues);
		return webflowReportContext;
	}
	
    public static final void initFlowScope(RequestContext requestContext) {
        Map flowValues = new HashMap();
        
        requestContext.getRequestParameters().asMap();
        flowValues.putAll(requestContext.getRequestParameters().asMap());
        
        // try to preserve REQUEST_PARAMETER_REPORT_CONTEXT_ID
        Map oldFlowMap = (Map)requestContext.getFlowScope().get(PARAMETER_FLOW_REPORT_CONTEXT);
        if (oldFlowMap != null) {
        	flowValues.put(REQUEST_PARAMETER_REPORT_CONTEXT_ID, oldFlowMap.get(REQUEST_PARAMETER_REPORT_CONTEXT_ID));
        }
        
        requestContext.getFlowScope().put(PARAMETER_FLOW_REPORT_CONTEXT, flowValues);//FIXMEJIVE
    }

	/**
	 *
	 */
	public static final WebflowReportContext getInstance(RequestContext requestContext, boolean create)
	{
        ExternalContext ec = requestContext.getExternalContext();
        HttpServletRequest request = (HttpServletRequest) ec.getNativeRequest();
        HttpSession session = request.getSession();

        WebflowReportContext webflowReportContext = null;

        Map flowMap = (Map)requestContext.getFlowScope().get(PARAMETER_FLOW_REPORT_CONTEXT);
        String reportContextId = null;
        if (flowMap != null) {
            reportContextId = (String)flowMap.get(REQUEST_PARAMETER_REPORT_CONTEXT_ID);
        }


		if (reportContextId != null) {
			webflowReportContext = (WebflowReportContext) session.getAttribute(getSessionAttributeName(reportContextId));
		}

		if (webflowReportContext == null) {
			webflowReportContext = new WebflowReportContext();
            session.setAttribute(webflowReportContext.getSessionAttributeName(), webflowReportContext);
            
            if (flowMap != null) {	// FIXME check this! it prevents the context from being recreated each time getInstance() is called
            	flowMap.put(REQUEST_PARAMETER_REPORT_CONTEXT_ID, webflowReportContext.getId());
            	requestContext.getFlowScope().put(PARAMETER_FLOW_REPORT_CONTEXT, flowMap);
            }
        }

        if (webflowReportContext != null) {
            webflowReportContext.setRequestContext(requestContext);
            webflowReportContext.setFlowValues(flowMap);
            webflowReportContext.setParameterValue(JRParameter.REPORT_CONTEXT, webflowReportContext);
        }
		return webflowReportContext;
	}

	/**
	 *
	 */
	public static final WebflowReportContext getInstance(HttpSession session, Map flowMap)
	{
        WebflowReportContext webflowReportContext = null;

        String reportContextId = null;
        if (flowMap != null) {
            reportContextId = (String)flowMap.get(REQUEST_PARAMETER_REPORT_CONTEXT_ID);
        }

		if (reportContextId != null) {
			webflowReportContext = (WebflowReportContext) session.getAttribute(getSessionAttributeName(reportContextId));
		}

        if (webflowReportContext == null) {
            webflowReportContext = new WebflowReportContext();
            webflowReportContext.setFlowValues(flowMap);
            webflowReportContext.setParameterValue(JRParameter.REPORT_CONTEXT, webflowReportContext);
            session.setAttribute(webflowReportContext.getSessionAttributeName(), webflowReportContext);
        }

		return webflowReportContext;
	}

	/**
	 *
	 */
	private WebflowReportContext()
	{
		parameterValues = new HashMap<String, Object>();
		parameterValues.put(JRParameter.REPORT_CONTEXT, this);
	}

	/**
	 *
	 */
	public String getId()
	{
		if (id == null)
		{
			id = String.valueOf(System.currentTimeMillis());//FIXMEJIVE make stronger?
		}
		return id;
	}

	/**
	 *
	 */
	public void setRequestContext(RequestContext request)
	{
		//threadLocalRequest.set(request);
		requestParameters = copyContextMap(request.getRequestParameters());
		requestAttributes = copyContextMap(request.getRequestScope());
		//FIXME we have flowValues as well, are both required?
		flowAttributes = copyContextMap(request.getFlowScope());
	}

	protected Map<String, Object> copyContextMap(MapAdaptable contextMapAdaptable)
	{
		HashMap<String, Object> map = new HashMap<String, Object>();
		if (contextMapAdaptable != null)
		{
			Map<?, ?> contextMap = contextMapAdaptable.asMap();
			if (contextMap != null)
			{
				for (Map.Entry<?, ?> entry : contextMap.entrySet())
				{
					// doing this to match org.springframework.binding.collection.StringKeyedMapAdapter
					map.put(String.valueOf(entry.getKey()), entry.getValue());
				}
			}
		}
		return map;
	}
	
	/**
	 *
	 */
	public Map getFlowValues()
	{
		//return threadLocalRequest.get();
		return flowValues;
	}

	/**
	 *
	 */
	public void setFlowValues(Map flowValues)
	{
		//threadLocalRequest.set(request);
		this.flowValues = flowValues;
	}

	/**
	 *
	 */
	public String getSessionAttributeName()
	{
		return getSessionAttributeName(getId());
	}

	/**
	 *
	 */
	public Object getParameterValue(String parameterName)
	{
		Object requestParameterValue = null;

		if (requestParameters != null)
		{
			requestParameterValue = requestParameters.get(parameterName);
			if (requestParameterValue != null)
			{
				return requestParameterValue;
			}
		}
		
		if (requestAttributes != null)
		{
			requestParameterValue = requestAttributes.get(parameterName);
			if (requestParameterValue != null)
			{
				return requestParameterValue;
			}
		}
		
		if (flowAttributes != null)
		{
			requestParameterValue = flowAttributes.get(parameterName);
			if (requestParameterValue != null)
			{
				return requestParameterValue;
			}
		}
		
//		Map jiveMap = (Map)requestContext.getFlowScope().get("jive");
//		if (jiveMap != null)
//		{
//			requestParameterValue = jiveMap.get(parameterName);
//			if (requestParameterValue != null)
//			{
//				return requestParameterValue;
//			}
//		}

		if (flowValues != null)
		{
			requestParameterValue = flowValues.get(parameterName);
			if (requestParameterValue != null)
			{
				return requestParameterValue;
			}
		}
		
		return parameterValues.get(parameterName);
	}

	/**
	 *
	 */
	public boolean containsParameter(String parameterName)
	{
		boolean contains = requestParameters != null && requestParameters.containsKey(parameterName);
		return contains ? contains : parameterValues.containsKey(parameterName);
	}

	/**
	 *
	 */
	public void setParameterValue(String parameterName, Object value)
	{
		parameterValues.put(parameterName, value);
	}

	/**
	 *
	 */
	public void setParameterValues(Map<String, Object> newValues)
	{
		parameterValues.putAll(newValues);
	}

	/**
	 *
	 */
	public Map<String, Object> getParameterValues()
	{
		return parameterValues;
	}

	/**
	 *
	 */
	private static final String getSessionAttributeName(String id)
	{
		return SESSION_ATTRIBUTE_REPORT_CONTEXT_ID_PREFIX + id;
	}
}
