/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.war.action;

import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import jxl.write.biff.RowsExceededException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;

import org.springframework.webflow.execution.RequestContext;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.ExportParameters;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.XlsExportParametersBean;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;


/**
 * @author Teodor Danciu (teodord@users.sourceforge.net)
 * @version $Id: ReportExcelExporter.java 19932 2010-12-11 15:24:29Z tmatyashovsky $
 */
public class ReportExcelNoPaginationExporter extends ReportExcelExporter
{

	private ViewReportAction viewReportAction;
	
	/**
	 *
	 */
	public ViewReportAction getViewReportAction() {
		return this.viewReportAction;
	}

	/**
	 *
	 */
	public void setViewReportAction(ViewReportAction viewReportAction) {
		this.viewReportAction = viewReportAction;
	}

	public void export(RequestContext context, ExecutionContext executionContext, String reportUnitURI, Map baseParameters) throws JRException,JSException {
		
		context.getRequestScope().put(getViewReportAction().getAttributeIgnorePagination(), Boolean.TRUE);
		
		ReportUnitResult result = getViewReportAction().executeReport(context);
		
		JasperPrint jasperPrint = result.getJasperPrint();
		baseParameters.put(JRExporterParameter.JASPER_PRINT, jasperPrint);
		
		super.export(context, executionContext, reportUnitURI, baseParameters);
	}

}
