/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.remote.exporters;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.HtmlExportUtil;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.LinkedHashMap;

/**
 * @author sanda zaharia (shertage@users.sourceforge.net)
 * @@version $Id: HtmlWSExporter.java 19933 2010-12-11 15:27:37Z tmatyashovsky $
 */
@Service("remoteHtmlExporter")
@Scope("prototype")
public class HtmlExporter extends AbstractExporter {

    @Override
    public JRExporter createExporter() throws Exception {
        return HtmlExportUtil.getHtmlExporter(DefaultJasperReportsContext.getInstance());
    }

    @Override
    public void configureExporter(JRExporter exporter, HashMap exportParameters) throws Exception {
        if (exportParameters.get(JRExporterParameter.IGNORE_PAGE_MARGINS) != null)
            exporter.setParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, exportParameters.get(JRExporterParameter.IGNORE_PAGE_MARGINS));

        if (exportParameters.get(Argument.RUN_OUTPUT_IMAGES_URI) != null) {
            exporter.setParameter(JRHtmlExporterParameter.IMAGES_URI, "" + exportParameters.get(Argument.RUN_OUTPUT_IMAGES_URI));
        } else {
            exporter.setParameter(JRHtmlExporterParameter.IMAGES_URI, "images/");
        }
        exporter.setParameter(JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, Boolean.TRUE);

        // collecting the images into a map
        exporter.setParameter(JRHtmlExporterParameter.IMAGES_MAP, new LinkedHashMap());

    }

    @Override
    public String getContentType() {
        return "text/html";
    }
}
