/*
 * Copyright (C) 2005 - 2012 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.api.common.util;

/**
 * <p>Monitors import process.</p>
 *
 * @author Yuriy Plakosh
 * @version $Id: ImportRunMonitor.java 24003 2012-06-02 00:59:58Z yuriy.plakosh $
 * @since 4.7.0
 */
public class ImportRunMonitor {
    private static final ThreadLocal<Boolean> threadMonitor = new ThreadLocal<Boolean>();

    public static void start() {
        threadMonitor.set(Boolean.TRUE);
    }

    public static void stop() {
        threadMonitor.set(Boolean.FALSE);
    }

    public static boolean isImportRun() {
        return threadMonitor.get() != null && threadMonitor.get();
    }
}
