/*
 * Copyright (C) 2005 - 2012 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.api.security;

import com.jaspersoft.jasperserver.api.security.encryption.EncryptionRequestUtils;
import org.apache.log4j.Logger;
import org.springframework.security.ui.webapp.AuthenticationProcessingFilter;

import javax.servlet.http.HttpServletRequest;


/**
 * Overwrites obtainUsername and obtainPassword so that decrypted values can be used.
 * EncryptionFilter must come before this so that this can pull out the decrypted values
 * for username and password.
 * @see com.jaspersoft.jasperserver.api.security.encryption.EncryptionFilter
 * @author norm
 */
public class EncryptionAuthenticationProcessingFilter extends AuthenticationProcessingFilter
{
    private static final Logger LOG = Logger.getLogger(EncryptionAuthenticationProcessingFilter.class);

    /**
     * User name is not encrypted.
     *
     * @param request A HttpServletRequest.
     * @return String value or null.
     */
    @Override
    protected String obtainUsername(HttpServletRequest request) {
        return request.getParameter(SPRING_SECURITY_FORM_USERNAME_KEY);
    }

    /**
     * When the password is encrypted in the EncryptionFilter, the encrypted value is passed into the
     * PARAM_PWD attribute.  With encryption off, the password is in the original request parameter.
     *
     * @param request A HttpServletRequest.
     * @return String or null.
     */
    @Override
    protected String obtainPassword(HttpServletRequest request) {
        return EncryptionRequestUtils.getValue(request, SPRING_SECURITY_FORM_PASSWORD_KEY);
    }
}
