/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.util.JRStyledText;

public class JRTextExporter
extends JRAbstractExporter {
    private static final String TXT_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.txt.";
    protected int pageWidthInChars;
    protected int pageHeightInChars;
    protected float charWidth;
    protected float charHeight;
    protected JRExportProgressMonitor progressMonitor;
    protected Writer writer;
    char[][] pageData;
    protected String betweenPagesText;
    protected String lineSeparator;
    protected static final String systemLineSeparator = System.getProperty("line.separator");

    public JRTextExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRTextExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    public void exportReport() throws JRException {
        StringBuffer sb;
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        this.setInput();
        if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
            this.filter = this.createFilter(TXT_EXPORTER_PROPERTIES_PREFIX);
        }
        if (!this.isModeBatch) {
            this.setPageRange();
        }
        String encoding = this.getStringParameterOrDefault(JRExporterParameter.CHARACTER_ENCODING, "net.sf.jasperreports.export.character.encoding");
        this.betweenPagesText = (String)this.parameters.get(JRTextExporterParameter.BETWEEN_PAGES_TEXT);
        if (this.betweenPagesText == null) {
            this.betweenPagesText = systemLineSeparator + systemLineSeparator;
        }
        this.lineSeparator = (String)this.parameters.get(JRTextExporterParameter.LINE_SEPARATOR);
        if (this.lineSeparator == null) {
            this.lineSeparator = systemLineSeparator;
        }
        if ((sb = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER)) != null) {
            try {
                this.writer = new StringWriter();
                this.exportReportToWriter();
                sb.append(this.writer.toString());
            }
            catch (IOException e) {
                throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), e);
            }
            finally {
                if (this.writer != null) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
        if (this.writer != null) {
            try {
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), e);
            }
        }
        OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
        if (os != null) {
            try {
                this.writer = new OutputStreamWriter(os, encoding);
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), e);
            }
        }
        File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
        if (destFile == null) {
            String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
            if (fileName != null) {
                destFile = new File(fileName);
            } else {
                throw new JRException("No output specified for the exporter.");
            }
        }
        try {
            os = new FileOutputStream(destFile);
            this.writer = new OutputStreamWriter(os, encoding);
            this.exportReportToWriter();
        }
        catch (IOException e) {
            throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), e);
        }
        finally {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void setReportParameters() throws JRException {
        this.charWidth = this.getFloatParameter(JRTextExporterParameter.CHARACTER_WIDTH, "net.sf.jasperreports.export.text.character.width", 0.0f);
        if (this.charWidth < 0.0f) {
            throw new JRException("Character width in pixels must be greater than zero.");
        }
        if (this.charWidth == 0.0f) {
            this.pageWidthInChars = this.getIntegerParameter(JRTextExporterParameter.PAGE_WIDTH, "net.sf.jasperreports.export.text.page.width", 0);
            if (this.pageWidthInChars <= 0) {
                throw new JRException("Character width in pixels or page width in characters must be specified and must be greater than zero.");
            }
            this.charWidth = (float)this.jasperPrint.getPageWidth() / (float)this.pageWidthInChars;
        } else {
            this.pageWidthInChars = (int)((float)this.jasperPrint.getPageWidth() / this.charWidth);
        }
        this.charHeight = this.getFloatParameter(JRTextExporterParameter.CHARACTER_HEIGHT, "net.sf.jasperreports.export.text.character.height", 0.0f);
        if (this.charHeight < 0.0f) {
            throw new JRException("Character height in pixels must be greater than zero.");
        }
        if (this.charHeight == 0.0f) {
            this.pageHeightInChars = this.getIntegerParameter(JRTextExporterParameter.PAGE_HEIGHT, "net.sf.jasperreports.export.text.page.height", 0);
            if (this.pageHeightInChars <= 0) {
                throw new JRException("Character height in pixels or page height in characters must be specified and must be greater than zero.");
            }
            this.charHeight = (float)this.jasperPrint.getPageHeight() / (float)this.pageHeightInChars;
        } else {
            this.pageHeightInChars = (int)((float)this.jasperPrint.getPageHeight() / this.charHeight);
        }
    }

    protected void exportReportToWriter() throws JRException, IOException {
        for (int reportIndex = 0; reportIndex < this.jasperPrintList.size(); ++reportIndex) {
            this.setJasperPrint((JasperPrint)this.jasperPrintList.get(reportIndex));
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages == null || pages.size() <= 0) continue;
            if (this.isModeBatch) {
                this.startPageIndex = 0;
                this.endPageIndex = pages.size() - 1;
            }
            this.setReportParameters();
            for (int i = this.startPageIndex; i <= this.endPageIndex; ++i) {
                if (Thread.interrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                JRPrintPage page = pages.get(i);
                this.exportPage(page);
            }
        }
        this.writer.flush();
    }

    protected void exportPage(JRPrintPage page) throws IOException {
        int i;
        List<JRPrintElement> elements = page.getElements();
        this.pageData = new char[this.pageHeightInChars][];
        for (i = 0; i < this.pageHeightInChars; ++i) {
            this.pageData[i] = new char[this.pageWidthInChars];
            Arrays.fill(this.pageData[i], ' ');
        }
        this.exportElements(elements);
        for (i = 0; i < this.pageHeightInChars; ++i) {
            this.writer.write(this.pageData[i]);
            this.writer.write(this.lineSeparator);
        }
        this.writer.write(this.betweenPagesText);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportElements(List<JRPrintElement> elements) {
        for (int i = 0; i < elements.size(); ++i) {
            JRPrintElement element = elements.get(i);
            if (element instanceof JRPrintText) {
                this.exportText((JRPrintText)element);
                continue;
            }
            if (!(element instanceof JRPrintFrame)) continue;
            JRPrintFrame frame = (JRPrintFrame)element;
            this.setFrameElementsOffset(frame, false);
            try {
                this.exportElements(frame.getElements());
                continue;
            }
            finally {
                this.restoreElementOffsets();
            }
        }
    }

    protected void exportText(JRPrintText element) {
        int i;
        JRStyledText styledText;
        int colSpan = this.getWidthInChars(element.getWidth());
        int rowSpan = this.getHeightInChars(element.getHeight());
        int col = this.getWidthInChars(element.getX() + this.getOffsetX());
        int row = this.getHeightInChars(element.getY() + this.getOffsetY());
        if (col + colSpan > this.pageWidthInChars) {
            colSpan = this.pageWidthInChars - col;
        }
        String allText = (styledText = this.getStyledText(element)) == null ? "" : styledText.getText();
        if (rowSpan <= 0 || colSpan <= 0) {
            return;
        }
        if (allText != null && allText.length() == 0) {
            return;
        }
        StringBuffer[] rows = new StringBuffer[rowSpan];
        rows[0] = new StringBuffer();
        int rowIndex = 0;
        int rowPosition = 0;
        boolean isFirstLine = true;
        StringTokenizer lfTokenizer = new StringTokenizer(allText, "\n", true);
        block9: while (lfTokenizer.hasMoreTokens()) {
            String line = lfTokenizer.nextToken();
            if (isFirstLine && line.equals("\n")) {
                rows[rowIndex].append("");
                if (++rowIndex == rowSpan || !lfTokenizer.hasMoreTokens()) break;
                rowPosition = 0;
                rows[rowIndex] = new StringBuffer();
                line = lfTokenizer.nextToken();
            }
            isFirstLine = false;
            int emptyLinesCount = 0;
            while (line.equals("\n") && lfTokenizer.hasMoreTokens()) {
                ++emptyLinesCount;
                line = lfTokenizer.nextToken();
            }
            if (emptyLinesCount > 1) {
                for (i = 0; i < emptyLinesCount - 1; ++i) {
                    rows[rowIndex].append("");
                    if (++rowIndex == rowSpan) break block9;
                    rowPosition = 0;
                    rows[rowIndex] = new StringBuffer();
                    if (lfTokenizer.hasMoreTokens() || !line.equals("\n")) continue;
                    rows[rowIndex].append("");
                    break block9;
                }
            }
            if (line.equals("\n")) continue;
            StringTokenizer spaceTokenizer = new StringTokenizer(line, " ", true);
            while (spaceTokenizer.hasMoreTokens()) {
                String word = spaceTokenizer.nextToken();
                while (word.length() > colSpan) {
                    rows[rowIndex].append(word.substring(0, colSpan - rowPosition));
                    word = word.substring(colSpan - rowPosition, word.length());
                    if (++rowIndex == rowSpan) break block9;
                    rowPosition = 0;
                    rows[rowIndex] = new StringBuffer();
                }
                if (rowPosition + word.length() > colSpan) {
                    if (++rowIndex == rowSpan) break block9;
                    rowPosition = 0;
                    rows[rowIndex] = new StringBuffer();
                }
                if (rowIndex > 0 && rowPosition == 0 && word.equals(" ")) continue;
                rows[rowIndex].append(word);
                rowPosition += word.length();
            }
            if (++rowIndex == rowSpan) break;
            rowPosition = 0;
            rows[rowIndex] = new StringBuffer();
        }
        int colOffset = 0;
        int rowOffset = 0;
        switch (element.getVerticalAlignmentValue()) {
            case BOTTOM: {
                rowOffset = rowSpan - rowIndex;
                break;
            }
            case MIDDLE: {
                rowOffset = (rowSpan - rowIndex) / 2;
            }
        }
        for (i = 0; i < rowIndex; ++i) {
            int pos;
            String line = rows[i].toString();
            for (pos = line.length() - 1; pos >= 0 && line.charAt(pos) == ' '; --pos) {
            }
            line = line.substring(0, pos + 1);
            switch (element.getHorizontalAlignmentValue()) {
                case RIGHT: {
                    colOffset = colSpan - line.length();
                    break;
                }
                case CENTER: {
                    colOffset = (colSpan - line.length()) / 2;
                    break;
                }
                case JUSTIFIED: {
                    if (i >= rowIndex - 1) break;
                    line = this.justifyText(line, colSpan);
                }
            }
            char[] chars = line.toCharArray();
            System.arraycopy(chars, 0, this.pageData[row + rowOffset + i], col + colOffset, chars.length);
        }
    }

    private String justifyText(String s, int width) {
        StringBuffer justified = new StringBuffer();
        StringTokenizer t = new StringTokenizer(s, " ");
        int tokenCount = t.countTokens();
        if (tokenCount <= 1) {
            return s;
        }
        String[] words = new String[tokenCount];
        int i = 0;
        while (t.hasMoreTokens()) {
            words[i++] = t.nextToken();
        }
        int emptySpace = width - s.length() + (words.length - 1);
        int spaceCount = emptySpace / (words.length - 1);
        int remainingSpace = emptySpace % (words.length - 1);
        char[] spaces = new char[spaceCount];
        Arrays.fill(spaces, ' ');
        for (i = 0; i < words.length - 1; ++i) {
            justified.append(words[i]);
            justified.append(spaces);
            if (i >= remainingSpace) continue;
            justified.append(' ');
        }
        justified.append(words[words.length - 1]);
        return justified.toString();
    }

    protected int getHeightInChars(int height) {
        return Math.round((float)height / this.charHeight);
    }

    protected int getWidthInChars(int width) {
        return Math.round((float)width / this.charWidth);
    }

    @Override
    protected JRStyledText getStyledText(JRPrintText textElement) {
        return textElement.getStyledText(JRStyledTextAttributeSelector.NONE);
    }

    @Override
    protected String getExporterKey() {
        return null;
    }
}

