/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.util.JRImageLoader;

public abstract class JRAbstractSvgRenderer
extends JRAbstractRenderer {
    private static final long serialVersionUID = 10200L;

    @Override
    public byte getType() {
        return this.getTypeValue().getValue();
    }

    @Override
    public byte getImageType() {
        return this.getImageTypeValue().getValue();
    }

    @Override
    public RenderableTypeEnum getTypeValue() {
        return RenderableTypeEnum.SVG;
    }

    @Override
    public ImageTypeEnum getImageTypeValue() {
        return ImageTypeEnum.PNG;
    }

    @Override
    public Dimension2D getDimension(JasperReportsContext jasperReportsContext) {
        return null;
    }

    @Override
    public Dimension2D getDimension() {
        return this.getDimension(DefaultJasperReportsContext.getInstance());
    }

    public Color getBackcolor() {
        return null;
    }

    @Override
    public byte[] getImageData() throws JRException {
        return this.getImageData(DefaultJasperReportsContext.getInstance());
    }

    @Override
    public byte[] getImageData(JasperReportsContext jasperReportsContext) throws JRException {
        int dpi = JRPropertiesUtil.getInstance(jasperReportsContext).getIntegerProperty("net.sf.jasperreports.image.dpi", 72);
        double scale = (double)dpi / 72.0;
        Dimension2D dimension = this.getDimension(jasperReportsContext);
        if (dimension != null) {
            ImageTypeEnum imageType = this.getImageTypeValue();
            BufferedImage bi = new BufferedImage((int)(scale * dimension.getWidth()), (int)(scale * dimension.getHeight()), imageType == ImageTypeEnum.GIF || imageType == ImageTypeEnum.PNG ? 2 : 1);
            Graphics2D g = this.createGraphics(bi);
            g.scale(scale, scale);
            Color backcolor = this.getBackcolor();
            if (backcolor != null) {
                g.setColor(backcolor);
                g.fillRect(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
            }
            this.render(jasperReportsContext, g, new Rectangle((int)dimension.getWidth(), (int)dimension.getHeight()));
            g.dispose();
            return JRImageLoader.getInstance(jasperReportsContext).loadBytesFromAwtImage((Image)bi, this.getImageTypeValue());
        }
        return null;
    }

    protected Graphics2D createGraphics(BufferedImage bi) {
        return bi.createGraphics();
    }
}

