/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.utils;

import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class UrlUtils {
    public static final String URLENCODING = "ISO-8859-1";

    private UrlUtils() {
    }

    public static String forceExtension(String url, String ext) {
        return UrlUtils.forceExtension(url, ".jsp", ext);
    }

    public static boolean matchPattern(HttpServletRequest req, String[] urlPattern) {
        String contextPath = req.getContextPath();
        String requestUri = req.getRequestURI();
        requestUri = requestUri.substring(contextPath.length());
        return UrlUtils.matchPattern(requestUri, urlPattern);
    }

    public static boolean matchPattern(String uri, String[] pattern) {
        for (int i = 0; i < pattern.length; ++i) {
            if (!UrlUtils.matchPattern(uri, pattern[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean matchPattern(String uri, String pattern) {
        if (pattern.equals("/*")) {
            return true;
        }
        if (pattern.equals(uri)) {
            return true;
        }
        if (pattern.startsWith("*.")) {
            return uri.endsWith(pattern.substring(2));
        }
        if (pattern.endsWith("/*")) {
            String prefix = pattern.substring(0, pattern.length() - 2);
            if (!uri.startsWith(prefix)) {
                return false;
            }
            if (uri.equals(prefix)) {
                return true;
            }
            char c = uri.charAt(prefix.length());
            return c == '/';
        }
        return false;
    }

    public static String[] parseUrlPatternList(String urlPatternList) {
        if (urlPatternList != null) {
            StringTokenizer st = new StringTokenizer(urlPatternList);
            int N = st.countTokens();
            String[] passThru = new String[N];
            for (int i = 0; i < N; ++i) {
                passThru[i] = st.nextToken();
            }
            return passThru;
        }
        return null;
    }

    public static String forceExtension(String url, String old, String ext) {
        int dot;
        if (url != null && ext != null && (dot = url.lastIndexOf(old)) >= 0) {
            int qmk = url.indexOf(63, dot);
            String queryParam = qmk > 0 ? url.substring(qmk) : "";
            url = url.substring(0, dot) + ext + queryParam;
        }
        return url;
    }

    public static String redirectURI(HttpServletRequest request, String uri) {
        if (uri.startsWith("/")) {
            StringBuffer sb = new StringBuffer();
            sb.append(request.getContextPath());
            sb.append(uri);
            uri = sb.toString();
        }
        return uri;
    }
}

