/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter.collection;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractArtifactFeatureFilter
extends AbstractArtifactsFilter {
    private List includes;
    private List excludes;

    public AbstractArtifactFeatureFilter(String include, String exclude) {
        this.setExcludes(exclude);
        this.setIncludes(include);
    }

    public Set filter(Set artifacts) {
        Set results = artifacts;
        if (this.includes != null && !this.includes.isEmpty()) {
            results = this.filterIncludes(results, this.includes);
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            results = this.filterExcludes(results, this.excludes);
        }
        return results;
    }

    private Set filterIncludes(Set artifacts, List theIncludes) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (String include : theIncludes) {
            for (Artifact artifact : artifacts) {
                if (!this.compareFeatures(this.getArtifactFeature(artifact), include)) continue;
                result.add(artifact);
            }
        }
        return result;
    }

    private Set filterExcludes(Set artifacts, List theExcludes) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            boolean exclude = false;
            Artifact artifact = (Artifact)iter.next();
            String artifactFeature = this.getArtifactFeature(artifact);
            for (String excludeFeature : theExcludes) {
                if (!this.compareFeatures(artifactFeature, excludeFeature)) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            result.add(artifact);
        }
        return result;
    }

    protected abstract String getArtifactFeature(Artifact var1);

    public void setExcludes(String excludeString) {
        if (StringUtils.isNotEmpty((String)excludeString)) {
            this.excludes = Arrays.asList(StringUtils.split((String)excludeString, (String)","));
        }
    }

    public void setIncludes(String includeString) {
        if (StringUtils.isNotEmpty((String)includeString)) {
            this.includes = Arrays.asList(StringUtils.split((String)includeString, (String)","));
        }
    }

    public List getExcludes() {
        return this.excludes;
    }

    public List getIncludes() {
        return this.includes;
    }

    protected boolean compareFeatures(String lhs, String rhs) {
        return lhs == null ? rhs == null : lhs.equals(rhs);
    }
}

